/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger.model;

/**
 * Model definition for BlogUserInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Blogger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BlogUserInfo extends com.google.api.client.json.GenericJson {

  /**
   * The Blog resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Blog blog;

  /**
   * Information about a User for the Blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("blog_user_info")
  private BlogPerUserInfo blogUserInfo;

  /**
   * The kind of this entity. Always blogger#blogUserInfo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The Blog resource.
   * @return value or {@code null} for none
   */
  public Blog getBlog() {
    return blog;
  }

  /**
   * The Blog resource.
   * @param blog blog or {@code null} for none
   */
  public BlogUserInfo setBlog(Blog blog) {
    this.blog = blog;
    return this;
  }

  /**
   * Information about a User for the Blog.
   * @return value or {@code null} for none
   */
  public BlogPerUserInfo getBlogUserInfo() {
    return blogUserInfo;
  }

  /**
   * Information about a User for the Blog.
   * @param blogUserInfo blogUserInfo or {@code null} for none
   */
  public BlogUserInfo setBlogUserInfo(BlogPerUserInfo blogUserInfo) {
    this.blogUserInfo = blogUserInfo;
    return this;
  }

  /**
   * The kind of this entity. Always blogger#blogUserInfo.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this entity. Always blogger#blogUserInfo.
   * @param kind kind or {@code null} for none
   */
  public BlogUserInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public BlogUserInfo set(String fieldName, Object value) {
    return (BlogUserInfo) super.set(fieldName, value);
  }

  @Override
  public BlogUserInfo clone() {
    return (BlogUserInfo) super.clone();
  }

}
