/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger.model;

/**
 * Model definition for Pageviews.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Blogger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Pageviews extends com.google.api.client.json.GenericJson {

  /**
   * Blog Id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String blogId;

  /**
   * The container of posts in this blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Counts> counts;

  static {
    // hack to force ProGuard to consider Counts used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Counts.class);
  }

  /**
   * The kind of this entry. Always blogger#page_views.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Blog Id.
   * @return value or {@code null} for none
   */
  public java.lang.String getBlogId() {
    return blogId;
  }

  /**
   * Blog Id.
   * @param blogId blogId or {@code null} for none
   */
  public Pageviews setBlogId(java.lang.String blogId) {
    this.blogId = blogId;
    return this;
  }

  /**
   * The container of posts in this blog.
   * @return value or {@code null} for none
   */
  public java.util.List<Counts> getCounts() {
    return counts;
  }

  /**
   * The container of posts in this blog.
   * @param counts counts or {@code null} for none
   */
  public Pageviews setCounts(java.util.List<Counts> counts) {
    this.counts = counts;
    return this;
  }

  /**
   * The kind of this entry. Always blogger#page_views.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this entry. Always blogger#page_views.
   * @param kind kind or {@code null} for none
   */
  public Pageviews setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public Pageviews set(String fieldName, Object value) {
    return (Pageviews) super.set(fieldName, value);
  }

  @Override
  public Pageviews clone() {
    return (Pageviews) super.clone();
  }

  /**
   * Model definition for PageviewsCounts.
   */
  public static final class Counts extends com.google.api.client.json.GenericJson {

    /**
     * Count of page views for the given time range.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long count;

    /**
     * Time range the given count applies to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String timeRange;

    /**
     * Count of page views for the given time range.
     * @return value or {@code null} for none
     */
    public java.lang.Long getCount() {
      return count;
    }

    /**
     * Count of page views for the given time range.
     * @param count count or {@code null} for none
     */
    public Counts setCount(java.lang.Long count) {
      this.count = count;
      return this;
    }

    /**
     * Time range the given count applies to.
     * @return value or {@code null} for none
     */
    public java.lang.String getTimeRange() {
      return timeRange;
    }

    /**
     * Time range the given count applies to.
     * @param timeRange timeRange or {@code null} for none
     */
    public Counts setTimeRange(java.lang.String timeRange) {
      this.timeRange = timeRange;
      return this;
    }

    @Override
    public Counts set(String fieldName, Object value) {
      return (Counts) super.set(fieldName, value);
    }

    @Override
    public Counts clone() {
      return (Counts) super.clone();
    }

  }

}
