/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger.model;

/**
 * Model definition for PostPerUserInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Blogger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PostPerUserInfo extends com.google.api.client.json.GenericJson {

  /**
   * ID of the Blog that the post resource belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String blogId;

  /**
   * True if the user has Author level access to the post.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasEditAccess;

  /**
   * The kind of this entity. Always blogger#postPerUserInfo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * ID of the Post resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postId;

  /**
   * ID of the User.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userId;

  /**
   * ID of the Blog that the post resource belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getBlogId() {
    return blogId;
  }

  /**
   * ID of the Blog that the post resource belongs to.
   * @param blogId blogId or {@code null} for none
   */
  public PostPerUserInfo setBlogId(java.lang.String blogId) {
    this.blogId = blogId;
    return this;
  }

  /**
   * True if the user has Author level access to the post.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasEditAccess() {
    return hasEditAccess;
  }

  /**
   * True if the user has Author level access to the post.
   * @param hasEditAccess hasEditAccess or {@code null} for none
   */
  public PostPerUserInfo setHasEditAccess(java.lang.Boolean hasEditAccess) {
    this.hasEditAccess = hasEditAccess;
    return this;
  }

  /**
   * The kind of this entity. Always blogger#postPerUserInfo.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this entity. Always blogger#postPerUserInfo.
   * @param kind kind or {@code null} for none
   */
  public PostPerUserInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * ID of the Post resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostId() {
    return postId;
  }

  /**
   * ID of the Post resource.
   * @param postId postId or {@code null} for none
   */
  public PostPerUserInfo setPostId(java.lang.String postId) {
    this.postId = postId;
    return this;
  }

  /**
   * ID of the User.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserId() {
    return userId;
  }

  /**
   * ID of the User.
   * @param userId userId or {@code null} for none
   */
  public PostPerUserInfo setUserId(java.lang.String userId) {
    this.userId = userId;
    return this;
  }

  @Override
  public PostPerUserInfo set(String fieldName, Object value) {
    return (PostPerUserInfo) super.set(fieldName, value);
  }

  @Override
  public PostPerUserInfo clone() {
    return (PostPerUserInfo) super.clone();
  }

}
