/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger.model;

/**
 * Model definition for PostUserInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Blogger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PostUserInfo extends com.google.api.client.json.GenericJson {

  /**
   * The kind of this entity. Always blogger#postUserInfo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The Post resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Post post;

  /**
   * Information about a User for the Post.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("post_user_info")
  private PostPerUserInfo postUserInfo;

  /**
   * The kind of this entity. Always blogger#postUserInfo.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this entity. Always blogger#postUserInfo.
   * @param kind kind or {@code null} for none
   */
  public PostUserInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The Post resource.
   * @return value or {@code null} for none
   */
  public Post getPost() {
    return post;
  }

  /**
   * The Post resource.
   * @param post post or {@code null} for none
   */
  public PostUserInfo setPost(Post post) {
    this.post = post;
    return this;
  }

  /**
   * Information about a User for the Post.
   * @return value or {@code null} for none
   */
  public PostPerUserInfo getPostUserInfo() {
    return postUserInfo;
  }

  /**
   * Information about a User for the Post.
   * @param postUserInfo postUserInfo or {@code null} for none
   */
  public PostUserInfo setPostUserInfo(PostPerUserInfo postUserInfo) {
    this.postUserInfo = postUserInfo;
    return this;
  }

  @Override
  public PostUserInfo set(String fieldName, Object value) {
    return (PostUserInfo) super.set(fieldName, value);
  }

  @Override
  public PostUserInfo clone() {
    return (PostUserInfo) super.clone();
  }

}
