/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger.model;

/**
 * Model definition for PostUserInfosList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Blogger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PostUserInfosList extends com.google.api.client.json.GenericJson {

  /**
   * The list of Posts with User information for the post, for this Blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PostUserInfo> items;

  static {
    // hack to force ProGuard to consider PostUserInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PostUserInfo.class);
  }

  /**
   * The kind of this entity. Always blogger#postList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Pagination token to fetch the next page, if one exists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of Posts with User information for the post, for this Blog.
   * @return value or {@code null} for none
   */
  public java.util.List<PostUserInfo> getItems() {
    return items;
  }

  /**
   * The list of Posts with User information for the post, for this Blog.
   * @param items items or {@code null} for none
   */
  public PostUserInfosList setItems(java.util.List<PostUserInfo> items) {
    this.items = items;
    return this;
  }

  /**
   * The kind of this entity. Always blogger#postList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this entity. Always blogger#postList.
   * @param kind kind or {@code null} for none
   */
  public PostUserInfosList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Pagination token to fetch the next page, if one exists.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Pagination token to fetch the next page, if one exists.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public PostUserInfosList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public PostUserInfosList set(String fieldName, Object value) {
    return (PostUserInfosList) super.set(fieldName, value);
  }

  @Override
  public PostUserInfosList clone() {
    return (PostUserInfosList) super.clone();
  }

}
