/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.blogger;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.blogger.BloggerRequest;
import com.google.api.services.blogger.BloggerRequestInitializer;
import com.google.api.services.blogger.model.Blog;
import com.google.api.services.blogger.model.BlogList;
import com.google.api.services.blogger.model.BlogUserInfo;
import com.google.api.services.blogger.model.Comment;
import com.google.api.services.blogger.model.CommentList;
import com.google.api.services.blogger.model.Page;
import com.google.api.services.blogger.model.PageList;
import com.google.api.services.blogger.model.Pageviews;
import com.google.api.services.blogger.model.Post;
import com.google.api.services.blogger.model.PostList;
import com.google.api.services.blogger.model.PostUserInfo;
import com.google.api.services.blogger.model.PostUserInfosList;
import com.google.api.services.blogger.model.User;
import java.io.IOException;
import java.util.List;

public class Blogger
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://blogger.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://blogger.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://blogger.googleapis.com/";

    public Blogger(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Blogger(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public BlogUserInfos blogUserInfos() {
        return new BlogUserInfos();
    }

    public Blogs blogs() {
        return new Blogs();
    }

    public Comments comments() {
        return new Comments();
    }

    public PageViews pageViews() {
        return new PageViews();
    }

    public Pages pages() {
        return new Pages();
    }

    public PostUserInfos postUserInfos() {
        return new PostUserInfos();
    }

    public Posts posts() {
        return new Posts();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Blogger API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Blogger.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://blogger.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Blogger.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Blogger.DEFAULT_BATCH_PATH);
        }

        public Blogger build() {
            return new Blogger(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setBloggerRequestInitializer(BloggerRequestInitializer bloggerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)bloggerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public Get get(String userId) throws IOException {
            Get result = new Get(userId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends BloggerRequest<User> {
            private static final String REST_PATH = "v3/users/{userId}";
            @Key
            private String userId;

            protected Get(String userId) {
                super(Blogger.this, "GET", REST_PATH, null, User.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Posts {
        public Delete delete(String blogId, String postId) throws IOException {
            Delete result = new Delete(blogId, postId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String blogId, String postId) throws IOException {
            Get result = new Get(blogId, postId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetByPath getByPath(String blogId, String path) throws IOException {
            GetByPath result = new GetByPath(blogId, path);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String blogId, Post content) throws IOException {
            Insert result = new Insert(blogId, content);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String blogId) throws IOException {
            List result = new List(blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String blogId, String postId, Post content) throws IOException {
            Patch result = new Patch(blogId, postId, content);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Publish publish(String blogId, String postId) throws IOException {
            Publish result = new Publish(blogId, postId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Revert revert(String blogId, String postId) throws IOException {
            Revert result = new Revert(blogId, postId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search(String blogId, String q) throws IOException {
            Search result = new Search(blogId, q);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String blogId, String postId, Post content) throws IOException {
            Update result = new Update(blogId, postId, content);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private Boolean fetchBody;
            @Key
            private Boolean fetchImages;
            @Key
            private Long maxComments;
            @Key
            private Boolean publish;
            @Key
            private Boolean revert;

            protected Update(String blogId, String postId, Post content) {
                super(Blogger.this, "PUT", REST_PATH, (Object)content, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Update setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Update setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public Boolean getFetchBody() {
                return this.fetchBody;
            }

            public Update setFetchBody(Boolean fetchBody) {
                this.fetchBody = fetchBody;
                return this;
            }

            public boolean isFetchBody() {
                if (this.fetchBody == null || this.fetchBody == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.fetchBody;
            }

            public Boolean getFetchImages() {
                return this.fetchImages;
            }

            public Update setFetchImages(Boolean fetchImages) {
                this.fetchImages = fetchImages;
                return this;
            }

            public Long getMaxComments() {
                return this.maxComments;
            }

            public Update setMaxComments(Long maxComments) {
                this.maxComments = maxComments;
                return this;
            }

            public Boolean getPublish() {
                return this.publish;
            }

            public Update setPublish(Boolean publish) {
                this.publish = publish;
                return this;
            }

            public Boolean getRevert() {
                return this.revert;
            }

            public Update setRevert(Boolean revert) {
                this.revert = revert;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Search
        extends BloggerRequest<PostList> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/search";
            @Key
            private String blogId;
            @Key
            private String q;
            @Key
            private Boolean fetchBodies;
            @Key
            private String orderBy;

            protected Search(String blogId, String q) {
                super(Blogger.this, "GET", REST_PATH, null, PostList.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.q = (String)Preconditions.checkNotNull((Object)q, (Object)"Required parameter q must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Search setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public Search setQ(String q) {
                this.q = q;
                return this;
            }

            public Boolean getFetchBodies() {
                return this.fetchBodies;
            }

            public Search setFetchBodies(Boolean fetchBodies) {
                this.fetchBodies = fetchBodies;
                return this;
            }

            public boolean isFetchBodies() {
                if (this.fetchBodies == null || this.fetchBodies == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.fetchBodies;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class Revert
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/revert";
            @Key
            private String blogId;
            @Key
            private String postId;

            protected Revert(String blogId, String postId) {
                super(Blogger.this, "POST", REST_PATH, null, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public Revert set$Xgafv(String $Xgafv) {
                return (Revert)super.set$Xgafv($Xgafv);
            }

            public Revert setAccessToken(String accessToken) {
                return (Revert)super.setAccessToken(accessToken);
            }

            public Revert setAlt(String alt) {
                return (Revert)super.setAlt(alt);
            }

            public Revert setCallback(String callback) {
                return (Revert)super.setCallback(callback);
            }

            public Revert setFields(String fields) {
                return (Revert)super.setFields(fields);
            }

            public Revert setKey(String key) {
                return (Revert)super.setKey(key);
            }

            public Revert setOauthToken(String oauthToken) {
                return (Revert)super.setOauthToken(oauthToken);
            }

            public Revert setPrettyPrint(Boolean prettyPrint) {
                return (Revert)super.setPrettyPrint(prettyPrint);
            }

            public Revert setQuotaUser(String quotaUser) {
                return (Revert)super.setQuotaUser(quotaUser);
            }

            public Revert setUploadType(String uploadType) {
                return (Revert)super.setUploadType(uploadType);
            }

            public Revert setUploadProtocol(String uploadProtocol) {
                return (Revert)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Revert setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Revert setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            @Override
            public Revert set(String parameterName, Object value) {
                return (Revert)super.set(parameterName, value);
            }
        }

        public class Publish
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/publish";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String publishDate;

            protected Publish(String blogId, String postId) {
                super(Blogger.this, "POST", REST_PATH, null, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public Publish set$Xgafv(String $Xgafv) {
                return (Publish)super.set$Xgafv($Xgafv);
            }

            public Publish setAccessToken(String accessToken) {
                return (Publish)super.setAccessToken(accessToken);
            }

            public Publish setAlt(String alt) {
                return (Publish)super.setAlt(alt);
            }

            public Publish setCallback(String callback) {
                return (Publish)super.setCallback(callback);
            }

            public Publish setFields(String fields) {
                return (Publish)super.setFields(fields);
            }

            public Publish setKey(String key) {
                return (Publish)super.setKey(key);
            }

            public Publish setOauthToken(String oauthToken) {
                return (Publish)super.setOauthToken(oauthToken);
            }

            public Publish setPrettyPrint(Boolean prettyPrint) {
                return (Publish)super.setPrettyPrint(prettyPrint);
            }

            public Publish setQuotaUser(String quotaUser) {
                return (Publish)super.setQuotaUser(quotaUser);
            }

            public Publish setUploadType(String uploadType) {
                return (Publish)super.setUploadType(uploadType);
            }

            public Publish setUploadProtocol(String uploadProtocol) {
                return (Publish)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Publish setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Publish setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getPublishDate() {
                return this.publishDate;
            }

            public Publish setPublishDate(String publishDate) {
                this.publishDate = publishDate;
                return this;
            }

            @Override
            public Publish set(String parameterName, Object value) {
                return (Publish)super.set(parameterName, value);
            }
        }

        public class Patch
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private Boolean fetchBody;
            @Key
            private Boolean fetchImages;
            @Key
            private Long maxComments;
            @Key
            private Boolean publish;
            @Key
            private Boolean revert;

            protected Patch(String blogId, String postId, Post content) {
                super(Blogger.this, "PATCH", REST_PATH, (Object)content, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Patch setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Patch setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public Boolean getFetchBody() {
                return this.fetchBody;
            }

            public Patch setFetchBody(Boolean fetchBody) {
                this.fetchBody = fetchBody;
                return this;
            }

            public boolean isFetchBody() {
                if (this.fetchBody == null || this.fetchBody == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.fetchBody;
            }

            public Boolean getFetchImages() {
                return this.fetchImages;
            }

            public Patch setFetchImages(Boolean fetchImages) {
                this.fetchImages = fetchImages;
                return this;
            }

            public Long getMaxComments() {
                return this.maxComments;
            }

            public Patch setMaxComments(Long maxComments) {
                this.maxComments = maxComments;
                return this;
            }

            public Boolean getPublish() {
                return this.publish;
            }

            public Patch setPublish(Boolean publish) {
                this.publish = publish;
                return this;
            }

            public Boolean getRevert() {
                return this.revert;
            }

            public Patch setRevert(Boolean revert) {
                this.revert = revert;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BloggerRequest<PostList> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts";
            @Key
            private String blogId;
            @Key
            private String endDate;
            @Key
            private Boolean fetchBodies;
            @Key
            private Boolean fetchImages;
            @Key
            private String labels;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String startDate;
            @Key
            private java.util.List<String> status;
            @Key
            private String view;

            protected List(String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, PostList.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public List setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public List setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public Boolean getFetchBodies() {
                return this.fetchBodies;
            }

            public List setFetchBodies(Boolean fetchBodies) {
                this.fetchBodies = fetchBodies;
                return this;
            }

            public boolean isFetchBodies() {
                if (this.fetchBodies == null || this.fetchBodies == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.fetchBodies;
            }

            public Boolean getFetchImages() {
                return this.fetchImages;
            }

            public List setFetchImages(Boolean fetchImages) {
                this.fetchImages = fetchImages;
                return this;
            }

            public String getLabels() {
                return this.labels;
            }

            public List setLabels(String labels) {
                this.labels = labels;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public List setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public java.util.List<String> getStatus() {
                return this.status;
            }

            public List setStatus(java.util.List<String> status) {
                this.status = status;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts";
            @Key
            private String blogId;
            @Key
            private Boolean fetchBody;
            @Key
            private Boolean fetchImages;
            @Key
            private Boolean isDraft;

            protected Insert(String blogId, Post content) {
                super(Blogger.this, "POST", REST_PATH, (Object)content, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Insert setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public Boolean getFetchBody() {
                return this.fetchBody;
            }

            public Insert setFetchBody(Boolean fetchBody) {
                this.fetchBody = fetchBody;
                return this;
            }

            public boolean isFetchBody() {
                if (this.fetchBody == null || this.fetchBody == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.fetchBody;
            }

            public Boolean getFetchImages() {
                return this.fetchImages;
            }

            public Insert setFetchImages(Boolean fetchImages) {
                this.fetchImages = fetchImages;
                return this;
            }

            public Boolean getIsDraft() {
                return this.isDraft;
            }

            public Insert setIsDraft(Boolean isDraft) {
                this.isDraft = isDraft;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetByPath
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/bypath";
            @Key
            private String blogId;
            @Key
            private String path;
            @Key
            private Long maxComments;
            @Key
            private String view;

            protected GetByPath(String blogId, String path) {
                super(Blogger.this, "GET", REST_PATH, null, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"Required parameter path must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetByPath set$Xgafv(String $Xgafv) {
                return (GetByPath)super.set$Xgafv($Xgafv);
            }

            public GetByPath setAccessToken(String accessToken) {
                return (GetByPath)super.setAccessToken(accessToken);
            }

            public GetByPath setAlt(String alt) {
                return (GetByPath)super.setAlt(alt);
            }

            public GetByPath setCallback(String callback) {
                return (GetByPath)super.setCallback(callback);
            }

            public GetByPath setFields(String fields) {
                return (GetByPath)super.setFields(fields);
            }

            public GetByPath setKey(String key) {
                return (GetByPath)super.setKey(key);
            }

            public GetByPath setOauthToken(String oauthToken) {
                return (GetByPath)super.setOauthToken(oauthToken);
            }

            public GetByPath setPrettyPrint(Boolean prettyPrint) {
                return (GetByPath)super.setPrettyPrint(prettyPrint);
            }

            public GetByPath setQuotaUser(String quotaUser) {
                return (GetByPath)super.setQuotaUser(quotaUser);
            }

            public GetByPath setUploadType(String uploadType) {
                return (GetByPath)super.setUploadType(uploadType);
            }

            public GetByPath setUploadProtocol(String uploadProtocol) {
                return (GetByPath)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public GetByPath setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPath() {
                return this.path;
            }

            public GetByPath setPath(String path) {
                this.path = path;
                return this;
            }

            public Long getMaxComments() {
                return this.maxComments;
            }

            public GetByPath setMaxComments(Long maxComments) {
                this.maxComments = maxComments;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public GetByPath setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public GetByPath set(String parameterName, Object value) {
                return (GetByPath)super.set(parameterName, value);
            }
        }

        public class Get
        extends BloggerRequest<Post> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private Boolean fetchBody;
            @Key
            private Boolean fetchImages;
            @Key
            private Long maxComments;
            @Key
            private String view;

            protected Get(String blogId, String postId) {
                super(Blogger.this, "GET", REST_PATH, null, Post.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Get setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public Boolean getFetchBody() {
                return this.fetchBody;
            }

            public Get setFetchBody(Boolean fetchBody) {
                this.fetchBody = fetchBody;
                return this;
            }

            public boolean isFetchBody() {
                if (this.fetchBody == null || this.fetchBody == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.fetchBody;
            }

            public Boolean getFetchImages() {
                return this.fetchImages;
            }

            public Get setFetchImages(Boolean fetchImages) {
                this.fetchImages = fetchImages;
                return this;
            }

            public Long getMaxComments() {
                return this.maxComments;
            }

            public Get setMaxComments(Long maxComments) {
                this.maxComments = maxComments;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BloggerRequest<Void> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";
            @Key
            private String blogId;
            @Key
            private String postId;

            protected Delete(String blogId, String postId) {
                super(Blogger.this, "DELETE", REST_PATH, null, Void.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Delete setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Delete setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class PostUserInfos {
        public Get get(String userId, String blogId, String postId) throws IOException {
            Get result = new Get(userId, blogId, postId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userId, String blogId) throws IOException {
            List result = new List(userId, blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends BloggerRequest<PostUserInfosList> {
            private static final String REST_PATH = "v3/users/{userId}/blogs/{blogId}/posts";
            @Key
            private String userId;
            @Key
            private String blogId;
            @Key
            private String endDate;
            @Key
            private Boolean fetchBodies;
            @Key
            private String labels;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String startDate;
            @Key
            private java.util.List<String> status;
            @Key
            private String view;

            protected List(String userId, String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, PostUserInfosList.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getBlogId() {
                return this.blogId;
            }

            public List setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public List setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public Boolean getFetchBodies() {
                return this.fetchBodies;
            }

            public List setFetchBodies(Boolean fetchBodies) {
                this.fetchBodies = fetchBodies;
                return this;
            }

            public boolean isFetchBodies() {
                if (this.fetchBodies == null || this.fetchBodies == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.fetchBodies;
            }

            public String getLabels() {
                return this.labels;
            }

            public List setLabels(String labels) {
                this.labels = labels;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public List setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public java.util.List<String> getStatus() {
                return this.status;
            }

            public List setStatus(java.util.List<String> status) {
                this.status = status;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BloggerRequest<PostUserInfo> {
            private static final String REST_PATH = "v3/users/{userId}/blogs/{blogId}/posts/{postId}";
            @Key
            private String userId;
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private Long maxComments;

            protected Get(String userId, String blogId, String postId) {
                super(Blogger.this, "GET", REST_PATH, null, PostUserInfo.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Get setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public Long getMaxComments() {
                return this.maxComments;
            }

            public Get setMaxComments(Long maxComments) {
                this.maxComments = maxComments;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Pages {
        public Delete delete(String blogId, String pageId) throws IOException {
            Delete result = new Delete(blogId, pageId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String blogId, String pageId) throws IOException {
            Get result = new Get(blogId, pageId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String blogId, Page content) throws IOException {
            Insert result = new Insert(blogId, content);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String blogId) throws IOException {
            List result = new List(blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String blogId, String pageId, Page content) throws IOException {
            Patch result = new Patch(blogId, pageId, content);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Publish publish(String blogId, String pageId) throws IOException {
            Publish result = new Publish(blogId, pageId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Revert revert(String blogId, String pageId) throws IOException {
            Revert result = new Revert(blogId, pageId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String blogId, String pageId, Page content) throws IOException {
            Update result = new Update(blogId, pageId, content);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends BloggerRequest<Page> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";
            @Key
            private String blogId;
            @Key
            private String pageId;
            @Key
            private Boolean publish;
            @Key
            private Boolean revert;

            protected Update(String blogId, String pageId, Page content) {
                super(Blogger.this, "PUT", REST_PATH, (Object)content, Page.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.pageId = (String)Preconditions.checkNotNull((Object)pageId, (Object)"Required parameter pageId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Update setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPageId() {
                return this.pageId;
            }

            public Update setPageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            public Boolean getPublish() {
                return this.publish;
            }

            public Update setPublish(Boolean publish) {
                this.publish = publish;
                return this;
            }

            public Boolean getRevert() {
                return this.revert;
            }

            public Update setRevert(Boolean revert) {
                this.revert = revert;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Revert
        extends BloggerRequest<Page> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}/revert";
            @Key
            private String blogId;
            @Key
            private String pageId;

            protected Revert(String blogId, String pageId) {
                super(Blogger.this, "POST", REST_PATH, null, Page.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.pageId = (String)Preconditions.checkNotNull((Object)pageId, (Object)"Required parameter pageId must be specified.");
            }

            public Revert set$Xgafv(String $Xgafv) {
                return (Revert)super.set$Xgafv($Xgafv);
            }

            public Revert setAccessToken(String accessToken) {
                return (Revert)super.setAccessToken(accessToken);
            }

            public Revert setAlt(String alt) {
                return (Revert)super.setAlt(alt);
            }

            public Revert setCallback(String callback) {
                return (Revert)super.setCallback(callback);
            }

            public Revert setFields(String fields) {
                return (Revert)super.setFields(fields);
            }

            public Revert setKey(String key) {
                return (Revert)super.setKey(key);
            }

            public Revert setOauthToken(String oauthToken) {
                return (Revert)super.setOauthToken(oauthToken);
            }

            public Revert setPrettyPrint(Boolean prettyPrint) {
                return (Revert)super.setPrettyPrint(prettyPrint);
            }

            public Revert setQuotaUser(String quotaUser) {
                return (Revert)super.setQuotaUser(quotaUser);
            }

            public Revert setUploadType(String uploadType) {
                return (Revert)super.setUploadType(uploadType);
            }

            public Revert setUploadProtocol(String uploadProtocol) {
                return (Revert)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Revert setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPageId() {
                return this.pageId;
            }

            public Revert setPageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            @Override
            public Revert set(String parameterName, Object value) {
                return (Revert)super.set(parameterName, value);
            }
        }

        public class Publish
        extends BloggerRequest<Page> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}/publish";
            @Key
            private String blogId;
            @Key
            private String pageId;

            protected Publish(String blogId, String pageId) {
                super(Blogger.this, "POST", REST_PATH, null, Page.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.pageId = (String)Preconditions.checkNotNull((Object)pageId, (Object)"Required parameter pageId must be specified.");
            }

            public Publish set$Xgafv(String $Xgafv) {
                return (Publish)super.set$Xgafv($Xgafv);
            }

            public Publish setAccessToken(String accessToken) {
                return (Publish)super.setAccessToken(accessToken);
            }

            public Publish setAlt(String alt) {
                return (Publish)super.setAlt(alt);
            }

            public Publish setCallback(String callback) {
                return (Publish)super.setCallback(callback);
            }

            public Publish setFields(String fields) {
                return (Publish)super.setFields(fields);
            }

            public Publish setKey(String key) {
                return (Publish)super.setKey(key);
            }

            public Publish setOauthToken(String oauthToken) {
                return (Publish)super.setOauthToken(oauthToken);
            }

            public Publish setPrettyPrint(Boolean prettyPrint) {
                return (Publish)super.setPrettyPrint(prettyPrint);
            }

            public Publish setQuotaUser(String quotaUser) {
                return (Publish)super.setQuotaUser(quotaUser);
            }

            public Publish setUploadType(String uploadType) {
                return (Publish)super.setUploadType(uploadType);
            }

            public Publish setUploadProtocol(String uploadProtocol) {
                return (Publish)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Publish setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPageId() {
                return this.pageId;
            }

            public Publish setPageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            @Override
            public Publish set(String parameterName, Object value) {
                return (Publish)super.set(parameterName, value);
            }
        }

        public class Patch
        extends BloggerRequest<Page> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";
            @Key
            private String blogId;
            @Key
            private String pageId;
            @Key
            private Boolean publish;
            @Key
            private Boolean revert;

            protected Patch(String blogId, String pageId, Page content) {
                super(Blogger.this, "PATCH", REST_PATH, (Object)content, Page.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.pageId = (String)Preconditions.checkNotNull((Object)pageId, (Object)"Required parameter pageId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Patch setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPageId() {
                return this.pageId;
            }

            public Patch setPageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            public Boolean getPublish() {
                return this.publish;
            }

            public Patch setPublish(Boolean publish) {
                this.publish = publish;
                return this;
            }

            public Boolean getRevert() {
                return this.revert;
            }

            public Patch setRevert(Boolean revert) {
                this.revert = revert;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends BloggerRequest<PageList> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages";
            @Key
            private String blogId;
            @Key
            private Boolean fetchBodies;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> status;
            @Key
            private String view;

            protected List(String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, PageList.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public List setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public Boolean getFetchBodies() {
                return this.fetchBodies;
            }

            public List setFetchBodies(Boolean fetchBodies) {
                this.fetchBodies = fetchBodies;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getStatus() {
                return this.status;
            }

            public List setStatus(java.util.List<String> status) {
                this.status = status;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends BloggerRequest<Page> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages";
            @Key
            private String blogId;
            @Key
            private Boolean isDraft;

            protected Insert(String blogId, Page content) {
                super(Blogger.this, "POST", REST_PATH, (Object)content, Page.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Insert setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public Boolean getIsDraft() {
                return this.isDraft;
            }

            public Insert setIsDraft(Boolean isDraft) {
                this.isDraft = isDraft;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends BloggerRequest<Page> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";
            @Key
            private String blogId;
            @Key
            private String pageId;
            @Key
            private String view;

            protected Get(String blogId, String pageId) {
                super(Blogger.this, "GET", REST_PATH, null, Page.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.pageId = (String)Preconditions.checkNotNull((Object)pageId, (Object)"Required parameter pageId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPageId() {
                return this.pageId;
            }

            public Get setPageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BloggerRequest<Void> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";
            @Key
            private String blogId;
            @Key
            private String pageId;

            protected Delete(String blogId, String pageId) {
                super(Blogger.this, "DELETE", REST_PATH, null, Void.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.pageId = (String)Preconditions.checkNotNull((Object)pageId, (Object)"Required parameter pageId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Delete setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPageId() {
                return this.pageId;
            }

            public Delete setPageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class PageViews {
        public Get get(String blogId) throws IOException {
            Get result = new Get(blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends BloggerRequest<Pageviews> {
            private static final String REST_PATH = "v3/blogs/{blogId}/pageviews";
            @Key
            private String blogId;
            @Key
            private List<String> range;

            protected Get(String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, Pageviews.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public List<String> getRange() {
                return this.range;
            }

            public Get setRange(List<String> range) {
                this.range = range;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Comments {
        public Approve approve(String blogId, String postId, String commentId) throws IOException {
            Approve result = new Approve(blogId, postId, commentId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String blogId, String postId, String commentId) throws IOException {
            Delete result = new Delete(blogId, postId, commentId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String blogId, String postId, String commentId) throws IOException {
            Get result = new Get(blogId, postId, commentId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String blogId, String postId) throws IOException {
            List result = new List(blogId, postId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListByBlog listByBlog(String blogId) throws IOException {
            ListByBlog result = new ListByBlog(blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public MarkAsSpam markAsSpam(String blogId, String postId, String commentId) throws IOException {
            MarkAsSpam result = new MarkAsSpam(blogId, postId, commentId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RemoveContent removeContent(String blogId, String postId, String commentId) throws IOException {
            RemoveContent result = new RemoveContent(blogId, postId, commentId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class RemoveContent
        extends BloggerRequest<Comment> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}/removecontent";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String commentId;

            protected RemoveContent(String blogId, String postId, String commentId) {
                super(Blogger.this, "POST", REST_PATH, null, Comment.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public RemoveContent set$Xgafv(String $Xgafv) {
                return (RemoveContent)super.set$Xgafv($Xgafv);
            }

            public RemoveContent setAccessToken(String accessToken) {
                return (RemoveContent)super.setAccessToken(accessToken);
            }

            public RemoveContent setAlt(String alt) {
                return (RemoveContent)super.setAlt(alt);
            }

            public RemoveContent setCallback(String callback) {
                return (RemoveContent)super.setCallback(callback);
            }

            public RemoveContent setFields(String fields) {
                return (RemoveContent)super.setFields(fields);
            }

            public RemoveContent setKey(String key) {
                return (RemoveContent)super.setKey(key);
            }

            public RemoveContent setOauthToken(String oauthToken) {
                return (RemoveContent)super.setOauthToken(oauthToken);
            }

            public RemoveContent setPrettyPrint(Boolean prettyPrint) {
                return (RemoveContent)super.setPrettyPrint(prettyPrint);
            }

            public RemoveContent setQuotaUser(String quotaUser) {
                return (RemoveContent)super.setQuotaUser(quotaUser);
            }

            public RemoveContent setUploadType(String uploadType) {
                return (RemoveContent)super.setUploadType(uploadType);
            }

            public RemoveContent setUploadProtocol(String uploadProtocol) {
                return (RemoveContent)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public RemoveContent setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public RemoveContent setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public RemoveContent setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public RemoveContent set(String parameterName, Object value) {
                return (RemoveContent)super.set(parameterName, value);
            }
        }

        public class MarkAsSpam
        extends BloggerRequest<Comment> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}/spam";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String commentId;

            protected MarkAsSpam(String blogId, String postId, String commentId) {
                super(Blogger.this, "POST", REST_PATH, null, Comment.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public MarkAsSpam set$Xgafv(String $Xgafv) {
                return (MarkAsSpam)super.set$Xgafv($Xgafv);
            }

            public MarkAsSpam setAccessToken(String accessToken) {
                return (MarkAsSpam)super.setAccessToken(accessToken);
            }

            public MarkAsSpam setAlt(String alt) {
                return (MarkAsSpam)super.setAlt(alt);
            }

            public MarkAsSpam setCallback(String callback) {
                return (MarkAsSpam)super.setCallback(callback);
            }

            public MarkAsSpam setFields(String fields) {
                return (MarkAsSpam)super.setFields(fields);
            }

            public MarkAsSpam setKey(String key) {
                return (MarkAsSpam)super.setKey(key);
            }

            public MarkAsSpam setOauthToken(String oauthToken) {
                return (MarkAsSpam)super.setOauthToken(oauthToken);
            }

            public MarkAsSpam setPrettyPrint(Boolean prettyPrint) {
                return (MarkAsSpam)super.setPrettyPrint(prettyPrint);
            }

            public MarkAsSpam setQuotaUser(String quotaUser) {
                return (MarkAsSpam)super.setQuotaUser(quotaUser);
            }

            public MarkAsSpam setUploadType(String uploadType) {
                return (MarkAsSpam)super.setUploadType(uploadType);
            }

            public MarkAsSpam setUploadProtocol(String uploadProtocol) {
                return (MarkAsSpam)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public MarkAsSpam setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public MarkAsSpam setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public MarkAsSpam setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public MarkAsSpam set(String parameterName, Object value) {
                return (MarkAsSpam)super.set(parameterName, value);
            }
        }

        public class ListByBlog
        extends BloggerRequest<CommentList> {
            private static final String REST_PATH = "v3/blogs/{blogId}/comments";
            @Key
            private String blogId;
            @Key
            private String endDate;
            @Key
            private Boolean fetchBodies;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String startDate;
            @Key
            private java.util.List<String> status;

            protected ListByBlog(String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, CommentList.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByBlog set$Xgafv(String $Xgafv) {
                return (ListByBlog)super.set$Xgafv($Xgafv);
            }

            public ListByBlog setAccessToken(String accessToken) {
                return (ListByBlog)super.setAccessToken(accessToken);
            }

            public ListByBlog setAlt(String alt) {
                return (ListByBlog)super.setAlt(alt);
            }

            public ListByBlog setCallback(String callback) {
                return (ListByBlog)super.setCallback(callback);
            }

            public ListByBlog setFields(String fields) {
                return (ListByBlog)super.setFields(fields);
            }

            public ListByBlog setKey(String key) {
                return (ListByBlog)super.setKey(key);
            }

            public ListByBlog setOauthToken(String oauthToken) {
                return (ListByBlog)super.setOauthToken(oauthToken);
            }

            public ListByBlog setPrettyPrint(Boolean prettyPrint) {
                return (ListByBlog)super.setPrettyPrint(prettyPrint);
            }

            public ListByBlog setQuotaUser(String quotaUser) {
                return (ListByBlog)super.setQuotaUser(quotaUser);
            }

            public ListByBlog setUploadType(String uploadType) {
                return (ListByBlog)super.setUploadType(uploadType);
            }

            public ListByBlog setUploadProtocol(String uploadProtocol) {
                return (ListByBlog)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public ListByBlog setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public ListByBlog setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public Boolean getFetchBodies() {
                return this.fetchBodies;
            }

            public ListByBlog setFetchBodies(Boolean fetchBodies) {
                this.fetchBodies = fetchBodies;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByBlog setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByBlog setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public ListByBlog setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public java.util.List<String> getStatus() {
                return this.status;
            }

            public ListByBlog setStatus(java.util.List<String> status) {
                this.status = status;
                return this;
            }

            @Override
            public ListByBlog set(String parameterName, Object value) {
                return (ListByBlog)super.set(parameterName, value);
            }
        }

        public class List
        extends BloggerRequest<CommentList> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String endDate;
            @Key
            private Boolean fetchBodies;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String startDate;
            @Key
            private String status;
            @Key
            private String view;

            protected List(String blogId, String postId) {
                super(Blogger.this, "GET", REST_PATH, null, CommentList.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public List setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public List setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public List setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public Boolean getFetchBodies() {
                return this.fetchBodies;
            }

            public List setFetchBodies(Boolean fetchBodies) {
                this.fetchBodies = fetchBodies;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public List setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public String getStatus() {
                return this.status;
            }

            public List setStatus(String status) {
                this.status = status;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BloggerRequest<Comment> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String commentId;
            @Key
            private String view;

            protected Get(String blogId, String postId, String commentId) {
                super(Blogger.this, "GET", REST_PATH, null, Comment.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Get setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends BloggerRequest<Void> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String commentId;

            protected Delete(String blogId, String postId, String commentId) {
                super(Blogger.this, "DELETE", REST_PATH, null, Void.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Delete setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Delete setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Approve
        extends BloggerRequest<Comment> {
            private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}/approve";
            @Key
            private String blogId;
            @Key
            private String postId;
            @Key
            private String commentId;

            protected Approve(String blogId, String postId, String commentId) {
                super(Blogger.this, "POST", REST_PATH, null, Comment.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
                this.postId = (String)Preconditions.checkNotNull((Object)postId, (Object)"Required parameter postId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public Approve set$Xgafv(String $Xgafv) {
                return (Approve)super.set$Xgafv($Xgafv);
            }

            public Approve setAccessToken(String accessToken) {
                return (Approve)super.setAccessToken(accessToken);
            }

            public Approve setAlt(String alt) {
                return (Approve)super.setAlt(alt);
            }

            public Approve setCallback(String callback) {
                return (Approve)super.setCallback(callback);
            }

            public Approve setFields(String fields) {
                return (Approve)super.setFields(fields);
            }

            public Approve setKey(String key) {
                return (Approve)super.setKey(key);
            }

            public Approve setOauthToken(String oauthToken) {
                return (Approve)super.setOauthToken(oauthToken);
            }

            public Approve setPrettyPrint(Boolean prettyPrint) {
                return (Approve)super.setPrettyPrint(prettyPrint);
            }

            public Approve setQuotaUser(String quotaUser) {
                return (Approve)super.setQuotaUser(quotaUser);
            }

            public Approve setUploadType(String uploadType) {
                return (Approve)super.setUploadType(uploadType);
            }

            public Approve setUploadProtocol(String uploadProtocol) {
                return (Approve)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Approve setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public String getPostId() {
                return this.postId;
            }

            public Approve setPostId(String postId) {
                this.postId = postId;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Approve setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Approve set(String parameterName, Object value) {
                return (Approve)super.set(parameterName, value);
            }
        }
    }

    public class Blogs {
        public Get get(String blogId) throws IOException {
            Get result = new Get(blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetByUrl getByUrl(String url) throws IOException {
            GetByUrl result = new GetByUrl(url);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListByUser listByUser(String userId) throws IOException {
            ListByUser result = new ListByUser(userId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ListByUser
        extends BloggerRequest<BlogList> {
            private static final String REST_PATH = "v3/users/{userId}/blogs";
            @Key
            private String userId;
            @Key
            private Boolean fetchUserInfo;
            @Key
            private List<String> role;
            @Key
            private List<String> status;
            @Key
            private String view;

            protected ListByUser(String userId) {
                super(Blogger.this, "GET", REST_PATH, null, BlogList.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByUser set$Xgafv(String $Xgafv) {
                return (ListByUser)super.set$Xgafv($Xgafv);
            }

            public ListByUser setAccessToken(String accessToken) {
                return (ListByUser)super.setAccessToken(accessToken);
            }

            public ListByUser setAlt(String alt) {
                return (ListByUser)super.setAlt(alt);
            }

            public ListByUser setCallback(String callback) {
                return (ListByUser)super.setCallback(callback);
            }

            public ListByUser setFields(String fields) {
                return (ListByUser)super.setFields(fields);
            }

            public ListByUser setKey(String key) {
                return (ListByUser)super.setKey(key);
            }

            public ListByUser setOauthToken(String oauthToken) {
                return (ListByUser)super.setOauthToken(oauthToken);
            }

            public ListByUser setPrettyPrint(Boolean prettyPrint) {
                return (ListByUser)super.setPrettyPrint(prettyPrint);
            }

            public ListByUser setQuotaUser(String quotaUser) {
                return (ListByUser)super.setQuotaUser(quotaUser);
            }

            public ListByUser setUploadType(String uploadType) {
                return (ListByUser)super.setUploadType(uploadType);
            }

            public ListByUser setUploadProtocol(String uploadProtocol) {
                return (ListByUser)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public ListByUser setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public Boolean getFetchUserInfo() {
                return this.fetchUserInfo;
            }

            public ListByUser setFetchUserInfo(Boolean fetchUserInfo) {
                this.fetchUserInfo = fetchUserInfo;
                return this;
            }

            public List<String> getRole() {
                return this.role;
            }

            public ListByUser setRole(List<String> role) {
                this.role = role;
                return this;
            }

            public List<String> getStatus() {
                return this.status;
            }

            public ListByUser setStatus(List<String> status) {
                this.status = status;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public ListByUser setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public ListByUser set(String parameterName, Object value) {
                return (ListByUser)super.set(parameterName, value);
            }
        }

        public class GetByUrl
        extends BloggerRequest<Blog> {
            private static final String REST_PATH = "v3/blogs/byurl";
            @Key
            private String url;
            @Key
            private String view;

            protected GetByUrl(String url) {
                super(Blogger.this, "GET", REST_PATH, null, Blog.class);
                this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"Required parameter url must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetByUrl set$Xgafv(String $Xgafv) {
                return (GetByUrl)super.set$Xgafv($Xgafv);
            }

            public GetByUrl setAccessToken(String accessToken) {
                return (GetByUrl)super.setAccessToken(accessToken);
            }

            public GetByUrl setAlt(String alt) {
                return (GetByUrl)super.setAlt(alt);
            }

            public GetByUrl setCallback(String callback) {
                return (GetByUrl)super.setCallback(callback);
            }

            public GetByUrl setFields(String fields) {
                return (GetByUrl)super.setFields(fields);
            }

            public GetByUrl setKey(String key) {
                return (GetByUrl)super.setKey(key);
            }

            public GetByUrl setOauthToken(String oauthToken) {
                return (GetByUrl)super.setOauthToken(oauthToken);
            }

            public GetByUrl setPrettyPrint(Boolean prettyPrint) {
                return (GetByUrl)super.setPrettyPrint(prettyPrint);
            }

            public GetByUrl setQuotaUser(String quotaUser) {
                return (GetByUrl)super.setQuotaUser(quotaUser);
            }

            public GetByUrl setUploadType(String uploadType) {
                return (GetByUrl)super.setUploadType(uploadType);
            }

            public GetByUrl setUploadProtocol(String uploadProtocol) {
                return (GetByUrl)super.setUploadProtocol(uploadProtocol);
            }

            public String getUrl() {
                return this.url;
            }

            public GetByUrl setUrl(String url) {
                this.url = url;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public GetByUrl setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public GetByUrl set(String parameterName, Object value) {
                return (GetByUrl)super.set(parameterName, value);
            }
        }

        public class Get
        extends BloggerRequest<Blog> {
            private static final String REST_PATH = "v3/blogs/{blogId}";
            @Key
            private String blogId;
            @Key
            private Long maxPosts;
            @Key
            private String view;

            protected Get(String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, Blog.class);
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public Long getMaxPosts() {
                return this.maxPosts;
            }

            public Get setMaxPosts(Long maxPosts) {
                this.maxPosts = maxPosts;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class BlogUserInfos {
        public Get get(String userId, String blogId) throws IOException {
            Get result = new Get(userId, blogId);
            Blogger.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends BloggerRequest<BlogUserInfo> {
            private static final String REST_PATH = "v3/users/{userId}/blogs/{blogId}";
            @Key
            private String userId;
            @Key
            private String blogId;
            @Key
            private Long maxPosts;

            protected Get(String userId, String blogId) {
                super(Blogger.this, "GET", REST_PATH, null, BlogUserInfo.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                this.blogId = (String)Preconditions.checkNotNull((Object)blogId, (Object)"Required parameter blogId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getBlogId() {
                return this.blogId;
            }

            public Get setBlogId(String blogId) {
                this.blogId = blogId;
                return this;
            }

            public Long getMaxPosts() {
                return this.maxPosts;
            }

            public Get setMaxPosts(Long maxPosts) {
                this.maxPosts = maxPosts;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

