/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.books.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.books.v1.BooksRequest;
import com.google.api.services.books.v1.BooksRequestInitializer;
import com.google.api.services.books.v1.model.Annotation;
import com.google.api.services.books.v1.model.Annotations;
import com.google.api.services.books.v1.model.AnnotationsSummary;
import com.google.api.services.books.v1.model.Annotationsdata;
import com.google.api.services.books.v1.model.BooksCloudloadingResource;
import com.google.api.services.books.v1.model.BooksVolumesRecommendedRateResponse;
import com.google.api.services.books.v1.model.Bookshelf;
import com.google.api.services.books.v1.model.Category;
import com.google.api.services.books.v1.model.DictionaryAnnotationdata;
import com.google.api.services.books.v1.model.Discoveryclusters;
import com.google.api.services.books.v1.model.DownloadAccesses;
import com.google.api.services.books.v1.model.Empty;
import com.google.api.services.books.v1.model.FamilyInfo;
import com.google.api.services.books.v1.model.Layersummaries;
import com.google.api.services.books.v1.model.Layersummary;
import com.google.api.services.books.v1.model.Metadata;
import com.google.api.services.books.v1.model.Offers;
import com.google.api.services.books.v1.model.ReadingPosition;
import com.google.api.services.books.v1.model.RequestAccessData;
import com.google.api.services.books.v1.model.Seriesmembership;
import com.google.api.services.books.v1.model.Usersettings;
import com.google.api.services.books.v1.model.Volume;
import com.google.api.services.books.v1.model.Volume2;
import com.google.api.services.books.v1.model.Volumeannotation;
import com.google.api.services.books.v1.model.Volumeannotations;
import java.io.IOException;
import java.util.List;

public class Books
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://books.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://books.googleapis.com/";

    public Books(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Books(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Bookshelves bookshelves() {
        return new Bookshelves();
    }

    public Cloudloading cloudloading() {
        return new Cloudloading();
    }

    public Dictionary dictionary() {
        return new Dictionary();
    }

    public Familysharing familysharing() {
        return new Familysharing();
    }

    public Layers layers() {
        return new Layers();
    }

    public Myconfig myconfig() {
        return new Myconfig();
    }

    public Mylibrary mylibrary() {
        return new Mylibrary();
    }

    public Notification notification() {
        return new Notification();
    }

    public Onboarding onboarding() {
        return new Onboarding();
    }

    public Personalizedstream personalizedstream() {
        return new Personalizedstream();
    }

    public Promooffer promooffer() {
        return new Promooffer();
    }

    public Series series() {
        return new Series();
    }

    public Volumes volumes() {
        return new Volumes();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Books API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://books.googleapis.com/", Books.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Books.DEFAULT_BATCH_PATH);
        }

        public Books build() {
            return new Books(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setBooksRequestInitializer(BooksRequestInitializer booksRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)booksRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Volumes {
        public Get get(String volumeId) throws IOException {
            Get result = new Get(volumeId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String q) throws IOException {
            List result = new List(q);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Associated associated() {
            return new Associated();
        }

        public Mybooks mybooks() {
            return new Mybooks();
        }

        public Recommended recommended() {
            return new Recommended();
        }

        public Useruploaded useruploaded() {
            return new Useruploaded();
        }

        public class Useruploaded {
            public List list() throws IOException {
                List result = new List();
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
                private static final String REST_PATH = "books/v1/volumes/useruploaded";
                @Key
                private String locale;
                @Key
                private Long maxResults;
                @Key
                private java.util.List<String> processingState;
                @Key
                private String source;
                @Key
                private Long startIndex;
                @Key
                private java.util.List<String> volumeId;

                protected List() {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getLocale() {
                    return this.locale;
                }

                public List setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public java.util.List<String> getProcessingState() {
                    return this.processingState;
                }

                public List setProcessingState(java.util.List<String> processingState) {
                    this.processingState = processingState;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                public java.util.List<String> getVolumeId() {
                    return this.volumeId;
                }

                public List setVolumeId(java.util.List<String> volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Recommended {
            public List list() throws IOException {
                List result = new List();
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Rate rate(String rating, String volumeId) throws IOException {
                Rate result = new Rate(rating, volumeId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Rate
            extends BooksRequest<BooksVolumesRecommendedRateResponse> {
                private static final String REST_PATH = "books/v1/volumes/recommended/rate";
                @Key
                private String rating;
                @Key
                private String volumeId;
                @Key
                private String locale;
                @Key
                private String source;

                protected Rate(String rating, String volumeId) {
                    super(Books.this, "POST", REST_PATH, null, BooksVolumesRecommendedRateResponse.class);
                    this.rating = (String)Preconditions.checkNotNull((Object)rating, (Object)"Required parameter rating must be specified.");
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                }

                public Rate set$Xgafv(String $Xgafv) {
                    return (Rate)super.set$Xgafv($Xgafv);
                }

                public Rate setAccessToken(String accessToken) {
                    return (Rate)super.setAccessToken(accessToken);
                }

                public Rate setAlt(String alt) {
                    return (Rate)super.setAlt(alt);
                }

                public Rate setCallback(String callback) {
                    return (Rate)super.setCallback(callback);
                }

                public Rate setFields(String fields) {
                    return (Rate)super.setFields(fields);
                }

                public Rate setKey(String key) {
                    return (Rate)super.setKey(key);
                }

                public Rate setOauthToken(String oauthToken) {
                    return (Rate)super.setOauthToken(oauthToken);
                }

                public Rate setPrettyPrint(Boolean prettyPrint) {
                    return (Rate)super.setPrettyPrint(prettyPrint);
                }

                public Rate setQuotaUser(String quotaUser) {
                    return (Rate)super.setQuotaUser(quotaUser);
                }

                public Rate setUploadType(String uploadType) {
                    return (Rate)super.setUploadType(uploadType);
                }

                public Rate setUploadProtocol(String uploadProtocol) {
                    return (Rate)super.setUploadProtocol(uploadProtocol);
                }

                public String getRating() {
                    return this.rating;
                }

                public Rate setRating(String rating) {
                    this.rating = rating;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public Rate setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public Rate setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Rate setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Rate set(String parameterName, Object value) {
                    return (Rate)super.set(parameterName, value);
                }
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
                private static final String REST_PATH = "books/v1/volumes/recommended";
                @Key
                private String locale;
                @Key
                private String maxAllowedMaturityRating;
                @Key
                private String source;

                protected List() {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getLocale() {
                    return this.locale;
                }

                public List setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public String getMaxAllowedMaturityRating() {
                    return this.maxAllowedMaturityRating;
                }

                public List setMaxAllowedMaturityRating(String maxAllowedMaturityRating) {
                    this.maxAllowedMaturityRating = maxAllowedMaturityRating;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Mybooks {
            public List list() throws IOException {
                List result = new List();
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
                private static final String REST_PATH = "books/v1/volumes/mybooks";
                @Key
                private java.util.List<String> acquireMethod;
                @Key
                private String country;
                @Key
                private String locale;
                @Key
                private Long maxResults;
                @Key
                private java.util.List<String> processingState;
                @Key
                private String source;
                @Key
                private Long startIndex;

                protected List() {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public java.util.List<String> getAcquireMethod() {
                    return this.acquireMethod;
                }

                public List setAcquireMethod(java.util.List<String> acquireMethod) {
                    this.acquireMethod = acquireMethod;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public List setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public List setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public java.util.List<String> getProcessingState() {
                    return this.processingState;
                }

                public List setProcessingState(java.util.List<String> processingState) {
                    this.processingState = processingState;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Associated {
            public List list(String volumeId) throws IOException {
                List result = new List(volumeId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
                private static final String REST_PATH = "books/v1/volumes/{volumeId}/associated";
                @Key
                private String volumeId;
                @Key
                private String association;
                @Key
                private String locale;
                @Key
                private String maxAllowedMaturityRating;
                @Key
                private String source;

                protected List(String volumeId) {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public List setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getAssociation() {
                    return this.association;
                }

                public List setAssociation(String association) {
                    this.association = association;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public List setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public String getMaxAllowedMaturityRating() {
                    return this.maxAllowedMaturityRating;
                }

                public List setMaxAllowedMaturityRating(String maxAllowedMaturityRating) {
                    this.maxAllowedMaturityRating = maxAllowedMaturityRating;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
            private static final String REST_PATH = "books/v1/volumes";
            @Key
            private String q;
            @Key
            private String download;
            @Key
            private String filter;
            @Key
            private String langRestrict;
            @Key
            private String libraryRestrict;
            @Key
            private String maxAllowedMaturityRating;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String partner;
            @Key
            private String printType;
            @Key
            private String projection;
            @Key
            private Boolean showPreorders;
            @Key
            private String source;
            @Key
            private Long startIndex;

            protected List(String q) {
                super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                this.q = (String)Preconditions.checkNotNull((Object)q, (Object)"Required parameter q must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public String getDownload() {
                return this.download;
            }

            public List setDownload(String download) {
                this.download = download;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getLangRestrict() {
                return this.langRestrict;
            }

            public List setLangRestrict(String langRestrict) {
                this.langRestrict = langRestrict;
                return this;
            }

            public String getLibraryRestrict() {
                return this.libraryRestrict;
            }

            public List setLibraryRestrict(String libraryRestrict) {
                this.libraryRestrict = libraryRestrict;
                return this;
            }

            public String getMaxAllowedMaturityRating() {
                return this.maxAllowedMaturityRating;
            }

            public List setMaxAllowedMaturityRating(String maxAllowedMaturityRating) {
                this.maxAllowedMaturityRating = maxAllowedMaturityRating;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPartner() {
                return this.partner;
            }

            public List setPartner(String partner) {
                this.partner = partner;
                return this;
            }

            public String getPrintType() {
                return this.printType;
            }

            public List setPrintType(String printType) {
                this.printType = printType;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public Boolean getShowPreorders() {
                return this.showPreorders;
            }

            public List setShowPreorders(Boolean showPreorders) {
                this.showPreorders = showPreorders;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String source) {
                this.source = source;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BooksRequest<Volume> {
            private static final String REST_PATH = "books/v1/volumes/{volumeId}";
            @Key
            private String volumeId;
            @Key
            private String country;
            @Key
            private Boolean includeNonComicsSeries;
            @Key
            private String partner;
            @Key
            private String projection;
            @Key
            private String source;
            @Key(value="user_library_consistent_read")
            private Boolean userLibraryConsistentRead;

            protected Get(String volumeId) {
                super(Books.this, "GET", REST_PATH, null, Volume.class);
                this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public Get setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Get setCountry(String country) {
                this.country = country;
                return this;
            }

            public Boolean getIncludeNonComicsSeries() {
                return this.includeNonComicsSeries;
            }

            public Get setIncludeNonComicsSeries(Boolean includeNonComicsSeries) {
                this.includeNonComicsSeries = includeNonComicsSeries;
                return this;
            }

            public String getPartner() {
                return this.partner;
            }

            public Get setPartner(String partner) {
                this.partner = partner;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }

            public Boolean getUserLibraryConsistentRead() {
                return this.userLibraryConsistentRead;
            }

            public Get setUserLibraryConsistentRead(Boolean userLibraryConsistentRead) {
                this.userLibraryConsistentRead = userLibraryConsistentRead;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Series {
        public Get get(List<String> seriesId) throws IOException {
            Get result = new Get(seriesId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Membership membership() {
            return new Membership();
        }

        public class Membership {
            public Get get(String seriesId) throws IOException {
                Get result = new Get(seriesId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends BooksRequest<Seriesmembership> {
                private static final String REST_PATH = "books/v1/series/membership/get";
                @Key(value="series_id")
                private String seriesId;
                @Key(value="page_size")
                private Long pageSize;
                @Key(value="page_token")
                private String pageToken;

                protected Get(String seriesId) {
                    super(Books.this, "GET", REST_PATH, null, Seriesmembership.class);
                    this.seriesId = (String)Preconditions.checkNotNull((Object)seriesId, (Object)"Required parameter seriesId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSeriesId() {
                    return this.seriesId;
                }

                public Get setSeriesId(String seriesId) {
                    this.seriesId = seriesId;
                    return this;
                }

                public Long getPageSize() {
                    return this.pageSize;
                }

                public Get setPageSize(Long pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public Get setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Get
        extends BooksRequest<com.google.api.services.books.v1.model.Series> {
            private static final String REST_PATH = "books/v1/series/get";
            @Key(value="series_id")
            private List<String> seriesId;

            protected Get(List<String> seriesId) {
                super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Series.class);
                this.seriesId = (List)Preconditions.checkNotNull(seriesId, (Object)"Required parameter seriesId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getSeriesId() {
                return this.seriesId;
            }

            public Get setSeriesId(List<String> seriesId) {
                this.seriesId = seriesId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Promooffer {
        public Accept accept() throws IOException {
            Accept result = new Accept();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Dismiss dismiss() throws IOException {
            Dismiss result = new Dismiss();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get() throws IOException {
            Get result = new Get();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends BooksRequest<Offers> {
            private static final String REST_PATH = "books/v1/promooffer/get";
            @Key
            private String androidId;
            @Key
            private String device;
            @Key
            private String manufacturer;
            @Key
            private String model;
            @Key
            private String product;
            @Key
            private String serial;

            protected Get() {
                super(Books.this, "GET", REST_PATH, null, Offers.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getAndroidId() {
                return this.androidId;
            }

            public Get setAndroidId(String androidId) {
                this.androidId = androidId;
                return this;
            }

            public String getDevice() {
                return this.device;
            }

            public Get setDevice(String device) {
                this.device = device;
                return this;
            }

            public String getManufacturer() {
                return this.manufacturer;
            }

            public Get setManufacturer(String manufacturer) {
                this.manufacturer = manufacturer;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public Get setModel(String model) {
                this.model = model;
                return this;
            }

            public String getProduct() {
                return this.product;
            }

            public Get setProduct(String product) {
                this.product = product;
                return this;
            }

            public String getSerial() {
                return this.serial;
            }

            public Get setSerial(String serial) {
                this.serial = serial;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Dismiss
        extends BooksRequest<Empty> {
            private static final String REST_PATH = "books/v1/promooffer/dismiss";
            @Key
            private String androidId;
            @Key
            private String device;
            @Key
            private String manufacturer;
            @Key
            private String model;
            @Key
            private String offerId;
            @Key
            private String product;
            @Key
            private String serial;

            protected Dismiss() {
                super(Books.this, "POST", REST_PATH, null, Empty.class);
            }

            public Dismiss set$Xgafv(String $Xgafv) {
                return (Dismiss)super.set$Xgafv($Xgafv);
            }

            public Dismiss setAccessToken(String accessToken) {
                return (Dismiss)super.setAccessToken(accessToken);
            }

            public Dismiss setAlt(String alt) {
                return (Dismiss)super.setAlt(alt);
            }

            public Dismiss setCallback(String callback) {
                return (Dismiss)super.setCallback(callback);
            }

            public Dismiss setFields(String fields) {
                return (Dismiss)super.setFields(fields);
            }

            public Dismiss setKey(String key) {
                return (Dismiss)super.setKey(key);
            }

            public Dismiss setOauthToken(String oauthToken) {
                return (Dismiss)super.setOauthToken(oauthToken);
            }

            public Dismiss setPrettyPrint(Boolean prettyPrint) {
                return (Dismiss)super.setPrettyPrint(prettyPrint);
            }

            public Dismiss setQuotaUser(String quotaUser) {
                return (Dismiss)super.setQuotaUser(quotaUser);
            }

            public Dismiss setUploadType(String uploadType) {
                return (Dismiss)super.setUploadType(uploadType);
            }

            public Dismiss setUploadProtocol(String uploadProtocol) {
                return (Dismiss)super.setUploadProtocol(uploadProtocol);
            }

            public String getAndroidId() {
                return this.androidId;
            }

            public Dismiss setAndroidId(String androidId) {
                this.androidId = androidId;
                return this;
            }

            public String getDevice() {
                return this.device;
            }

            public Dismiss setDevice(String device) {
                this.device = device;
                return this;
            }

            public String getManufacturer() {
                return this.manufacturer;
            }

            public Dismiss setManufacturer(String manufacturer) {
                this.manufacturer = manufacturer;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public Dismiss setModel(String model) {
                this.model = model;
                return this;
            }

            public String getOfferId() {
                return this.offerId;
            }

            public Dismiss setOfferId(String offerId) {
                this.offerId = offerId;
                return this;
            }

            public String getProduct() {
                return this.product;
            }

            public Dismiss setProduct(String product) {
                this.product = product;
                return this;
            }

            public String getSerial() {
                return this.serial;
            }

            public Dismiss setSerial(String serial) {
                this.serial = serial;
                return this;
            }

            @Override
            public Dismiss set(String parameterName, Object value) {
                return (Dismiss)super.set(parameterName, value);
            }
        }

        public class Accept
        extends BooksRequest<Empty> {
            private static final String REST_PATH = "books/v1/promooffer/accept";
            @Key
            private String androidId;
            @Key
            private String device;
            @Key
            private String manufacturer;
            @Key
            private String model;
            @Key
            private String offerId;
            @Key
            private String product;
            @Key
            private String serial;
            @Key
            private String volumeId;

            protected Accept() {
                super(Books.this, "POST", REST_PATH, null, Empty.class);
            }

            public Accept set$Xgafv(String $Xgafv) {
                return (Accept)super.set$Xgafv($Xgafv);
            }

            public Accept setAccessToken(String accessToken) {
                return (Accept)super.setAccessToken(accessToken);
            }

            public Accept setAlt(String alt) {
                return (Accept)super.setAlt(alt);
            }

            public Accept setCallback(String callback) {
                return (Accept)super.setCallback(callback);
            }

            public Accept setFields(String fields) {
                return (Accept)super.setFields(fields);
            }

            public Accept setKey(String key) {
                return (Accept)super.setKey(key);
            }

            public Accept setOauthToken(String oauthToken) {
                return (Accept)super.setOauthToken(oauthToken);
            }

            public Accept setPrettyPrint(Boolean prettyPrint) {
                return (Accept)super.setPrettyPrint(prettyPrint);
            }

            public Accept setQuotaUser(String quotaUser) {
                return (Accept)super.setQuotaUser(quotaUser);
            }

            public Accept setUploadType(String uploadType) {
                return (Accept)super.setUploadType(uploadType);
            }

            public Accept setUploadProtocol(String uploadProtocol) {
                return (Accept)super.setUploadProtocol(uploadProtocol);
            }

            public String getAndroidId() {
                return this.androidId;
            }

            public Accept setAndroidId(String androidId) {
                this.androidId = androidId;
                return this;
            }

            public String getDevice() {
                return this.device;
            }

            public Accept setDevice(String device) {
                this.device = device;
                return this;
            }

            public String getManufacturer() {
                return this.manufacturer;
            }

            public Accept setManufacturer(String manufacturer) {
                this.manufacturer = manufacturer;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public Accept setModel(String model) {
                this.model = model;
                return this;
            }

            public String getOfferId() {
                return this.offerId;
            }

            public Accept setOfferId(String offerId) {
                this.offerId = offerId;
                return this;
            }

            public String getProduct() {
                return this.product;
            }

            public Accept setProduct(String product) {
                this.product = product;
                return this;
            }

            public String getSerial() {
                return this.serial;
            }

            public Accept setSerial(String serial) {
                this.serial = serial;
                return this;
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public Accept setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            @Override
            public Accept set(String parameterName, Object value) {
                return (Accept)super.set(parameterName, value);
            }
        }
    }

    public class Personalizedstream {
        public Get get() throws IOException {
            Get result = new Get();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends BooksRequest<Discoveryclusters> {
            private static final String REST_PATH = "books/v1/personalizedstream/get";
            @Key
            private String locale;
            @Key
            private String maxAllowedMaturityRating;
            @Key
            private String source;

            protected Get() {
                super(Books.this, "GET", REST_PATH, null, Discoveryclusters.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getLocale() {
                return this.locale;
            }

            public Get setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public String getMaxAllowedMaturityRating() {
                return this.maxAllowedMaturityRating;
            }

            public Get setMaxAllowedMaturityRating(String maxAllowedMaturityRating) {
                this.maxAllowedMaturityRating = maxAllowedMaturityRating;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Onboarding {
        public ListCategories listCategories() throws IOException {
            ListCategories result = new ListCategories();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListCategoryVolumes listCategoryVolumes() throws IOException {
            ListCategoryVolumes result = new ListCategoryVolumes();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ListCategoryVolumes
        extends BooksRequest<Volume2> {
            private static final String REST_PATH = "books/v1/onboarding/listCategoryVolumes";
            @Key
            private List<String> categoryId;
            @Key
            private String locale;
            @Key
            private String maxAllowedMaturityRating;
            @Key
            private Long pageSize;
            @Key
            private String pageToken;

            protected ListCategoryVolumes() {
                super(Books.this, "GET", REST_PATH, null, Volume2.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListCategoryVolumes set$Xgafv(String $Xgafv) {
                return (ListCategoryVolumes)super.set$Xgafv($Xgafv);
            }

            public ListCategoryVolumes setAccessToken(String accessToken) {
                return (ListCategoryVolumes)super.setAccessToken(accessToken);
            }

            public ListCategoryVolumes setAlt(String alt) {
                return (ListCategoryVolumes)super.setAlt(alt);
            }

            public ListCategoryVolumes setCallback(String callback) {
                return (ListCategoryVolumes)super.setCallback(callback);
            }

            public ListCategoryVolumes setFields(String fields) {
                return (ListCategoryVolumes)super.setFields(fields);
            }

            public ListCategoryVolumes setKey(String key) {
                return (ListCategoryVolumes)super.setKey(key);
            }

            public ListCategoryVolumes setOauthToken(String oauthToken) {
                return (ListCategoryVolumes)super.setOauthToken(oauthToken);
            }

            public ListCategoryVolumes setPrettyPrint(Boolean prettyPrint) {
                return (ListCategoryVolumes)super.setPrettyPrint(prettyPrint);
            }

            public ListCategoryVolumes setQuotaUser(String quotaUser) {
                return (ListCategoryVolumes)super.setQuotaUser(quotaUser);
            }

            public ListCategoryVolumes setUploadType(String uploadType) {
                return (ListCategoryVolumes)super.setUploadType(uploadType);
            }

            public ListCategoryVolumes setUploadProtocol(String uploadProtocol) {
                return (ListCategoryVolumes)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getCategoryId() {
                return this.categoryId;
            }

            public ListCategoryVolumes setCategoryId(List<String> categoryId) {
                this.categoryId = categoryId;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public ListCategoryVolumes setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public String getMaxAllowedMaturityRating() {
                return this.maxAllowedMaturityRating;
            }

            public ListCategoryVolumes setMaxAllowedMaturityRating(String maxAllowedMaturityRating) {
                this.maxAllowedMaturityRating = maxAllowedMaturityRating;
                return this;
            }

            public Long getPageSize() {
                return this.pageSize;
            }

            public ListCategoryVolumes setPageSize(Long pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListCategoryVolumes setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListCategoryVolumes set(String parameterName, Object value) {
                return (ListCategoryVolumes)super.set(parameterName, value);
            }
        }

        public class ListCategories
        extends BooksRequest<Category> {
            private static final String REST_PATH = "books/v1/onboarding/listCategories";
            @Key
            private String locale;

            protected ListCategories() {
                super(Books.this, "GET", REST_PATH, null, Category.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListCategories set$Xgafv(String $Xgafv) {
                return (ListCategories)super.set$Xgafv($Xgafv);
            }

            public ListCategories setAccessToken(String accessToken) {
                return (ListCategories)super.setAccessToken(accessToken);
            }

            public ListCategories setAlt(String alt) {
                return (ListCategories)super.setAlt(alt);
            }

            public ListCategories setCallback(String callback) {
                return (ListCategories)super.setCallback(callback);
            }

            public ListCategories setFields(String fields) {
                return (ListCategories)super.setFields(fields);
            }

            public ListCategories setKey(String key) {
                return (ListCategories)super.setKey(key);
            }

            public ListCategories setOauthToken(String oauthToken) {
                return (ListCategories)super.setOauthToken(oauthToken);
            }

            public ListCategories setPrettyPrint(Boolean prettyPrint) {
                return (ListCategories)super.setPrettyPrint(prettyPrint);
            }

            public ListCategories setQuotaUser(String quotaUser) {
                return (ListCategories)super.setQuotaUser(quotaUser);
            }

            public ListCategories setUploadType(String uploadType) {
                return (ListCategories)super.setUploadType(uploadType);
            }

            public ListCategories setUploadProtocol(String uploadProtocol) {
                return (ListCategories)super.setUploadProtocol(uploadProtocol);
            }

            public String getLocale() {
                return this.locale;
            }

            public ListCategories setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            @Override
            public ListCategories set(String parameterName, Object value) {
                return (ListCategories)super.set(parameterName, value);
            }
        }
    }

    public class Notification {
        public Get get(String notificationId) throws IOException {
            Get result = new Get(notificationId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends BooksRequest<com.google.api.services.books.v1.model.Notification> {
            private static final String REST_PATH = "books/v1/notification/get";
            @Key(value="notification_id")
            private String notificationId;
            @Key
            private String locale;
            @Key
            private String source;

            protected Get(String notificationId) {
                super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Notification.class);
                this.notificationId = (String)Preconditions.checkNotNull((Object)notificationId, (Object)"Required parameter notificationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getNotificationId() {
                return this.notificationId;
            }

            public Get setNotificationId(String notificationId) {
                this.notificationId = notificationId;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public Get setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Mylibrary {
        public Annotations annotations() {
            return new Annotations();
        }

        public Bookshelves bookshelves() {
            return new Bookshelves();
        }

        public Readingpositions readingpositions() {
            return new Readingpositions();
        }

        public class Readingpositions {
            public Get get(String volumeId) throws IOException {
                Get result = new Get(volumeId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetPosition setPosition(String volumeId, String position, String timestamp) throws IOException {
                SetPosition result = new SetPosition(volumeId, position, timestamp);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class SetPosition
            extends BooksRequest<Empty> {
                private static final String REST_PATH = "books/v1/mylibrary/readingpositions/{volumeId}/setPosition";
                @Key
                private String volumeId;
                @Key
                private String position;
                @Key
                private String timestamp;
                @Key
                private String action;
                @Key
                private String contentVersion;
                @Key
                private String deviceCookie;
                @Key
                private String source;

                protected SetPosition(String volumeId, String position, String timestamp) {
                    super(Books.this, "POST", REST_PATH, null, Empty.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                    this.position = (String)Preconditions.checkNotNull((Object)position, (Object)"Required parameter position must be specified.");
                    this.timestamp = (String)Preconditions.checkNotNull((Object)timestamp, (Object)"Required parameter timestamp must be specified.");
                }

                public SetPosition set$Xgafv(String $Xgafv) {
                    return (SetPosition)super.set$Xgafv($Xgafv);
                }

                public SetPosition setAccessToken(String accessToken) {
                    return (SetPosition)super.setAccessToken(accessToken);
                }

                public SetPosition setAlt(String alt) {
                    return (SetPosition)super.setAlt(alt);
                }

                public SetPosition setCallback(String callback) {
                    return (SetPosition)super.setCallback(callback);
                }

                public SetPosition setFields(String fields) {
                    return (SetPosition)super.setFields(fields);
                }

                public SetPosition setKey(String key) {
                    return (SetPosition)super.setKey(key);
                }

                public SetPosition setOauthToken(String oauthToken) {
                    return (SetPosition)super.setOauthToken(oauthToken);
                }

                public SetPosition setPrettyPrint(Boolean prettyPrint) {
                    return (SetPosition)super.setPrettyPrint(prettyPrint);
                }

                public SetPosition setQuotaUser(String quotaUser) {
                    return (SetPosition)super.setQuotaUser(quotaUser);
                }

                public SetPosition setUploadType(String uploadType) {
                    return (SetPosition)super.setUploadType(uploadType);
                }

                public SetPosition setUploadProtocol(String uploadProtocol) {
                    return (SetPosition)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public SetPosition setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getPosition() {
                    return this.position;
                }

                public SetPosition setPosition(String position) {
                    this.position = position;
                    return this;
                }

                public String getTimestamp() {
                    return this.timestamp;
                }

                public SetPosition setTimestamp(String timestamp) {
                    this.timestamp = timestamp;
                    return this;
                }

                public String getAction() {
                    return this.action;
                }

                public SetPosition setAction(String action) {
                    this.action = action;
                    return this;
                }

                public String getContentVersion() {
                    return this.contentVersion;
                }

                public SetPosition setContentVersion(String contentVersion) {
                    this.contentVersion = contentVersion;
                    return this;
                }

                public String getDeviceCookie() {
                    return this.deviceCookie;
                }

                public SetPosition setDeviceCookie(String deviceCookie) {
                    this.deviceCookie = deviceCookie;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public SetPosition setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public SetPosition set(String parameterName, Object value) {
                    return (SetPosition)super.set(parameterName, value);
                }
            }

            public class Get
            extends BooksRequest<ReadingPosition> {
                private static final String REST_PATH = "books/v1/mylibrary/readingpositions/{volumeId}";
                @Key
                private String volumeId;
                @Key
                private String contentVersion;
                @Key
                private String source;

                protected Get(String volumeId) {
                    super(Books.this, "GET", REST_PATH, null, ReadingPosition.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public Get setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getContentVersion() {
                    return this.contentVersion;
                }

                public Get setContentVersion(String contentVersion) {
                    this.contentVersion = contentVersion;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Get setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Bookshelves {
            public AddVolume addVolume(String shelf, String volumeId) throws IOException {
                AddVolume result = new AddVolume(shelf, volumeId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ClearVolumes clearVolumes(String shelf) throws IOException {
                ClearVolumes result = new ClearVolumes(shelf);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String shelf) throws IOException {
                Get result = new Get(shelf);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list() throws IOException {
                List result = new List();
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public MoveVolume moveVolume(String shelf, String volumeId, Integer volumePosition) throws IOException {
                MoveVolume result = new MoveVolume(shelf, volumeId, volumePosition);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public RemoveVolume removeVolume(String shelf, String volumeId) throws IOException {
                RemoveVolume result = new RemoveVolume(shelf, volumeId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Volumes volumes() {
                return new Volumes();
            }

            public class Volumes {
                public List list(String shelf) throws IOException {
                    List result = new List(shelf);
                    Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
                    private static final String REST_PATH = "books/v1/mylibrary/bookshelves/{shelf}/volumes";
                    @Key
                    private String shelf;
                    @Key
                    private String country;
                    @Key
                    private Long maxResults;
                    @Key
                    private String projection;
                    @Key
                    private String q;
                    @Key
                    private Boolean showPreorders;
                    @Key
                    private String source;
                    @Key
                    private Long startIndex;

                    protected List(String shelf) {
                        super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                        this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getShelf() {
                        return this.shelf;
                    }

                    public List setShelf(String shelf) {
                        this.shelf = shelf;
                        return this;
                    }

                    public String getCountry() {
                        return this.country;
                    }

                    public List setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Long getMaxResults() {
                        return this.maxResults;
                    }

                    public List setMaxResults(Long maxResults) {
                        this.maxResults = maxResults;
                        return this;
                    }

                    public String getProjection() {
                        return this.projection;
                    }

                    public List setProjection(String projection) {
                        this.projection = projection;
                        return this;
                    }

                    public String getQ() {
                        return this.q;
                    }

                    public List setQ(String q) {
                        this.q = q;
                        return this;
                    }

                    public Boolean getShowPreorders() {
                        return this.showPreorders;
                    }

                    public List setShowPreorders(Boolean showPreorders) {
                        this.showPreorders = showPreorders;
                        return this;
                    }

                    public String getSource() {
                        return this.source;
                    }

                    public List setSource(String source) {
                        this.source = source;
                        return this;
                    }

                    public Long getStartIndex() {
                        return this.startIndex;
                    }

                    public List setStartIndex(Long startIndex) {
                        this.startIndex = startIndex;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class RemoveVolume
            extends BooksRequest<Empty> {
                private static final String REST_PATH = "books/v1/mylibrary/bookshelves/{shelf}/removeVolume";
                @Key
                private String shelf;
                @Key
                private String volumeId;
                @Key
                private String reason;
                @Key
                private String source;

                protected RemoveVolume(String shelf, String volumeId) {
                    super(Books.this, "POST", REST_PATH, null, Empty.class);
                    this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                }

                public RemoveVolume set$Xgafv(String $Xgafv) {
                    return (RemoveVolume)super.set$Xgafv($Xgafv);
                }

                public RemoveVolume setAccessToken(String accessToken) {
                    return (RemoveVolume)super.setAccessToken(accessToken);
                }

                public RemoveVolume setAlt(String alt) {
                    return (RemoveVolume)super.setAlt(alt);
                }

                public RemoveVolume setCallback(String callback) {
                    return (RemoveVolume)super.setCallback(callback);
                }

                public RemoveVolume setFields(String fields) {
                    return (RemoveVolume)super.setFields(fields);
                }

                public RemoveVolume setKey(String key) {
                    return (RemoveVolume)super.setKey(key);
                }

                public RemoveVolume setOauthToken(String oauthToken) {
                    return (RemoveVolume)super.setOauthToken(oauthToken);
                }

                public RemoveVolume setPrettyPrint(Boolean prettyPrint) {
                    return (RemoveVolume)super.setPrettyPrint(prettyPrint);
                }

                public RemoveVolume setQuotaUser(String quotaUser) {
                    return (RemoveVolume)super.setQuotaUser(quotaUser);
                }

                public RemoveVolume setUploadType(String uploadType) {
                    return (RemoveVolume)super.setUploadType(uploadType);
                }

                public RemoveVolume setUploadProtocol(String uploadProtocol) {
                    return (RemoveVolume)super.setUploadProtocol(uploadProtocol);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public RemoveVolume setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public RemoveVolume setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getReason() {
                    return this.reason;
                }

                public RemoveVolume setReason(String reason) {
                    this.reason = reason;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public RemoveVolume setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public RemoveVolume set(String parameterName, Object value) {
                    return (RemoveVolume)super.set(parameterName, value);
                }
            }

            public class MoveVolume
            extends BooksRequest<Empty> {
                private static final String REST_PATH = "books/v1/mylibrary/bookshelves/{shelf}/moveVolume";
                @Key
                private String shelf;
                @Key
                private String volumeId;
                @Key
                private Integer volumePosition;
                @Key
                private String source;

                protected MoveVolume(String shelf, String volumeId, Integer volumePosition) {
                    super(Books.this, "POST", REST_PATH, null, Empty.class);
                    this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                    this.volumePosition = (Integer)Preconditions.checkNotNull((Object)volumePosition, (Object)"Required parameter volumePosition must be specified.");
                }

                public MoveVolume set$Xgafv(String $Xgafv) {
                    return (MoveVolume)super.set$Xgafv($Xgafv);
                }

                public MoveVolume setAccessToken(String accessToken) {
                    return (MoveVolume)super.setAccessToken(accessToken);
                }

                public MoveVolume setAlt(String alt) {
                    return (MoveVolume)super.setAlt(alt);
                }

                public MoveVolume setCallback(String callback) {
                    return (MoveVolume)super.setCallback(callback);
                }

                public MoveVolume setFields(String fields) {
                    return (MoveVolume)super.setFields(fields);
                }

                public MoveVolume setKey(String key) {
                    return (MoveVolume)super.setKey(key);
                }

                public MoveVolume setOauthToken(String oauthToken) {
                    return (MoveVolume)super.setOauthToken(oauthToken);
                }

                public MoveVolume setPrettyPrint(Boolean prettyPrint) {
                    return (MoveVolume)super.setPrettyPrint(prettyPrint);
                }

                public MoveVolume setQuotaUser(String quotaUser) {
                    return (MoveVolume)super.setQuotaUser(quotaUser);
                }

                public MoveVolume setUploadType(String uploadType) {
                    return (MoveVolume)super.setUploadType(uploadType);
                }

                public MoveVolume setUploadProtocol(String uploadProtocol) {
                    return (MoveVolume)super.setUploadProtocol(uploadProtocol);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public MoveVolume setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public MoveVolume setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public Integer getVolumePosition() {
                    return this.volumePosition;
                }

                public MoveVolume setVolumePosition(Integer volumePosition) {
                    this.volumePosition = volumePosition;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public MoveVolume setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public MoveVolume set(String parameterName, Object value) {
                    return (MoveVolume)super.set(parameterName, value);
                }
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Bookshelves> {
                private static final String REST_PATH = "books/v1/mylibrary/bookshelves";
                @Key
                private String source;

                protected List() {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Bookshelves.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends BooksRequest<Bookshelf> {
                private static final String REST_PATH = "books/v1/mylibrary/bookshelves/{shelf}";
                @Key
                private String shelf;
                @Key
                private String source;

                protected Get(String shelf) {
                    super(Books.this, "GET", REST_PATH, null, Bookshelf.class);
                    this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public Get setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Get setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class ClearVolumes
            extends BooksRequest<Empty> {
                private static final String REST_PATH = "books/v1/mylibrary/bookshelves/{shelf}/clearVolumes";
                @Key
                private String shelf;
                @Key
                private String source;

                protected ClearVolumes(String shelf) {
                    super(Books.this, "POST", REST_PATH, null, Empty.class);
                    this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                }

                public ClearVolumes set$Xgafv(String $Xgafv) {
                    return (ClearVolumes)super.set$Xgafv($Xgafv);
                }

                public ClearVolumes setAccessToken(String accessToken) {
                    return (ClearVolumes)super.setAccessToken(accessToken);
                }

                public ClearVolumes setAlt(String alt) {
                    return (ClearVolumes)super.setAlt(alt);
                }

                public ClearVolumes setCallback(String callback) {
                    return (ClearVolumes)super.setCallback(callback);
                }

                public ClearVolumes setFields(String fields) {
                    return (ClearVolumes)super.setFields(fields);
                }

                public ClearVolumes setKey(String key) {
                    return (ClearVolumes)super.setKey(key);
                }

                public ClearVolumes setOauthToken(String oauthToken) {
                    return (ClearVolumes)super.setOauthToken(oauthToken);
                }

                public ClearVolumes setPrettyPrint(Boolean prettyPrint) {
                    return (ClearVolumes)super.setPrettyPrint(prettyPrint);
                }

                public ClearVolumes setQuotaUser(String quotaUser) {
                    return (ClearVolumes)super.setQuotaUser(quotaUser);
                }

                public ClearVolumes setUploadType(String uploadType) {
                    return (ClearVolumes)super.setUploadType(uploadType);
                }

                public ClearVolumes setUploadProtocol(String uploadProtocol) {
                    return (ClearVolumes)super.setUploadProtocol(uploadProtocol);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public ClearVolumes setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public ClearVolumes setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public ClearVolumes set(String parameterName, Object value) {
                    return (ClearVolumes)super.set(parameterName, value);
                }
            }

            public class AddVolume
            extends BooksRequest<Empty> {
                private static final String REST_PATH = "books/v1/mylibrary/bookshelves/{shelf}/addVolume";
                @Key
                private String shelf;
                @Key
                private String volumeId;
                @Key
                private String reason;
                @Key
                private String source;

                protected AddVolume(String shelf, String volumeId) {
                    super(Books.this, "POST", REST_PATH, null, Empty.class);
                    this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                }

                public AddVolume set$Xgafv(String $Xgafv) {
                    return (AddVolume)super.set$Xgafv($Xgafv);
                }

                public AddVolume setAccessToken(String accessToken) {
                    return (AddVolume)super.setAccessToken(accessToken);
                }

                public AddVolume setAlt(String alt) {
                    return (AddVolume)super.setAlt(alt);
                }

                public AddVolume setCallback(String callback) {
                    return (AddVolume)super.setCallback(callback);
                }

                public AddVolume setFields(String fields) {
                    return (AddVolume)super.setFields(fields);
                }

                public AddVolume setKey(String key) {
                    return (AddVolume)super.setKey(key);
                }

                public AddVolume setOauthToken(String oauthToken) {
                    return (AddVolume)super.setOauthToken(oauthToken);
                }

                public AddVolume setPrettyPrint(Boolean prettyPrint) {
                    return (AddVolume)super.setPrettyPrint(prettyPrint);
                }

                public AddVolume setQuotaUser(String quotaUser) {
                    return (AddVolume)super.setQuotaUser(quotaUser);
                }

                public AddVolume setUploadType(String uploadType) {
                    return (AddVolume)super.setUploadType(uploadType);
                }

                public AddVolume setUploadProtocol(String uploadProtocol) {
                    return (AddVolume)super.setUploadProtocol(uploadProtocol);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public AddVolume setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public AddVolume setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getReason() {
                    return this.reason;
                }

                public AddVolume setReason(String reason) {
                    this.reason = reason;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public AddVolume setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public AddVolume set(String parameterName, Object value) {
                    return (AddVolume)super.set(parameterName, value);
                }
            }
        }

        public class Annotations {
            public Delete delete(String annotationId) throws IOException {
                Delete result = new Delete(annotationId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(Annotation content) throws IOException {
                Insert result = new Insert(content);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list() throws IOException {
                List result = new List();
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Summary summary(java.util.List<String> layerIds, String volumeId) throws IOException {
                Summary result = new Summary(layerIds, volumeId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String annotationId, Annotation content) throws IOException {
                Update result = new Update(annotationId, content);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends BooksRequest<Annotation> {
                private static final String REST_PATH = "books/v1/mylibrary/annotations/{annotationId}";
                @Key
                private String annotationId;
                @Key
                private String source;

                protected Update(String annotationId, Annotation content) {
                    super(Books.this, "PUT", REST_PATH, (Object)content, Annotation.class);
                    this.annotationId = (String)Preconditions.checkNotNull((Object)annotationId, (Object)"Required parameter annotationId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getAnnotationId() {
                    return this.annotationId;
                }

                public Update setAnnotationId(String annotationId) {
                    this.annotationId = annotationId;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Update setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Summary
            extends BooksRequest<AnnotationsSummary> {
                private static final String REST_PATH = "books/v1/mylibrary/annotations/summary";
                @Key
                private java.util.List<String> layerIds;
                @Key
                private String volumeId;

                protected Summary(java.util.List<String> layerIds, String volumeId) {
                    super(Books.this, "POST", REST_PATH, null, AnnotationsSummary.class);
                    this.layerIds = (java.util.List)Preconditions.checkNotNull(layerIds, (Object)"Required parameter layerIds must be specified.");
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                }

                public Summary set$Xgafv(String $Xgafv) {
                    return (Summary)super.set$Xgafv($Xgafv);
                }

                public Summary setAccessToken(String accessToken) {
                    return (Summary)super.setAccessToken(accessToken);
                }

                public Summary setAlt(String alt) {
                    return (Summary)super.setAlt(alt);
                }

                public Summary setCallback(String callback) {
                    return (Summary)super.setCallback(callback);
                }

                public Summary setFields(String fields) {
                    return (Summary)super.setFields(fields);
                }

                public Summary setKey(String key) {
                    return (Summary)super.setKey(key);
                }

                public Summary setOauthToken(String oauthToken) {
                    return (Summary)super.setOauthToken(oauthToken);
                }

                public Summary setPrettyPrint(Boolean prettyPrint) {
                    return (Summary)super.setPrettyPrint(prettyPrint);
                }

                public Summary setQuotaUser(String quotaUser) {
                    return (Summary)super.setQuotaUser(quotaUser);
                }

                public Summary setUploadType(String uploadType) {
                    return (Summary)super.setUploadType(uploadType);
                }

                public Summary setUploadProtocol(String uploadProtocol) {
                    return (Summary)super.setUploadProtocol(uploadProtocol);
                }

                public java.util.List<String> getLayerIds() {
                    return this.layerIds;
                }

                public Summary setLayerIds(java.util.List<String> layerIds) {
                    this.layerIds = layerIds;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public Summary setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                @Override
                public Summary set(String parameterName, Object value) {
                    return (Summary)super.set(parameterName, value);
                }
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Annotations> {
                private static final String REST_PATH = "books/v1/mylibrary/annotations";
                @Key
                private String contentVersion;
                @Key
                private String layerId;
                @Key
                private java.util.List<String> layerIds;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private Boolean showDeleted;
                @Key
                private String source;
                @Key
                private String updatedMax;
                @Key
                private String updatedMin;
                @Key
                private String volumeId;

                protected List() {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Annotations.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getContentVersion() {
                    return this.contentVersion;
                }

                public List setContentVersion(String contentVersion) {
                    this.contentVersion = contentVersion;
                    return this;
                }

                public String getLayerId() {
                    return this.layerId;
                }

                public List setLayerId(String layerId) {
                    this.layerId = layerId;
                    return this;
                }

                public java.util.List<String> getLayerIds() {
                    return this.layerIds;
                }

                public List setLayerIds(java.util.List<String> layerIds) {
                    this.layerIds = layerIds;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean showDeleted) {
                    this.showDeleted = showDeleted;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public String getUpdatedMax() {
                    return this.updatedMax;
                }

                public List setUpdatedMax(String updatedMax) {
                    this.updatedMax = updatedMax;
                    return this;
                }

                public String getUpdatedMin() {
                    return this.updatedMin;
                }

                public List setUpdatedMin(String updatedMin) {
                    this.updatedMin = updatedMin;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public List setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends BooksRequest<Annotation> {
                private static final String REST_PATH = "books/v1/mylibrary/annotations";
                @Key
                private String annotationId;
                @Key
                private String country;
                @Key
                private Boolean showOnlySummaryInResponse;
                @Key
                private String source;

                protected Insert(Annotation content) {
                    super(Books.this, "POST", REST_PATH, (Object)content, Annotation.class);
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public String getAnnotationId() {
                    return this.annotationId;
                }

                public Insert setAnnotationId(String annotationId) {
                    this.annotationId = annotationId;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public Insert setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Boolean getShowOnlySummaryInResponse() {
                    return this.showOnlySummaryInResponse;
                }

                public Insert setShowOnlySummaryInResponse(Boolean showOnlySummaryInResponse) {
                    this.showOnlySummaryInResponse = showOnlySummaryInResponse;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Insert setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Delete
            extends BooksRequest<Empty> {
                private static final String REST_PATH = "books/v1/mylibrary/annotations/{annotationId}";
                @Key
                private String annotationId;
                @Key
                private String source;

                protected Delete(String annotationId) {
                    super(Books.this, "DELETE", REST_PATH, null, Empty.class);
                    this.annotationId = (String)Preconditions.checkNotNull((Object)annotationId, (Object)"Required parameter annotationId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getAnnotationId() {
                    return this.annotationId;
                }

                public Delete setAnnotationId(String annotationId) {
                    this.annotationId = annotationId;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Delete setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }
    }

    public class Myconfig {
        public GetUserSettings getUserSettings() throws IOException {
            GetUserSettings result = new GetUserSettings();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ReleaseDownloadAccess releaseDownloadAccess(String cpksver, List<String> volumeIds) throws IOException {
            ReleaseDownloadAccess result = new ReleaseDownloadAccess(cpksver, volumeIds);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RequestAccess requestAccess(String cpksver, String nonce, String source, String volumeId) throws IOException {
            RequestAccess result = new RequestAccess(cpksver, nonce, source, volumeId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SyncVolumeLicenses syncVolumeLicenses(String cpksver, String nonce, String source) throws IOException {
            SyncVolumeLicenses result = new SyncVolumeLicenses(cpksver, nonce, source);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateUserSettings updateUserSettings(Usersettings content) throws IOException {
            UpdateUserSettings result = new UpdateUserSettings(content);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateUserSettings
        extends BooksRequest<Usersettings> {
            private static final String REST_PATH = "books/v1/myconfig/updateUserSettings";

            protected UpdateUserSettings(Usersettings content) {
                super(Books.this, "POST", REST_PATH, (Object)content, Usersettings.class);
            }

            public UpdateUserSettings set$Xgafv(String $Xgafv) {
                return (UpdateUserSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateUserSettings setAccessToken(String accessToken) {
                return (UpdateUserSettings)super.setAccessToken(accessToken);
            }

            public UpdateUserSettings setAlt(String alt) {
                return (UpdateUserSettings)super.setAlt(alt);
            }

            public UpdateUserSettings setCallback(String callback) {
                return (UpdateUserSettings)super.setCallback(callback);
            }

            public UpdateUserSettings setFields(String fields) {
                return (UpdateUserSettings)super.setFields(fields);
            }

            public UpdateUserSettings setKey(String key) {
                return (UpdateUserSettings)super.setKey(key);
            }

            public UpdateUserSettings setOauthToken(String oauthToken) {
                return (UpdateUserSettings)super.setOauthToken(oauthToken);
            }

            public UpdateUserSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateUserSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateUserSettings setQuotaUser(String quotaUser) {
                return (UpdateUserSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateUserSettings setUploadType(String uploadType) {
                return (UpdateUserSettings)super.setUploadType(uploadType);
            }

            public UpdateUserSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateUserSettings)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public UpdateUserSettings set(String parameterName, Object value) {
                return (UpdateUserSettings)super.set(parameterName, value);
            }
        }

        public class SyncVolumeLicenses
        extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
            private static final String REST_PATH = "books/v1/myconfig/syncVolumeLicenses";
            @Key
            private String cpksver;
            @Key
            private String nonce;
            @Key
            private String source;
            @Key
            private List<String> features;
            @Key
            private Boolean includeNonComicsSeries;
            @Key
            private String locale;
            @Key
            private Boolean showPreorders;
            @Key
            private List<String> volumeIds;

            protected SyncVolumeLicenses(String cpksver, String nonce, String source) {
                super(Books.this, "POST", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                this.cpksver = (String)Preconditions.checkNotNull((Object)cpksver, (Object)"Required parameter cpksver must be specified.");
                this.nonce = (String)Preconditions.checkNotNull((Object)nonce, (Object)"Required parameter nonce must be specified.");
                this.source = (String)Preconditions.checkNotNull((Object)source, (Object)"Required parameter source must be specified.");
            }

            public SyncVolumeLicenses set$Xgafv(String $Xgafv) {
                return (SyncVolumeLicenses)super.set$Xgafv($Xgafv);
            }

            public SyncVolumeLicenses setAccessToken(String accessToken) {
                return (SyncVolumeLicenses)super.setAccessToken(accessToken);
            }

            public SyncVolumeLicenses setAlt(String alt) {
                return (SyncVolumeLicenses)super.setAlt(alt);
            }

            public SyncVolumeLicenses setCallback(String callback) {
                return (SyncVolumeLicenses)super.setCallback(callback);
            }

            public SyncVolumeLicenses setFields(String fields) {
                return (SyncVolumeLicenses)super.setFields(fields);
            }

            public SyncVolumeLicenses setKey(String key) {
                return (SyncVolumeLicenses)super.setKey(key);
            }

            public SyncVolumeLicenses setOauthToken(String oauthToken) {
                return (SyncVolumeLicenses)super.setOauthToken(oauthToken);
            }

            public SyncVolumeLicenses setPrettyPrint(Boolean prettyPrint) {
                return (SyncVolumeLicenses)super.setPrettyPrint(prettyPrint);
            }

            public SyncVolumeLicenses setQuotaUser(String quotaUser) {
                return (SyncVolumeLicenses)super.setQuotaUser(quotaUser);
            }

            public SyncVolumeLicenses setUploadType(String uploadType) {
                return (SyncVolumeLicenses)super.setUploadType(uploadType);
            }

            public SyncVolumeLicenses setUploadProtocol(String uploadProtocol) {
                return (SyncVolumeLicenses)super.setUploadProtocol(uploadProtocol);
            }

            public String getCpksver() {
                return this.cpksver;
            }

            public SyncVolumeLicenses setCpksver(String cpksver) {
                this.cpksver = cpksver;
                return this;
            }

            public String getNonce() {
                return this.nonce;
            }

            public SyncVolumeLicenses setNonce(String nonce) {
                this.nonce = nonce;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public SyncVolumeLicenses setSource(String source) {
                this.source = source;
                return this;
            }

            public List<String> getFeatures() {
                return this.features;
            }

            public SyncVolumeLicenses setFeatures(List<String> features) {
                this.features = features;
                return this;
            }

            public Boolean getIncludeNonComicsSeries() {
                return this.includeNonComicsSeries;
            }

            public SyncVolumeLicenses setIncludeNonComicsSeries(Boolean includeNonComicsSeries) {
                this.includeNonComicsSeries = includeNonComicsSeries;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public SyncVolumeLicenses setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public Boolean getShowPreorders() {
                return this.showPreorders;
            }

            public SyncVolumeLicenses setShowPreorders(Boolean showPreorders) {
                this.showPreorders = showPreorders;
                return this;
            }

            public List<String> getVolumeIds() {
                return this.volumeIds;
            }

            public SyncVolumeLicenses setVolumeIds(List<String> volumeIds) {
                this.volumeIds = volumeIds;
                return this;
            }

            @Override
            public SyncVolumeLicenses set(String parameterName, Object value) {
                return (SyncVolumeLicenses)super.set(parameterName, value);
            }
        }

        public class RequestAccess
        extends BooksRequest<RequestAccessData> {
            private static final String REST_PATH = "books/v1/myconfig/requestAccess";
            @Key
            private String cpksver;
            @Key
            private String nonce;
            @Key
            private String source;
            @Key
            private String volumeId;
            @Key
            private String licenseTypes;
            @Key
            private String locale;

            protected RequestAccess(String cpksver, String nonce, String source, String volumeId) {
                super(Books.this, "POST", REST_PATH, null, RequestAccessData.class);
                this.cpksver = (String)Preconditions.checkNotNull((Object)cpksver, (Object)"Required parameter cpksver must be specified.");
                this.nonce = (String)Preconditions.checkNotNull((Object)nonce, (Object)"Required parameter nonce must be specified.");
                this.source = (String)Preconditions.checkNotNull((Object)source, (Object)"Required parameter source must be specified.");
                this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
            }

            public RequestAccess set$Xgafv(String $Xgafv) {
                return (RequestAccess)super.set$Xgafv($Xgafv);
            }

            public RequestAccess setAccessToken(String accessToken) {
                return (RequestAccess)super.setAccessToken(accessToken);
            }

            public RequestAccess setAlt(String alt) {
                return (RequestAccess)super.setAlt(alt);
            }

            public RequestAccess setCallback(String callback) {
                return (RequestAccess)super.setCallback(callback);
            }

            public RequestAccess setFields(String fields) {
                return (RequestAccess)super.setFields(fields);
            }

            public RequestAccess setKey(String key) {
                return (RequestAccess)super.setKey(key);
            }

            public RequestAccess setOauthToken(String oauthToken) {
                return (RequestAccess)super.setOauthToken(oauthToken);
            }

            public RequestAccess setPrettyPrint(Boolean prettyPrint) {
                return (RequestAccess)super.setPrettyPrint(prettyPrint);
            }

            public RequestAccess setQuotaUser(String quotaUser) {
                return (RequestAccess)super.setQuotaUser(quotaUser);
            }

            public RequestAccess setUploadType(String uploadType) {
                return (RequestAccess)super.setUploadType(uploadType);
            }

            public RequestAccess setUploadProtocol(String uploadProtocol) {
                return (RequestAccess)super.setUploadProtocol(uploadProtocol);
            }

            public String getCpksver() {
                return this.cpksver;
            }

            public RequestAccess setCpksver(String cpksver) {
                this.cpksver = cpksver;
                return this;
            }

            public String getNonce() {
                return this.nonce;
            }

            public RequestAccess setNonce(String nonce) {
                this.nonce = nonce;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public RequestAccess setSource(String source) {
                this.source = source;
                return this;
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public RequestAccess setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public String getLicenseTypes() {
                return this.licenseTypes;
            }

            public RequestAccess setLicenseTypes(String licenseTypes) {
                this.licenseTypes = licenseTypes;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public RequestAccess setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            @Override
            public RequestAccess set(String parameterName, Object value) {
                return (RequestAccess)super.set(parameterName, value);
            }
        }

        public class ReleaseDownloadAccess
        extends BooksRequest<DownloadAccesses> {
            private static final String REST_PATH = "books/v1/myconfig/releaseDownloadAccess";
            @Key
            private String cpksver;
            @Key
            private List<String> volumeIds;
            @Key
            private String locale;
            @Key
            private String source;

            protected ReleaseDownloadAccess(String cpksver, List<String> volumeIds) {
                super(Books.this, "POST", REST_PATH, null, DownloadAccesses.class);
                this.cpksver = (String)Preconditions.checkNotNull((Object)cpksver, (Object)"Required parameter cpksver must be specified.");
                this.volumeIds = (List)Preconditions.checkNotNull(volumeIds, (Object)"Required parameter volumeIds must be specified.");
            }

            public ReleaseDownloadAccess set$Xgafv(String $Xgafv) {
                return (ReleaseDownloadAccess)super.set$Xgafv($Xgafv);
            }

            public ReleaseDownloadAccess setAccessToken(String accessToken) {
                return (ReleaseDownloadAccess)super.setAccessToken(accessToken);
            }

            public ReleaseDownloadAccess setAlt(String alt) {
                return (ReleaseDownloadAccess)super.setAlt(alt);
            }

            public ReleaseDownloadAccess setCallback(String callback) {
                return (ReleaseDownloadAccess)super.setCallback(callback);
            }

            public ReleaseDownloadAccess setFields(String fields) {
                return (ReleaseDownloadAccess)super.setFields(fields);
            }

            public ReleaseDownloadAccess setKey(String key) {
                return (ReleaseDownloadAccess)super.setKey(key);
            }

            public ReleaseDownloadAccess setOauthToken(String oauthToken) {
                return (ReleaseDownloadAccess)super.setOauthToken(oauthToken);
            }

            public ReleaseDownloadAccess setPrettyPrint(Boolean prettyPrint) {
                return (ReleaseDownloadAccess)super.setPrettyPrint(prettyPrint);
            }

            public ReleaseDownloadAccess setQuotaUser(String quotaUser) {
                return (ReleaseDownloadAccess)super.setQuotaUser(quotaUser);
            }

            public ReleaseDownloadAccess setUploadType(String uploadType) {
                return (ReleaseDownloadAccess)super.setUploadType(uploadType);
            }

            public ReleaseDownloadAccess setUploadProtocol(String uploadProtocol) {
                return (ReleaseDownloadAccess)super.setUploadProtocol(uploadProtocol);
            }

            public String getCpksver() {
                return this.cpksver;
            }

            public ReleaseDownloadAccess setCpksver(String cpksver) {
                this.cpksver = cpksver;
                return this;
            }

            public List<String> getVolumeIds() {
                return this.volumeIds;
            }

            public ReleaseDownloadAccess setVolumeIds(List<String> volumeIds) {
                this.volumeIds = volumeIds;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public ReleaseDownloadAccess setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public ReleaseDownloadAccess setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public ReleaseDownloadAccess set(String parameterName, Object value) {
                return (ReleaseDownloadAccess)super.set(parameterName, value);
            }
        }

        public class GetUserSettings
        extends BooksRequest<Usersettings> {
            private static final String REST_PATH = "books/v1/myconfig/getUserSettings";
            @Key
            private String country;

            protected GetUserSettings() {
                super(Books.this, "GET", REST_PATH, null, Usersettings.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetUserSettings set$Xgafv(String $Xgafv) {
                return (GetUserSettings)super.set$Xgafv($Xgafv);
            }

            public GetUserSettings setAccessToken(String accessToken) {
                return (GetUserSettings)super.setAccessToken(accessToken);
            }

            public GetUserSettings setAlt(String alt) {
                return (GetUserSettings)super.setAlt(alt);
            }

            public GetUserSettings setCallback(String callback) {
                return (GetUserSettings)super.setCallback(callback);
            }

            public GetUserSettings setFields(String fields) {
                return (GetUserSettings)super.setFields(fields);
            }

            public GetUserSettings setKey(String key) {
                return (GetUserSettings)super.setKey(key);
            }

            public GetUserSettings setOauthToken(String oauthToken) {
                return (GetUserSettings)super.setOauthToken(oauthToken);
            }

            public GetUserSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetUserSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetUserSettings setQuotaUser(String quotaUser) {
                return (GetUserSettings)super.setQuotaUser(quotaUser);
            }

            public GetUserSettings setUploadType(String uploadType) {
                return (GetUserSettings)super.setUploadType(uploadType);
            }

            public GetUserSettings setUploadProtocol(String uploadProtocol) {
                return (GetUserSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getCountry() {
                return this.country;
            }

            public GetUserSettings setCountry(String country) {
                this.country = country;
                return this;
            }

            @Override
            public GetUserSettings set(String parameterName, Object value) {
                return (GetUserSettings)super.set(parameterName, value);
            }
        }
    }

    public class Layers {
        public Get get(String volumeId, String summaryId) throws IOException {
            Get result = new Get(volumeId, summaryId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String volumeId) throws IOException {
            List result = new List(volumeId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AnnotationData annotationData() {
            return new AnnotationData();
        }

        public VolumeAnnotations volumeAnnotations() {
            return new VolumeAnnotations();
        }

        public class VolumeAnnotations {
            public Get get(String volumeId, String layerId, String annotationId) throws IOException {
                Get result = new Get(volumeId, layerId, annotationId);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String volumeId, String layerId, String contentVersion) throws IOException {
                List result = new List(volumeId, layerId, contentVersion);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BooksRequest<Volumeannotations> {
                private static final String REST_PATH = "books/v1/volumes/{volumeId}/layers/{layerId}";
                @Key
                private String volumeId;
                @Key
                private String layerId;
                @Key
                private String contentVersion;
                @Key
                private String endOffset;
                @Key
                private String endPosition;
                @Key
                private String locale;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private Boolean showDeleted;
                @Key
                private String source;
                @Key
                private String startOffset;
                @Key
                private String startPosition;
                @Key
                private String updatedMax;
                @Key
                private String updatedMin;
                @Key
                private String volumeAnnotationsVersion;

                protected List(String volumeId, String layerId, String contentVersion) {
                    super(Books.this, "GET", REST_PATH, null, Volumeannotations.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                    this.layerId = (String)Preconditions.checkNotNull((Object)layerId, (Object)"Required parameter layerId must be specified.");
                    this.contentVersion = (String)Preconditions.checkNotNull((Object)contentVersion, (Object)"Required parameter contentVersion must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public List setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getLayerId() {
                    return this.layerId;
                }

                public List setLayerId(String layerId) {
                    this.layerId = layerId;
                    return this;
                }

                public String getContentVersion() {
                    return this.contentVersion;
                }

                public List setContentVersion(String contentVersion) {
                    this.contentVersion = contentVersion;
                    return this;
                }

                public String getEndOffset() {
                    return this.endOffset;
                }

                public List setEndOffset(String endOffset) {
                    this.endOffset = endOffset;
                    return this;
                }

                public String getEndPosition() {
                    return this.endPosition;
                }

                public List setEndPosition(String endPosition) {
                    this.endPosition = endPosition;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public List setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean showDeleted) {
                    this.showDeleted = showDeleted;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public String getStartOffset() {
                    return this.startOffset;
                }

                public List setStartOffset(String startOffset) {
                    this.startOffset = startOffset;
                    return this;
                }

                public String getStartPosition() {
                    return this.startPosition;
                }

                public List setStartPosition(String startPosition) {
                    this.startPosition = startPosition;
                    return this;
                }

                public String getUpdatedMax() {
                    return this.updatedMax;
                }

                public List setUpdatedMax(String updatedMax) {
                    this.updatedMax = updatedMax;
                    return this;
                }

                public String getUpdatedMin() {
                    return this.updatedMin;
                }

                public List setUpdatedMin(String updatedMin) {
                    this.updatedMin = updatedMin;
                    return this;
                }

                public String getVolumeAnnotationsVersion() {
                    return this.volumeAnnotationsVersion;
                }

                public List setVolumeAnnotationsVersion(String volumeAnnotationsVersion) {
                    this.volumeAnnotationsVersion = volumeAnnotationsVersion;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends BooksRequest<Volumeannotation> {
                private static final String REST_PATH = "books/v1/volumes/{volumeId}/layers/{layerId}/annotations/{annotationId}";
                @Key
                private String volumeId;
                @Key
                private String layerId;
                @Key
                private String annotationId;
                @Key
                private String locale;
                @Key
                private String source;

                protected Get(String volumeId, String layerId, String annotationId) {
                    super(Books.this, "GET", REST_PATH, null, Volumeannotation.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                    this.layerId = (String)Preconditions.checkNotNull((Object)layerId, (Object)"Required parameter layerId must be specified.");
                    this.annotationId = (String)Preconditions.checkNotNull((Object)annotationId, (Object)"Required parameter annotationId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public Get setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getLayerId() {
                    return this.layerId;
                }

                public Get setLayerId(String layerId) {
                    this.layerId = layerId;
                    return this;
                }

                public String getAnnotationId() {
                    return this.annotationId;
                }

                public Get setAnnotationId(String annotationId) {
                    this.annotationId = annotationId;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public Get setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Get setSource(String source) {
                    this.source = source;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class AnnotationData {
            public Get get(String volumeId, String layerId, String annotationDataId, String contentVersion) throws IOException {
                Get result = new Get(volumeId, layerId, annotationDataId, contentVersion);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String volumeId, String layerId, String contentVersion) throws IOException {
                List result = new List(volumeId, layerId, contentVersion);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BooksRequest<Annotationsdata> {
                private static final String REST_PATH = "books/v1/volumes/{volumeId}/layers/{layerId}/data";
                @Key
                private String volumeId;
                @Key
                private String layerId;
                @Key
                private String contentVersion;
                @Key
                private java.util.List<String> annotationDataId;
                @Key
                private Integer h;
                @Key
                private String locale;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private Integer scale;
                @Key
                private String source;
                @Key
                private String updatedMax;
                @Key
                private String updatedMin;
                @Key
                private Integer w;

                protected List(String volumeId, String layerId, String contentVersion) {
                    super(Books.this, "GET", REST_PATH, null, Annotationsdata.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                    this.layerId = (String)Preconditions.checkNotNull((Object)layerId, (Object)"Required parameter layerId must be specified.");
                    this.contentVersion = (String)Preconditions.checkNotNull((Object)contentVersion, (Object)"Required parameter contentVersion must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public List setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getLayerId() {
                    return this.layerId;
                }

                public List setLayerId(String layerId) {
                    this.layerId = layerId;
                    return this;
                }

                public String getContentVersion() {
                    return this.contentVersion;
                }

                public List setContentVersion(String contentVersion) {
                    this.contentVersion = contentVersion;
                    return this;
                }

                public java.util.List<String> getAnnotationDataId() {
                    return this.annotationDataId;
                }

                public List setAnnotationDataId(java.util.List<String> annotationDataId) {
                    this.annotationDataId = annotationDataId;
                    return this;
                }

                public Integer getH() {
                    return this.h;
                }

                public List setH(Integer h) {
                    this.h = h;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public List setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Integer getScale() {
                    return this.scale;
                }

                public List setScale(Integer scale) {
                    this.scale = scale;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public String getUpdatedMax() {
                    return this.updatedMax;
                }

                public List setUpdatedMax(String updatedMax) {
                    this.updatedMax = updatedMax;
                    return this;
                }

                public String getUpdatedMin() {
                    return this.updatedMin;
                }

                public List setUpdatedMin(String updatedMin) {
                    this.updatedMin = updatedMin;
                    return this;
                }

                public Integer getW() {
                    return this.w;
                }

                public List setW(Integer w) {
                    this.w = w;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends BooksRequest<DictionaryAnnotationdata> {
                private static final String REST_PATH = "books/v1/volumes/{volumeId}/layers/{layerId}/data/{annotationDataId}";
                @Key
                private String volumeId;
                @Key
                private String layerId;
                @Key
                private String annotationDataId;
                @Key
                private String contentVersion;
                @Key
                private Boolean allowWebDefinitions;
                @Key
                private Integer h;
                @Key
                private String locale;
                @Key
                private Integer scale;
                @Key
                private String source;
                @Key
                private Integer w;

                protected Get(String volumeId, String layerId, String annotationDataId, String contentVersion) {
                    super(Books.this, "GET", REST_PATH, null, DictionaryAnnotationdata.class);
                    this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                    this.layerId = (String)Preconditions.checkNotNull((Object)layerId, (Object)"Required parameter layerId must be specified.");
                    this.annotationDataId = (String)Preconditions.checkNotNull((Object)annotationDataId, (Object)"Required parameter annotationDataId must be specified.");
                    this.contentVersion = (String)Preconditions.checkNotNull((Object)contentVersion, (Object)"Required parameter contentVersion must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public Get setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getLayerId() {
                    return this.layerId;
                }

                public Get setLayerId(String layerId) {
                    this.layerId = layerId;
                    return this;
                }

                public String getAnnotationDataId() {
                    return this.annotationDataId;
                }

                public Get setAnnotationDataId(String annotationDataId) {
                    this.annotationDataId = annotationDataId;
                    return this;
                }

                public String getContentVersion() {
                    return this.contentVersion;
                }

                public Get setContentVersion(String contentVersion) {
                    this.contentVersion = contentVersion;
                    return this;
                }

                public Boolean getAllowWebDefinitions() {
                    return this.allowWebDefinitions;
                }

                public Get setAllowWebDefinitions(Boolean allowWebDefinitions) {
                    this.allowWebDefinitions = allowWebDefinitions;
                    return this;
                }

                public Integer getH() {
                    return this.h;
                }

                public Get setH(Integer h) {
                    this.h = h;
                    return this;
                }

                public String getLocale() {
                    return this.locale;
                }

                public Get setLocale(String locale) {
                    this.locale = locale;
                    return this;
                }

                public Integer getScale() {
                    return this.scale;
                }

                public Get setScale(Integer scale) {
                    this.scale = scale;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Get setSource(String source) {
                    this.source = source;
                    return this;
                }

                public Integer getW() {
                    return this.w;
                }

                public Get setW(Integer w) {
                    this.w = w;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends BooksRequest<Layersummaries> {
            private static final String REST_PATH = "books/v1/volumes/{volumeId}/layersummary";
            @Key
            private String volumeId;
            @Key
            private String contentVersion;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String source;

            protected List(String volumeId) {
                super(Books.this, "GET", REST_PATH, null, Layersummaries.class);
                this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public List setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public String getContentVersion() {
                return this.contentVersion;
            }

            public List setContentVersion(String contentVersion) {
                this.contentVersion = contentVersion;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BooksRequest<Layersummary> {
            private static final String REST_PATH = "books/v1/volumes/{volumeId}/layersummary/{summaryId}";
            @Key
            private String volumeId;
            @Key
            private String summaryId;
            @Key
            private String contentVersion;
            @Key
            private String source;

            protected Get(String volumeId, String summaryId) {
                super(Books.this, "GET", REST_PATH, null, Layersummary.class);
                this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
                this.summaryId = (String)Preconditions.checkNotNull((Object)summaryId, (Object)"Required parameter summaryId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public Get setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public String getSummaryId() {
                return this.summaryId;
            }

            public Get setSummaryId(String summaryId) {
                this.summaryId = summaryId;
                return this;
            }

            public String getContentVersion() {
                return this.contentVersion;
            }

            public Get setContentVersion(String contentVersion) {
                this.contentVersion = contentVersion;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Familysharing {
        public GetFamilyInfo getFamilyInfo() throws IOException {
            GetFamilyInfo result = new GetFamilyInfo();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Share share() throws IOException {
            Share result = new Share();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Unshare unshare() throws IOException {
            Unshare result = new Unshare();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Unshare
        extends BooksRequest<Empty> {
            private static final String REST_PATH = "books/v1/familysharing/unshare";
            @Key
            private String docId;
            @Key
            private String source;
            @Key
            private String volumeId;

            protected Unshare() {
                super(Books.this, "POST", REST_PATH, null, Empty.class);
            }

            public Unshare set$Xgafv(String $Xgafv) {
                return (Unshare)super.set$Xgafv($Xgafv);
            }

            public Unshare setAccessToken(String accessToken) {
                return (Unshare)super.setAccessToken(accessToken);
            }

            public Unshare setAlt(String alt) {
                return (Unshare)super.setAlt(alt);
            }

            public Unshare setCallback(String callback) {
                return (Unshare)super.setCallback(callback);
            }

            public Unshare setFields(String fields) {
                return (Unshare)super.setFields(fields);
            }

            public Unshare setKey(String key) {
                return (Unshare)super.setKey(key);
            }

            public Unshare setOauthToken(String oauthToken) {
                return (Unshare)super.setOauthToken(oauthToken);
            }

            public Unshare setPrettyPrint(Boolean prettyPrint) {
                return (Unshare)super.setPrettyPrint(prettyPrint);
            }

            public Unshare setQuotaUser(String quotaUser) {
                return (Unshare)super.setQuotaUser(quotaUser);
            }

            public Unshare setUploadType(String uploadType) {
                return (Unshare)super.setUploadType(uploadType);
            }

            public Unshare setUploadProtocol(String uploadProtocol) {
                return (Unshare)super.setUploadProtocol(uploadProtocol);
            }

            public String getDocId() {
                return this.docId;
            }

            public Unshare setDocId(String docId) {
                this.docId = docId;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Unshare setSource(String source) {
                this.source = source;
                return this;
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public Unshare setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            @Override
            public Unshare set(String parameterName, Object value) {
                return (Unshare)super.set(parameterName, value);
            }
        }

        public class Share
        extends BooksRequest<Empty> {
            private static final String REST_PATH = "books/v1/familysharing/share";
            @Key
            private String docId;
            @Key
            private String source;
            @Key
            private String volumeId;

            protected Share() {
                super(Books.this, "POST", REST_PATH, null, Empty.class);
            }

            public Share set$Xgafv(String $Xgafv) {
                return (Share)super.set$Xgafv($Xgafv);
            }

            public Share setAccessToken(String accessToken) {
                return (Share)super.setAccessToken(accessToken);
            }

            public Share setAlt(String alt) {
                return (Share)super.setAlt(alt);
            }

            public Share setCallback(String callback) {
                return (Share)super.setCallback(callback);
            }

            public Share setFields(String fields) {
                return (Share)super.setFields(fields);
            }

            public Share setKey(String key) {
                return (Share)super.setKey(key);
            }

            public Share setOauthToken(String oauthToken) {
                return (Share)super.setOauthToken(oauthToken);
            }

            public Share setPrettyPrint(Boolean prettyPrint) {
                return (Share)super.setPrettyPrint(prettyPrint);
            }

            public Share setQuotaUser(String quotaUser) {
                return (Share)super.setQuotaUser(quotaUser);
            }

            public Share setUploadType(String uploadType) {
                return (Share)super.setUploadType(uploadType);
            }

            public Share setUploadProtocol(String uploadProtocol) {
                return (Share)super.setUploadProtocol(uploadProtocol);
            }

            public String getDocId() {
                return this.docId;
            }

            public Share setDocId(String docId) {
                this.docId = docId;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Share setSource(String source) {
                this.source = source;
                return this;
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public Share setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            @Override
            public Share set(String parameterName, Object value) {
                return (Share)super.set(parameterName, value);
            }
        }

        public class GetFamilyInfo
        extends BooksRequest<FamilyInfo> {
            private static final String REST_PATH = "books/v1/familysharing/getFamilyInfo";
            @Key
            private String source;

            protected GetFamilyInfo() {
                super(Books.this, "GET", REST_PATH, null, FamilyInfo.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetFamilyInfo set$Xgafv(String $Xgafv) {
                return (GetFamilyInfo)super.set$Xgafv($Xgafv);
            }

            public GetFamilyInfo setAccessToken(String accessToken) {
                return (GetFamilyInfo)super.setAccessToken(accessToken);
            }

            public GetFamilyInfo setAlt(String alt) {
                return (GetFamilyInfo)super.setAlt(alt);
            }

            public GetFamilyInfo setCallback(String callback) {
                return (GetFamilyInfo)super.setCallback(callback);
            }

            public GetFamilyInfo setFields(String fields) {
                return (GetFamilyInfo)super.setFields(fields);
            }

            public GetFamilyInfo setKey(String key) {
                return (GetFamilyInfo)super.setKey(key);
            }

            public GetFamilyInfo setOauthToken(String oauthToken) {
                return (GetFamilyInfo)super.setOauthToken(oauthToken);
            }

            public GetFamilyInfo setPrettyPrint(Boolean prettyPrint) {
                return (GetFamilyInfo)super.setPrettyPrint(prettyPrint);
            }

            public GetFamilyInfo setQuotaUser(String quotaUser) {
                return (GetFamilyInfo)super.setQuotaUser(quotaUser);
            }

            public GetFamilyInfo setUploadType(String uploadType) {
                return (GetFamilyInfo)super.setUploadType(uploadType);
            }

            public GetFamilyInfo setUploadProtocol(String uploadProtocol) {
                return (GetFamilyInfo)super.setUploadProtocol(uploadProtocol);
            }

            public String getSource() {
                return this.source;
            }

            public GetFamilyInfo setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public GetFamilyInfo set(String parameterName, Object value) {
                return (GetFamilyInfo)super.set(parameterName, value);
            }
        }
    }

    public class Dictionary {
        public ListOfflineMetadata listOfflineMetadata(String cpksver) throws IOException {
            ListOfflineMetadata result = new ListOfflineMetadata(cpksver);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ListOfflineMetadata
        extends BooksRequest<Metadata> {
            private static final String REST_PATH = "books/v1/dictionary/listOfflineMetadata";
            @Key
            private String cpksver;

            protected ListOfflineMetadata(String cpksver) {
                super(Books.this, "GET", REST_PATH, null, Metadata.class);
                this.cpksver = (String)Preconditions.checkNotNull((Object)cpksver, (Object)"Required parameter cpksver must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListOfflineMetadata set$Xgafv(String $Xgafv) {
                return (ListOfflineMetadata)super.set$Xgafv($Xgafv);
            }

            public ListOfflineMetadata setAccessToken(String accessToken) {
                return (ListOfflineMetadata)super.setAccessToken(accessToken);
            }

            public ListOfflineMetadata setAlt(String alt) {
                return (ListOfflineMetadata)super.setAlt(alt);
            }

            public ListOfflineMetadata setCallback(String callback) {
                return (ListOfflineMetadata)super.setCallback(callback);
            }

            public ListOfflineMetadata setFields(String fields) {
                return (ListOfflineMetadata)super.setFields(fields);
            }

            public ListOfflineMetadata setKey(String key) {
                return (ListOfflineMetadata)super.setKey(key);
            }

            public ListOfflineMetadata setOauthToken(String oauthToken) {
                return (ListOfflineMetadata)super.setOauthToken(oauthToken);
            }

            public ListOfflineMetadata setPrettyPrint(Boolean prettyPrint) {
                return (ListOfflineMetadata)super.setPrettyPrint(prettyPrint);
            }

            public ListOfflineMetadata setQuotaUser(String quotaUser) {
                return (ListOfflineMetadata)super.setQuotaUser(quotaUser);
            }

            public ListOfflineMetadata setUploadType(String uploadType) {
                return (ListOfflineMetadata)super.setUploadType(uploadType);
            }

            public ListOfflineMetadata setUploadProtocol(String uploadProtocol) {
                return (ListOfflineMetadata)super.setUploadProtocol(uploadProtocol);
            }

            public String getCpksver() {
                return this.cpksver;
            }

            public ListOfflineMetadata setCpksver(String cpksver) {
                this.cpksver = cpksver;
                return this;
            }

            @Override
            public ListOfflineMetadata set(String parameterName, Object value) {
                return (ListOfflineMetadata)super.set(parameterName, value);
            }
        }
    }

    public class Cloudloading {
        public AddBook addBook() throws IOException {
            AddBook result = new AddBook();
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeleteBook deleteBook(String volumeId) throws IOException {
            DeleteBook result = new DeleteBook(volumeId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateBook updateBook(BooksCloudloadingResource content) throws IOException {
            UpdateBook result = new UpdateBook(content);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateBook
        extends BooksRequest<BooksCloudloadingResource> {
            private static final String REST_PATH = "books/v1/cloudloading/updateBook";

            protected UpdateBook(BooksCloudloadingResource content) {
                super(Books.this, "POST", REST_PATH, (Object)content, BooksCloudloadingResource.class);
            }

            public UpdateBook set$Xgafv(String $Xgafv) {
                return (UpdateBook)super.set$Xgafv($Xgafv);
            }

            public UpdateBook setAccessToken(String accessToken) {
                return (UpdateBook)super.setAccessToken(accessToken);
            }

            public UpdateBook setAlt(String alt) {
                return (UpdateBook)super.setAlt(alt);
            }

            public UpdateBook setCallback(String callback) {
                return (UpdateBook)super.setCallback(callback);
            }

            public UpdateBook setFields(String fields) {
                return (UpdateBook)super.setFields(fields);
            }

            public UpdateBook setKey(String key) {
                return (UpdateBook)super.setKey(key);
            }

            public UpdateBook setOauthToken(String oauthToken) {
                return (UpdateBook)super.setOauthToken(oauthToken);
            }

            public UpdateBook setPrettyPrint(Boolean prettyPrint) {
                return (UpdateBook)super.setPrettyPrint(prettyPrint);
            }

            public UpdateBook setQuotaUser(String quotaUser) {
                return (UpdateBook)super.setQuotaUser(quotaUser);
            }

            public UpdateBook setUploadType(String uploadType) {
                return (UpdateBook)super.setUploadType(uploadType);
            }

            public UpdateBook setUploadProtocol(String uploadProtocol) {
                return (UpdateBook)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public UpdateBook set(String parameterName, Object value) {
                return (UpdateBook)super.set(parameterName, value);
            }
        }

        public class DeleteBook
        extends BooksRequest<Empty> {
            private static final String REST_PATH = "books/v1/cloudloading/deleteBook";
            @Key
            private String volumeId;

            protected DeleteBook(String volumeId) {
                super(Books.this, "POST", REST_PATH, null, Empty.class);
                this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"Required parameter volumeId must be specified.");
            }

            public DeleteBook set$Xgafv(String $Xgafv) {
                return (DeleteBook)super.set$Xgafv($Xgafv);
            }

            public DeleteBook setAccessToken(String accessToken) {
                return (DeleteBook)super.setAccessToken(accessToken);
            }

            public DeleteBook setAlt(String alt) {
                return (DeleteBook)super.setAlt(alt);
            }

            public DeleteBook setCallback(String callback) {
                return (DeleteBook)super.setCallback(callback);
            }

            public DeleteBook setFields(String fields) {
                return (DeleteBook)super.setFields(fields);
            }

            public DeleteBook setKey(String key) {
                return (DeleteBook)super.setKey(key);
            }

            public DeleteBook setOauthToken(String oauthToken) {
                return (DeleteBook)super.setOauthToken(oauthToken);
            }

            public DeleteBook setPrettyPrint(Boolean prettyPrint) {
                return (DeleteBook)super.setPrettyPrint(prettyPrint);
            }

            public DeleteBook setQuotaUser(String quotaUser) {
                return (DeleteBook)super.setQuotaUser(quotaUser);
            }

            public DeleteBook setUploadType(String uploadType) {
                return (DeleteBook)super.setUploadType(uploadType);
            }

            public DeleteBook setUploadProtocol(String uploadProtocol) {
                return (DeleteBook)super.setUploadProtocol(uploadProtocol);
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public DeleteBook setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            @Override
            public DeleteBook set(String parameterName, Object value) {
                return (DeleteBook)super.set(parameterName, value);
            }
        }

        public class AddBook
        extends BooksRequest<BooksCloudloadingResource> {
            private static final String REST_PATH = "books/v1/cloudloading/addBook";
            @Key(value="drive_document_id")
            private String driveDocumentId;
            @Key(value="mime_type")
            private String mimeType;
            @Key
            private String name;
            @Key(value="upload_client_token")
            private String uploadClientToken;

            protected AddBook() {
                super(Books.this, "POST", REST_PATH, null, BooksCloudloadingResource.class);
            }

            public AddBook set$Xgafv(String $Xgafv) {
                return (AddBook)super.set$Xgafv($Xgafv);
            }

            public AddBook setAccessToken(String accessToken) {
                return (AddBook)super.setAccessToken(accessToken);
            }

            public AddBook setAlt(String alt) {
                return (AddBook)super.setAlt(alt);
            }

            public AddBook setCallback(String callback) {
                return (AddBook)super.setCallback(callback);
            }

            public AddBook setFields(String fields) {
                return (AddBook)super.setFields(fields);
            }

            public AddBook setKey(String key) {
                return (AddBook)super.setKey(key);
            }

            public AddBook setOauthToken(String oauthToken) {
                return (AddBook)super.setOauthToken(oauthToken);
            }

            public AddBook setPrettyPrint(Boolean prettyPrint) {
                return (AddBook)super.setPrettyPrint(prettyPrint);
            }

            public AddBook setQuotaUser(String quotaUser) {
                return (AddBook)super.setQuotaUser(quotaUser);
            }

            public AddBook setUploadType(String uploadType) {
                return (AddBook)super.setUploadType(uploadType);
            }

            public AddBook setUploadProtocol(String uploadProtocol) {
                return (AddBook)super.setUploadProtocol(uploadProtocol);
            }

            public String getDriveDocumentId() {
                return this.driveDocumentId;
            }

            public AddBook setDriveDocumentId(String driveDocumentId) {
                this.driveDocumentId = driveDocumentId;
                return this;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public AddBook setMimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public AddBook setName(String name) {
                this.name = name;
                return this;
            }

            public String getUploadClientToken() {
                return this.uploadClientToken;
            }

            public AddBook setUploadClientToken(String uploadClientToken) {
                this.uploadClientToken = uploadClientToken;
                return this;
            }

            @Override
            public AddBook set(String parameterName, Object value) {
                return (AddBook)super.set(parameterName, value);
            }
        }
    }

    public class Bookshelves {
        public Get get(String userId, String shelf) throws IOException {
            Get result = new Get(userId, shelf);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userId) throws IOException {
            List result = new List(userId);
            Books.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Volumes volumes() {
            return new Volumes();
        }

        public class Volumes {
            public List list(String userId, String shelf) throws IOException {
                List result = new List(userId, shelf);
                Books.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BooksRequest<com.google.api.services.books.v1.model.Volumes> {
                private static final String REST_PATH = "books/v1/users/{userId}/bookshelves/{shelf}/volumes";
                @Key
                private String userId;
                @Key
                private String shelf;
                @Key
                private Long maxResults;
                @Key
                private Boolean showPreorders;
                @Key
                private String source;
                @Key
                private Long startIndex;

                protected List(String userId, String shelf) {
                    super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Volumes.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getShelf() {
                    return this.shelf;
                }

                public List setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Boolean getShowPreorders() {
                    return this.showPreorders;
                }

                public List setShowPreorders(Boolean showPreorders) {
                    this.showPreorders = showPreorders;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends BooksRequest<com.google.api.services.books.v1.model.Bookshelves> {
            private static final String REST_PATH = "books/v1/users/{userId}/bookshelves";
            @Key
            private String userId;
            @Key
            private String source;

            protected List(String userId) {
                super(Books.this, "GET", REST_PATH, null, com.google.api.services.books.v1.model.Bookshelves.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends BooksRequest<Bookshelf> {
            private static final String REST_PATH = "books/v1/users/{userId}/bookshelves/{shelf}";
            @Key
            private String userId;
            @Key
            private String shelf;
            @Key
            private String source;

            protected Get(String userId, String shelf) {
                super(Books.this, "GET", REST_PATH, null, Bookshelf.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                this.shelf = (String)Preconditions.checkNotNull((Object)shelf, (Object)"Required parameter shelf must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getShelf() {
                return this.shelf;
            }

            public Get setShelf(String shelf) {
                this.shelf = shelf;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

