/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.calendar;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.CalendarRequestInitializer;
import com.google.api.services.calendar.model.AclRule;
import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Channel;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.FreeBusyRequest;
import com.google.api.services.calendar.model.FreeBusyResponse;
import com.google.api.services.calendar.model.Setting;
import java.io.IOException;
import java.util.List;

public class Calendar
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "calendar/v3/";
    public static final String DEFAULT_BATCH_PATH = "batch/calendar/v3";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/calendar/v3/";

    public Calendar(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Calendar(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Acl acl() {
        return new Acl();
    }

    public CalendarList calendarList() {
        return new CalendarList();
    }

    public Calendars calendars() {
        return new Calendars();
    }

    public Channels channels() {
        return new Channels();
    }

    public Colors colors() {
        return new Colors();
    }

    public Events events() {
        return new Events();
    }

    public Freebusy freebusy() {
        return new Freebusy();
    }

    public Settings settings() {
        return new Settings();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.5 of the Calendar API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Calendar.DEFAULT_MTLS_ROOT_URL;
            }
            return Calendar.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Calendar.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Calendar.DEFAULT_BATCH_PATH);
        }

        public Calendar build() {
            return new Calendar(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCalendarRequestInitializer(CalendarRequestInitializer calendarRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)calendarRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Settings {
        public Get get(String setting) throws IOException {
            Get result = new Get(setting);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(Channel content) throws IOException {
            Watch result = new Watch(content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends CalendarRequest<Channel> {
            private static final String REST_PATH = "users/me/settings/watch";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String syncToken;

            protected Watch(Channel content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Channel.class);
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public Watch setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.Settings> {
            private static final String REST_PATH = "users/me/settings";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String syncToken;

            protected List() {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Settings.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CalendarRequest<Setting> {
            private static final String REST_PATH = "users/me/settings/{setting}";
            @Key
            private String setting;

            protected Get(String setting) {
                super(Calendar.this, "GET", REST_PATH, null, Setting.class);
                this.setting = (String)Preconditions.checkNotNull((Object)setting, (Object)"Required parameter setting must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getSetting() {
                return this.setting;
            }

            public Get setSetting(String setting) {
                this.setting = setting;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Freebusy {
        public Query query(FreeBusyRequest content) throws IOException {
            Query result = new Query(content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends CalendarRequest<FreeBusyResponse> {
            private static final String REST_PATH = "freeBusy";

            protected Query(FreeBusyRequest content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, FreeBusyResponse.class);
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUserIp(String userIp) {
                return (Query)super.setUserIp(userIp);
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }
    }

    public class Events {
        public Delete delete(String calendarId, String eventId) throws IOException {
            Delete result = new Delete(calendarId, eventId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String calendarId, String eventId) throws IOException {
            Get result = new Get(calendarId, eventId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public CalendarImport calendarImport(String calendarId, Event content) throws IOException {
            CalendarImport result = new CalendarImport(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String calendarId, Event content) throws IOException {
            Insert result = new Insert(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Instances instances(String calendarId, String eventId) throws IOException {
            Instances result = new Instances(calendarId, eventId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String calendarId) throws IOException {
            List result = new List(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Move move(String calendarId, String eventId, String destination) throws IOException {
            Move result = new Move(calendarId, eventId, destination);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String calendarId, String eventId, Event content) throws IOException {
            Patch result = new Patch(calendarId, eventId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public QuickAdd quickAdd(String calendarId, String text) throws IOException {
            QuickAdd result = new QuickAdd(calendarId, text);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String calendarId, String eventId, Event content) throws IOException {
            Update result = new Update(calendarId, eventId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(String calendarId, Channel content) throws IOException {
            Watch result = new Watch(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends CalendarRequest<Channel> {
            private static final String REST_PATH = "calendars/{calendarId}/events/watch";
            @Key
            private String calendarId;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private String iCalUID;
            @Key
            private Integer maxAttendees;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> privateExtendedProperty;
            @Key
            private String q;
            @Key
            private java.util.List<String> sharedExtendedProperty;
            @Key
            private Boolean showDeleted;
            @Key
            private Boolean showHiddenInvitations;
            @Key
            private Boolean singleEvents;
            @Key
            private String syncToken;
            @Key
            private DateTime timeMax;
            @Key
            private DateTime timeMin;
            @Key
            private String timeZone;
            @Key
            private DateTime updatedMin;

            protected Watch(String calendarId, Channel content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Channel.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Watch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Watch setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
                this.alwaysIncludeEmail = alwaysIncludeEmail;
                return this;
            }

            public String getICalUID() {
                return this.iCalUID;
            }

            public Watch setICalUID(String iCalUID) {
                this.iCalUID = iCalUID;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Watch setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Watch setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getPrivateExtendedProperty() {
                return this.privateExtendedProperty;
            }

            public Watch setPrivateExtendedProperty(java.util.List<String> privateExtendedProperty) {
                this.privateExtendedProperty = privateExtendedProperty;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public Watch setQ(String q) {
                this.q = q;
                return this;
            }

            public java.util.List<String> getSharedExtendedProperty() {
                return this.sharedExtendedProperty;
            }

            public Watch setSharedExtendedProperty(java.util.List<String> sharedExtendedProperty) {
                this.sharedExtendedProperty = sharedExtendedProperty;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Watch setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public Boolean getShowHiddenInvitations() {
                return this.showHiddenInvitations;
            }

            public Watch setShowHiddenInvitations(Boolean showHiddenInvitations) {
                this.showHiddenInvitations = showHiddenInvitations;
                return this;
            }

            public Boolean getSingleEvents() {
                return this.singleEvents;
            }

            public Watch setSingleEvents(Boolean singleEvents) {
                this.singleEvents = singleEvents;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public Watch setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            public DateTime getTimeMax() {
                return this.timeMax;
            }

            public Watch setTimeMax(DateTime timeMax) {
                this.timeMax = timeMax;
                return this;
            }

            public DateTime getTimeMin() {
                return this.timeMin;
            }

            public Watch setTimeMin(DateTime timeMin) {
                this.timeMin = timeMin;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Watch setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public DateTime getUpdatedMin() {
                return this.updatedMin;
            }

            public Watch setUpdatedMin(DateTime updatedMin) {
                this.updatedMin = updatedMin;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Update
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer conferenceDataVersion;
            @Key
            private Integer maxAttendees;
            @Key
            private Boolean sendNotifications;
            @Key
            private String sendUpdates;
            @Key
            private Boolean supportsAttachments;

            protected Update(String calendarId, String eventId, Event content) {
                super(Calendar.this, "PUT", REST_PATH, (Object)content, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Update setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Update setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
                this.alwaysIncludeEmail = alwaysIncludeEmail;
                return this;
            }

            public Integer getConferenceDataVersion() {
                return this.conferenceDataVersion;
            }

            public Update setConferenceDataVersion(Integer conferenceDataVersion) {
                this.conferenceDataVersion = conferenceDataVersion;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Update setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Update setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            public String getSendUpdates() {
                return this.sendUpdates;
            }

            public Update setSendUpdates(String sendUpdates) {
                this.sendUpdates = sendUpdates;
                return this;
            }

            public Boolean getSupportsAttachments() {
                return this.supportsAttachments;
            }

            public Update setSupportsAttachments(Boolean supportsAttachments) {
                this.supportsAttachments = supportsAttachments;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class QuickAdd
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/quickAdd";
            @Key
            private String calendarId;
            @Key
            private String text;
            @Key
            private Boolean sendNotifications;
            @Key
            private String sendUpdates;

            protected QuickAdd(String calendarId, String text) {
                super(Calendar.this, "POST", REST_PATH, null, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.text = (String)Preconditions.checkNotNull((Object)text, (Object)"Required parameter text must be specified.");
            }

            public QuickAdd setAlt(String alt) {
                return (QuickAdd)super.setAlt(alt);
            }

            public QuickAdd setFields(String fields) {
                return (QuickAdd)super.setFields(fields);
            }

            public QuickAdd setKey(String key) {
                return (QuickAdd)super.setKey(key);
            }

            public QuickAdd setOauthToken(String oauthToken) {
                return (QuickAdd)super.setOauthToken(oauthToken);
            }

            public QuickAdd setPrettyPrint(Boolean prettyPrint) {
                return (QuickAdd)super.setPrettyPrint(prettyPrint);
            }

            public QuickAdd setQuotaUser(String quotaUser) {
                return (QuickAdd)super.setQuotaUser(quotaUser);
            }

            public QuickAdd setUserIp(String userIp) {
                return (QuickAdd)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public QuickAdd setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getText() {
                return this.text;
            }

            public QuickAdd setText(String text) {
                this.text = text;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public QuickAdd setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            public String getSendUpdates() {
                return this.sendUpdates;
            }

            public QuickAdd setSendUpdates(String sendUpdates) {
                this.sendUpdates = sendUpdates;
                return this;
            }

            @Override
            public QuickAdd set(String parameterName, Object value) {
                return (QuickAdd)super.set(parameterName, value);
            }
        }

        public class Patch
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer conferenceDataVersion;
            @Key
            private Integer maxAttendees;
            @Key
            private Boolean sendNotifications;
            @Key
            private String sendUpdates;
            @Key
            private Boolean supportsAttachments;

            protected Patch(String calendarId, String eventId, Event content) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)content, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Patch setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Patch setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
                this.alwaysIncludeEmail = alwaysIncludeEmail;
                return this;
            }

            public Integer getConferenceDataVersion() {
                return this.conferenceDataVersion;
            }

            public Patch setConferenceDataVersion(Integer conferenceDataVersion) {
                this.conferenceDataVersion = conferenceDataVersion;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Patch setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Patch setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            public String getSendUpdates() {
                return this.sendUpdates;
            }

            public Patch setSendUpdates(String sendUpdates) {
                this.sendUpdates = sendUpdates;
                return this;
            }

            public Boolean getSupportsAttachments() {
                return this.supportsAttachments;
            }

            public Patch setSupportsAttachments(Boolean supportsAttachments) {
                this.supportsAttachments = supportsAttachments;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Move
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/move";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private String destination;
            @Key
            private Boolean sendNotifications;
            @Key
            private String sendUpdates;

            protected Move(String calendarId, String eventId, String destination) {
                super(Calendar.this, "POST", REST_PATH, null, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                this.destination = (String)Preconditions.checkNotNull((Object)destination, (Object)"Required parameter destination must be specified.");
            }

            public Move setAlt(String alt) {
                return (Move)super.setAlt(alt);
            }

            public Move setFields(String fields) {
                return (Move)super.setFields(fields);
            }

            public Move setKey(String key) {
                return (Move)super.setKey(key);
            }

            public Move setOauthToken(String oauthToken) {
                return (Move)super.setOauthToken(oauthToken);
            }

            public Move setPrettyPrint(Boolean prettyPrint) {
                return (Move)super.setPrettyPrint(prettyPrint);
            }

            public Move setQuotaUser(String quotaUser) {
                return (Move)super.setQuotaUser(quotaUser);
            }

            public Move setUserIp(String userIp) {
                return (Move)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Move setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Move setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public String getDestination() {
                return this.destination;
            }

            public Move setDestination(String destination) {
                this.destination = destination;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Move setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            public String getSendUpdates() {
                return this.sendUpdates;
            }

            public Move setSendUpdates(String sendUpdates) {
                this.sendUpdates = sendUpdates;
                return this;
            }

            @Override
            public Move set(String parameterName, Object value) {
                return (Move)super.set(parameterName, value);
            }
        }

        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.Events> {
            private static final String REST_PATH = "calendars/{calendarId}/events";
            @Key
            private String calendarId;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private String iCalUID;
            @Key
            private Integer maxAttendees;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> privateExtendedProperty;
            @Key
            private String q;
            @Key
            private java.util.List<String> sharedExtendedProperty;
            @Key
            private Boolean showDeleted;
            @Key
            private Boolean showHiddenInvitations;
            @Key
            private Boolean singleEvents;
            @Key
            private String syncToken;
            @Key
            private DateTime timeMax;
            @Key
            private DateTime timeMin;
            @Key
            private String timeZone;
            @Key
            private DateTime updatedMin;

            protected List(String calendarId) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Events.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public List setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public List setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
                this.alwaysIncludeEmail = alwaysIncludeEmail;
                return this;
            }

            public String getICalUID() {
                return this.iCalUID;
            }

            public List setICalUID(String iCalUID) {
                this.iCalUID = iCalUID;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public List setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getPrivateExtendedProperty() {
                return this.privateExtendedProperty;
            }

            public List setPrivateExtendedProperty(java.util.List<String> privateExtendedProperty) {
                this.privateExtendedProperty = privateExtendedProperty;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public java.util.List<String> getSharedExtendedProperty() {
                return this.sharedExtendedProperty;
            }

            public List setSharedExtendedProperty(java.util.List<String> sharedExtendedProperty) {
                this.sharedExtendedProperty = sharedExtendedProperty;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public Boolean getShowHiddenInvitations() {
                return this.showHiddenInvitations;
            }

            public List setShowHiddenInvitations(Boolean showHiddenInvitations) {
                this.showHiddenInvitations = showHiddenInvitations;
                return this;
            }

            public Boolean getSingleEvents() {
                return this.singleEvents;
            }

            public List setSingleEvents(Boolean singleEvents) {
                this.singleEvents = singleEvents;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            public DateTime getTimeMax() {
                return this.timeMax;
            }

            public List setTimeMax(DateTime timeMax) {
                this.timeMax = timeMax;
                return this;
            }

            public DateTime getTimeMin() {
                return this.timeMin;
            }

            public List setTimeMin(DateTime timeMin) {
                this.timeMin = timeMin;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public List setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public DateTime getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(DateTime updatedMin) {
                this.updatedMin = updatedMin;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Instances
        extends CalendarRequest<com.google.api.services.calendar.model.Events> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/instances";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxAttendees;
            @Key
            private Integer maxResults;
            @Key
            private String originalStart;
            @Key
            private String pageToken;
            @Key
            private Boolean showDeleted;
            @Key
            private DateTime timeMax;
            @Key
            private DateTime timeMin;
            @Key
            private String timeZone;

            protected Instances(String calendarId, String eventId) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Events.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Instances setAlt(String alt) {
                return (Instances)super.setAlt(alt);
            }

            public Instances setFields(String fields) {
                return (Instances)super.setFields(fields);
            }

            public Instances setKey(String key) {
                return (Instances)super.setKey(key);
            }

            public Instances setOauthToken(String oauthToken) {
                return (Instances)super.setOauthToken(oauthToken);
            }

            public Instances setPrettyPrint(Boolean prettyPrint) {
                return (Instances)super.setPrettyPrint(prettyPrint);
            }

            public Instances setQuotaUser(String quotaUser) {
                return (Instances)super.setQuotaUser(quotaUser);
            }

            public Instances setUserIp(String userIp) {
                return (Instances)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Instances setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Instances setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Instances setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
                this.alwaysIncludeEmail = alwaysIncludeEmail;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Instances setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Instances setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOriginalStart() {
                return this.originalStart;
            }

            public Instances setOriginalStart(String originalStart) {
                this.originalStart = originalStart;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Instances setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Instances setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public DateTime getTimeMax() {
                return this.timeMax;
            }

            public Instances setTimeMax(DateTime timeMax) {
                this.timeMax = timeMax;
                return this;
            }

            public DateTime getTimeMin() {
                return this.timeMin;
            }

            public Instances setTimeMin(DateTime timeMin) {
                this.timeMin = timeMin;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Instances setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            @Override
            public Instances set(String parameterName, Object value) {
                return (Instances)super.set(parameterName, value);
            }
        }

        public class Insert
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events";
            @Key
            private String calendarId;
            @Key
            private Integer conferenceDataVersion;
            @Key
            private Integer maxAttendees;
            @Key
            private Boolean sendNotifications;
            @Key
            private String sendUpdates;
            @Key
            private Boolean supportsAttachments;

            protected Insert(String calendarId, Event content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Insert setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Integer getConferenceDataVersion() {
                return this.conferenceDataVersion;
            }

            public Insert setConferenceDataVersion(Integer conferenceDataVersion) {
                this.conferenceDataVersion = conferenceDataVersion;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Insert setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Insert setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            public String getSendUpdates() {
                return this.sendUpdates;
            }

            public Insert setSendUpdates(String sendUpdates) {
                this.sendUpdates = sendUpdates;
                return this;
            }

            public Boolean getSupportsAttachments() {
                return this.supportsAttachments;
            }

            public Insert setSupportsAttachments(Boolean supportsAttachments) {
                this.supportsAttachments = supportsAttachments;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class CalendarImport
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/import";
            @Key
            private String calendarId;
            @Key
            private Integer conferenceDataVersion;
            @Key
            private Boolean supportsAttachments;

            protected CalendarImport(String calendarId, Event content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getICalUID(), "Event.getICalUID()");
            }

            public CalendarImport setAlt(String alt) {
                return (CalendarImport)super.setAlt(alt);
            }

            public CalendarImport setFields(String fields) {
                return (CalendarImport)super.setFields(fields);
            }

            public CalendarImport setKey(String key) {
                return (CalendarImport)super.setKey(key);
            }

            public CalendarImport setOauthToken(String oauthToken) {
                return (CalendarImport)super.setOauthToken(oauthToken);
            }

            public CalendarImport setPrettyPrint(Boolean prettyPrint) {
                return (CalendarImport)super.setPrettyPrint(prettyPrint);
            }

            public CalendarImport setQuotaUser(String quotaUser) {
                return (CalendarImport)super.setQuotaUser(quotaUser);
            }

            public CalendarImport setUserIp(String userIp) {
                return (CalendarImport)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public CalendarImport setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Integer getConferenceDataVersion() {
                return this.conferenceDataVersion;
            }

            public CalendarImport setConferenceDataVersion(Integer conferenceDataVersion) {
                this.conferenceDataVersion = conferenceDataVersion;
                return this;
            }

            public Boolean getSupportsAttachments() {
                return this.supportsAttachments;
            }

            public CalendarImport setSupportsAttachments(Boolean supportsAttachments) {
                this.supportsAttachments = supportsAttachments;
                return this;
            }

            @Override
            public CalendarImport set(String parameterName, Object value) {
                return (CalendarImport)super.set(parameterName, value);
            }
        }

        public class Get
        extends CalendarRequest<Event> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean alwaysIncludeEmail;
            @Key
            private Integer maxAttendees;
            @Key
            private String timeZone;

            protected Get(String calendarId, String eventId) {
                super(Calendar.this, "GET", REST_PATH, null, Event.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Get setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getAlwaysIncludeEmail() {
                return this.alwaysIncludeEmail;
            }

            public Get setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
                this.alwaysIncludeEmail = alwaysIncludeEmail;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Get setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Get setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key
            private String calendarId;
            @Key
            private String eventId;
            @Key
            private Boolean sendNotifications;
            @Key
            private String sendUpdates;

            protected Delete(String calendarId, String eventId) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Delete setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Delete setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            public String getSendUpdates() {
                return this.sendUpdates;
            }

            public Delete setSendUpdates(String sendUpdates) {
                this.sendUpdates = sendUpdates;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Colors {
        public Get get() throws IOException {
            Get result = new Get();
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends CalendarRequest<com.google.api.services.calendar.model.Colors> {
            private static final String REST_PATH = "colors";

            protected Get() {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Colors.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel content) throws IOException {
            Stop result = new Stop(content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Stop
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Void.class);
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUserIp(String userIp) {
                return (Stop)super.setUserIp(userIp);
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }
    }

    public class Calendars {
        public Clear clear(String calendarId) throws IOException {
            Clear result = new Clear(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String calendarId) throws IOException {
            Delete result = new Delete(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String calendarId) throws IOException {
            Get result = new Get(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(com.google.api.services.calendar.model.Calendar content) throws IOException {
            Insert result = new Insert(content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String calendarId, com.google.api.services.calendar.model.Calendar content) throws IOException {
            Patch result = new Patch(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String calendarId, com.google.api.services.calendar.model.Calendar content) throws IOException {
            Update result = new Update(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Update(String calendarId, com.google.api.services.calendar.model.Calendar content) {
                super(Calendar.this, "PUT", REST_PATH, (Object)content, com.google.api.services.calendar.model.Calendar.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Patch(String calendarId, com.google.api.services.calendar.model.Calendar content) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.calendar.model.Calendar.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Insert
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars";

            protected Insert(com.google.api.services.calendar.model.Calendar content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, com.google.api.services.calendar.model.Calendar.class);
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getSummary(), "Calendar.getSummary()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Get(String calendarId) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Calendar.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key
            private String calendarId;

            protected Delete(String calendarId) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Clear
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}/clear";
            @Key
            private String calendarId;

            protected Clear(String calendarId) {
                super(Calendar.this, "POST", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Clear setAlt(String alt) {
                return (Clear)super.setAlt(alt);
            }

            public Clear setFields(String fields) {
                return (Clear)super.setFields(fields);
            }

            public Clear setKey(String key) {
                return (Clear)super.setKey(key);
            }

            public Clear setOauthToken(String oauthToken) {
                return (Clear)super.setOauthToken(oauthToken);
            }

            public Clear setPrettyPrint(Boolean prettyPrint) {
                return (Clear)super.setPrettyPrint(prettyPrint);
            }

            public Clear setQuotaUser(String quotaUser) {
                return (Clear)super.setQuotaUser(quotaUser);
            }

            public Clear setUserIp(String userIp) {
                return (Clear)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Clear setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Clear set(String parameterName, Object value) {
                return (Clear)super.set(parameterName, value);
            }
        }
    }

    public class CalendarList {
        public Delete delete(String calendarId) throws IOException {
            Delete result = new Delete(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String calendarId) throws IOException {
            Get result = new Get(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(CalendarListEntry content) throws IOException {
            Insert result = new Insert(content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String calendarId, CalendarListEntry content) throws IOException {
            Patch result = new Patch(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String calendarId, CalendarListEntry content) throws IOException {
            Update result = new Update(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(Channel content) throws IOException {
            Watch result = new Watch(content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends CalendarRequest<Channel> {
            private static final String REST_PATH = "users/me/calendarList/watch";
            @Key
            private Integer maxResults;
            @Key
            private String minAccessRole;
            @Key
            private String pageToken;
            @Key
            private Boolean showDeleted;
            @Key
            private Boolean showHidden;
            @Key
            private String syncToken;

            protected Watch(Channel content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Channel.class);
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getMinAccessRole() {
                return this.minAccessRole;
            }

            public Watch setMinAccessRole(String minAccessRole) {
                this.minAccessRole = minAccessRole;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Watch setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public Watch setShowHidden(Boolean showHidden) {
                this.showHidden = showHidden;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public Watch setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Update
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;
            @Key
            private Boolean colorRgbFormat;

            protected Update(String calendarId, CalendarListEntry content) {
                super(Calendar.this, "PUT", REST_PATH, (Object)content, CalendarListEntry.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Boolean getColorRgbFormat() {
                return this.colorRgbFormat;
            }

            public Update setColorRgbFormat(Boolean colorRgbFormat) {
                this.colorRgbFormat = colorRgbFormat;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;
            @Key
            private Boolean colorRgbFormat;

            protected Patch(String calendarId, CalendarListEntry content) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)content, CalendarListEntry.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Boolean getColorRgbFormat() {
                return this.colorRgbFormat;
            }

            public Patch setColorRgbFormat(Boolean colorRgbFormat) {
                this.colorRgbFormat = colorRgbFormat;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.CalendarList> {
            private static final String REST_PATH = "users/me/calendarList";
            @Key
            private Integer maxResults;
            @Key
            private String minAccessRole;
            @Key
            private String pageToken;
            @Key
            private Boolean showDeleted;
            @Key
            private Boolean showHidden;
            @Key
            private String syncToken;

            protected List() {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.CalendarList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getMinAccessRole() {
                return this.minAccessRole;
            }

            public List setMinAccessRole(String minAccessRole) {
                this.minAccessRole = minAccessRole;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public List setShowHidden(Boolean showHidden) {
                this.showHidden = showHidden;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList";
            @Key
            private Boolean colorRgbFormat;

            protected Insert(CalendarListEntry content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, CalendarListEntry.class);
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "CalendarListEntry.getId()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public Boolean getColorRgbFormat() {
                return this.colorRgbFormat;
            }

            public Insert setColorRgbFormat(Boolean colorRgbFormat) {
                this.colorRgbFormat = colorRgbFormat;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends CalendarRequest<CalendarListEntry> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;

            protected Get(String calendarId) {
                super(Calendar.this, "GET", REST_PATH, null, CalendarListEntry.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key
            private String calendarId;

            protected Delete(String calendarId) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Acl {
        public Delete delete(String calendarId, String ruleId) throws IOException {
            Delete result = new Delete(calendarId, ruleId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String calendarId, String ruleId) throws IOException {
            Get result = new Get(calendarId, ruleId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String calendarId, AclRule content) throws IOException {
            Insert result = new Insert(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String calendarId) throws IOException {
            List result = new List(calendarId);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String calendarId, String ruleId, AclRule content) throws IOException {
            Patch result = new Patch(calendarId, ruleId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String calendarId, String ruleId, AclRule content) throws IOException {
            Update result = new Update(calendarId, ruleId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(String calendarId, Channel content) throws IOException {
            Watch result = new Watch(calendarId, content);
            Calendar.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Watch
        extends CalendarRequest<Channel> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/watch";
            @Key
            private String calendarId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private Boolean showDeleted;
            @Key
            private String syncToken;

            protected Watch(String calendarId, Channel content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, Channel.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Watch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Watch setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public Watch setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Update
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;
            @Key
            private Boolean sendNotifications;

            protected Update(String calendarId, String ruleId, AclRule content) {
                super(Calendar.this, "PUT", REST_PATH, (Object)content, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter((Object)content.getScope(), "AclRule.getScope()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getScope().getType(), "AclRule.getScope().getType()");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Update setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Update setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;
            @Key
            private Boolean sendNotifications;

            protected Patch(String calendarId, String ruleId, AclRule content) {
                super(Calendar.this, "PATCH", REST_PATH, (Object)content, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Patch setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Patch setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CalendarRequest<com.google.api.services.calendar.model.Acl> {
            private static final String REST_PATH = "calendars/{calendarId}/acl";
            @Key
            private String calendarId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private Boolean showDeleted;
            @Key
            private String syncToken;

            protected List(String calendarId) {
                super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Acl.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public List setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl";
            @Key
            private String calendarId;
            @Key
            private Boolean sendNotifications;

            protected Insert(String calendarId, AclRule content) {
                super(Calendar.this, "POST", REST_PATH, (Object)content, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRole(), "AclRule.getRole()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter((Object)content.getScope(), "AclRule.getScope()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getScope().getType(), "AclRule.getScope().getType()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Insert setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Insert setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends CalendarRequest<AclRule> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;

            protected Get(String calendarId, String ruleId) {
                super(Calendar.this, "GET", REST_PATH, null, AclRule.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Get setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CalendarRequest<Void> {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key
            private String calendarId;
            @Key
            private String ruleId;

            protected Delete(String calendarId, String ruleId) {
                super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
                this.calendarId = (String)Preconditions.checkNotNull((Object)calendarId, (Object)"Required parameter calendarId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Delete setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

