/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventFocusTimeProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventFocusTimeProperties extends com.google.api.client.json.GenericJson {

  /**
   * Whether to decline meeting invitations which overlap Focus Time events. Valid values are
   * declineNone, meaning that no meeting invitations are declined;
   * declineAllConflictingInvitations, meaning that all conflicting meeting invitations that
   * conflict with the event are declined; and declineOnlyNewConflictingInvitations, meaning that
   * only new conflicting meeting invitations which arrive while the Focus Time event is present are
   * to be declined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String autoDeclineMode;

  /**
   * The status to mark the user in Chat and related products. This can be available or
   * doNotDisturb.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String chatStatus;

  /**
   * Response message to set if an existing event or new invitation is automatically declined by
   * Calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String declineMessage;

  /**
   * Whether to decline meeting invitations which overlap Focus Time events. Valid values are
   * declineNone, meaning that no meeting invitations are declined;
   * declineAllConflictingInvitations, meaning that all conflicting meeting invitations that
   * conflict with the event are declined; and declineOnlyNewConflictingInvitations, meaning that
   * only new conflicting meeting invitations which arrive while the Focus Time event is present are
   * to be declined.
   * @return value or {@code null} for none
   */
  public java.lang.String getAutoDeclineMode() {
    return autoDeclineMode;
  }

  /**
   * Whether to decline meeting invitations which overlap Focus Time events. Valid values are
   * declineNone, meaning that no meeting invitations are declined;
   * declineAllConflictingInvitations, meaning that all conflicting meeting invitations that
   * conflict with the event are declined; and declineOnlyNewConflictingInvitations, meaning that
   * only new conflicting meeting invitations which arrive while the Focus Time event is present are
   * to be declined.
   * @param autoDeclineMode autoDeclineMode or {@code null} for none
   */
  public EventFocusTimeProperties setAutoDeclineMode(java.lang.String autoDeclineMode) {
    this.autoDeclineMode = autoDeclineMode;
    return this;
  }

  /**
   * The status to mark the user in Chat and related products. This can be available or
   * doNotDisturb.
   * @return value or {@code null} for none
   */
  public java.lang.String getChatStatus() {
    return chatStatus;
  }

  /**
   * The status to mark the user in Chat and related products. This can be available or
   * doNotDisturb.
   * @param chatStatus chatStatus or {@code null} for none
   */
  public EventFocusTimeProperties setChatStatus(java.lang.String chatStatus) {
    this.chatStatus = chatStatus;
    return this;
  }

  /**
   * Response message to set if an existing event or new invitation is automatically declined by
   * Calendar.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeclineMessage() {
    return declineMessage;
  }

  /**
   * Response message to set if an existing event or new invitation is automatically declined by
   * Calendar.
   * @param declineMessage declineMessage or {@code null} for none
   */
  public EventFocusTimeProperties setDeclineMessage(java.lang.String declineMessage) {
    this.declineMessage = declineMessage;
    return this;
  }

  @Override
  public EventFocusTimeProperties set(String fieldName, Object value) {
    return (EventFocusTimeProperties) super.set(fieldName, value);
  }

  @Override
  public EventFocusTimeProperties clone() {
    return (EventFocusTimeProperties) super.clone();
  }

}
