/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-10 at 01:52:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventAttendee.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventAttendee extends com.google.api.client.json.GenericJson {

  /**
   * Number of additional guests. Optional. The default is 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer additionalGuests;

  /**
   * The attendee's response comment. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comment;

  /**
   * The attendee's name, if available. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The attendee's email address, if available. This field must be present when adding an attendee.
   * It must be a valid email address as per RFC5322.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The attendee's Profile ID, if available. It corresponds to theid field in the People collection
   * of the Google+ API
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Whether this is an optional attendee. Optional. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean optional;

  /**
   * Whether the attendee is the organizer of the event. Read-only. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean organizer;

  /**
   * Whether the attendee is a resource. Read-only. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean resource;

  /**
   * The attendee's response status. Possible values are: - "needsAction" - The attendee has not
   * responded to the invitation.  - "declined" - The attendee has declined the invitation.  -
   * "tentative" - The attendee has tentatively accepted the invitation.  - "accepted" - The
   * attendee has accepted the invitation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseStatus;

  /**
   * Whether this entry represents the calendar on which this copy of the event appears. Read-only.
   * The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean self;

  /**
   * Number of additional guests. Optional. The default is 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAdditionalGuests() {
    return additionalGuests;
  }

  /**
   * Number of additional guests. Optional. The default is 0.
   * @param additionalGuests additionalGuests or {@code null} for none
   */
  public EventAttendee setAdditionalGuests(java.lang.Integer additionalGuests) {
    this.additionalGuests = additionalGuests;
    return this;
  }

  /**
   * The attendee's response comment. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getComment() {
    return comment;
  }

  /**
   * The attendee's response comment. Optional.
   * @param comment comment or {@code null} for none
   */
  public EventAttendee setComment(java.lang.String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * The attendee's name, if available. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The attendee's name, if available. Optional.
   * @param displayName displayName or {@code null} for none
   */
  public EventAttendee setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The attendee's email address, if available. This field must be present when adding an attendee.
   * It must be a valid email address as per RFC5322.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The attendee's email address, if available. This field must be present when adding an attendee.
   * It must be a valid email address as per RFC5322.
   * @param email email or {@code null} for none
   */
  public EventAttendee setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The attendee's Profile ID, if available. It corresponds to theid field in the People collection
   * of the Google+ API
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The attendee's Profile ID, if available. It corresponds to theid field in the People collection
   * of the Google+ API
   * @param id id or {@code null} for none
   */
  public EventAttendee setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Whether this is an optional attendee. Optional. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOptional() {
    return optional;
  }

  /**
   * Whether this is an optional attendee. Optional. The default is False.
   * @param optional optional or {@code null} for none
   */
  public EventAttendee setOptional(java.lang.Boolean optional) {
    this.optional = optional;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether this is an optional attendee. Optional. The default is False.
   * </p>
   */
  public boolean isOptional() {
    if (optional == null || optional == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return optional;
  }

  /**
   * Whether the attendee is the organizer of the event. Read-only. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOrganizer() {
    return organizer;
  }

  /**
   * Whether the attendee is the organizer of the event. Read-only. The default is False.
   * @param organizer organizer or {@code null} for none
   */
  public EventAttendee setOrganizer(java.lang.Boolean organizer) {
    this.organizer = organizer;
    return this;
  }

  /**
   * Whether the attendee is a resource. Read-only. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getResource() {
    return resource;
  }

  /**
   * Whether the attendee is a resource. Read-only. The default is False.
   * @param resource resource or {@code null} for none
   */
  public EventAttendee setResource(java.lang.Boolean resource) {
    this.resource = resource;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether the attendee is a resource. Read-only. The default is False.
   * </p>
   */
  public boolean isResource() {
    if (resource == null || resource == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return resource;
  }

  /**
   * The attendee's response status. Possible values are: - "needsAction" - The attendee has not
   * responded to the invitation.  - "declined" - The attendee has declined the invitation.  -
   * "tentative" - The attendee has tentatively accepted the invitation.  - "accepted" - The
   * attendee has accepted the invitation.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseStatus() {
    return responseStatus;
  }

  /**
   * The attendee's response status. Possible values are: - "needsAction" - The attendee has not
   * responded to the invitation.  - "declined" - The attendee has declined the invitation.  -
   * "tentative" - The attendee has tentatively accepted the invitation.  - "accepted" - The
   * attendee has accepted the invitation.
   * @param responseStatus responseStatus or {@code null} for none
   */
  public EventAttendee setResponseStatus(java.lang.String responseStatus) {
    this.responseStatus = responseStatus;
    return this;
  }

  /**
   * Whether this entry represents the calendar on which this copy of the event appears. Read-only.
   * The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSelf() {
    return self;
  }

  /**
   * Whether this entry represents the calendar on which this copy of the event appears. Read-only.
   * The default is False.
   * @param self self or {@code null} for none
   */
  public EventAttendee setSelf(java.lang.Boolean self) {
    this.self = self;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether this entry represents the calendar on which this copy of the event appears. Read-only. The
 default is False.
   * </p>
   */
  public boolean isSelf() {
    if (self == null || self == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return self;
  }

  @Override
  public EventAttendee set(String fieldName, Object value) {
    return (EventAttendee) super.set(fieldName, value);
  }

  @Override
  public EventAttendee clone() {
    return (EventAttendee) super.clone();
  }

}
