/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-19 at 06:21:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for ConferenceSolution.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConferenceSolution extends com.google.api.client.json.GenericJson {

  /**
   * The user-visible icon for this solution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconUri;

  /**
   * The key which can uniquely identify the conference solution for this event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConferenceSolutionKey key;

  /**
   * The user-visible name of this solution. Not localized.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The user-visible icon for this solution.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconUri() {
    return iconUri;
  }

  /**
   * The user-visible icon for this solution.
   * @param iconUri iconUri or {@code null} for none
   */
  public ConferenceSolution setIconUri(java.lang.String iconUri) {
    this.iconUri = iconUri;
    return this;
  }

  /**
   * The key which can uniquely identify the conference solution for this event.
   * @return value or {@code null} for none
   */
  public ConferenceSolutionKey getKey() {
    return key;
  }

  /**
   * The key which can uniquely identify the conference solution for this event.
   * @param key key or {@code null} for none
   */
  public ConferenceSolution setKey(ConferenceSolutionKey key) {
    this.key = key;
    return this;
  }

  /**
   * The user-visible name of this solution. Not localized.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The user-visible name of this solution. Not localized.
   * @param name name or {@code null} for none
   */
  public ConferenceSolution setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public ConferenceSolution set(String fieldName, Object value) {
    return (ConferenceSolution) super.set(fieldName, value);
  }

  @Override
  public ConferenceSolution clone() {
    return (ConferenceSolution) super.clone();
  }

}
