/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-04-22 at 12:29:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1;

/**
 * Service definition for HangoutsChat (v1).
 *
 * <p>
 * Enables bots to fetch information and perform actions in Hangouts Chat.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/hangouts/chat" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link HangoutsChatRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class HangoutsChat extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Hangouts Chat API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://chat.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public HangoutsChat(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  HangoutsChat(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Spaces collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Spaces.List request = chat.spaces().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Spaces spaces() {
    return new Spaces();
  }

  /**
   * The "spaces" collection of methods.
   */
  public class Spaces {

    /**
     * Returns a space.
     *
     * Create a request for the method "spaces.get".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name Required. Resource name of the space, in the form "spaces".
    Example: spaces/AAAAMpdlehY
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Returns a space.
       *
       * Create a request for the method "spaces.get".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. Resource name of the space, in the form "spaces".
    Example: spaces/AAAAMpdlehY
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Space.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Resource name of the space, in the form "spaces".
       *
       * Example: spaces/AAAAMpdlehY
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. Resource name of the space, in the form "spaces".

     Example: spaces/AAAAMpdlehY
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. Resource name of the space, in the form "spaces".
       *
       * Example: spaces/AAAAMpdlehY
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists spaces the caller is a member of.
     *
     * Create a request for the method "spaces.list".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListSpacesResponse> {

      private static final String REST_PATH = "v1/spaces";

      /**
       * Lists spaces the caller is a member of.
       *
       * Create a request for the method "spaces.list".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListSpacesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** A token identifying a page of results the server should return. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A token identifying a page of results the server should return.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** A token identifying a page of results the server should return. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Requested page size. The value is capped at 1000. Server may return fewer results than
       * requested. If unspecified, server will default to 100.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Requested page size. The value is capped at 1000. Server may return fewer results than requested.
     If unspecified, server will default to 100.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Requested page size. The value is capped at 1000. Server may return fewer results than
       * requested. If unspecified, server will default to 100.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Members collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Members.List request = chat.members().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Members members() {
      return new Members();
    }

    /**
     * The "members" collection of methods.
     */
    public class Members {

      /**
       * Returns a membership.
       *
       * Create a request for the method "members.get".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the membership to be retrieved, in the form
      "spaces/members".
      Example:
       *        spaces/AAAAMpdlehY/members/105115627578887013105
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Membership> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/members/[^/]+$");

        /**
         * Returns a membership.
         *
         * Create a request for the method "members.get".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the membership to be retrieved, in the form
      "spaces/members".
      Example:
       *        spaces/AAAAMpdlehY/members/105115627578887013105
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Membership.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the membership to be retrieved, in the form "spaces/members".
         *
         * Example: spaces/AAAAMpdlehY/members/105115627578887013105
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the membership to be retrieved, in the form "spaces/members".

       Example: spaces/AAAAMpdlehY/members/105115627578887013105
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the membership to be retrieved, in the form "spaces/members".
         *
         * Example: spaces/AAAAMpdlehY/members/105115627578887013105
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists human memberships in a space.
       *
       * Create a request for the method "members.list".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the space for which membership list is to be
      fetched, in the form
       *        "spaces".
      Example: spaces/AAAAMpdlehY
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListMembershipsResponse> {

        private static final String REST_PATH = "v1/{+parent}/members";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Lists human memberships in a space.
         *
         * Create a request for the method "members.list".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the space for which membership list is to be
      fetched, in the form
       *        "spaces".
      Example: spaces/AAAAMpdlehY
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListMembershipsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the space for which membership list is to be fetched, in
         * the form "spaces".
         *
         * Example: spaces/AAAAMpdlehY
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the space for which membership list is to be fetched, in the form
       "spaces".

       Example: spaces/AAAAMpdlehY
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the space for which membership list is to be fetched, in
         * the form "spaces".
         *
         * Example: spaces/AAAAMpdlehY
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /** A token identifying a page of results the server should return. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A token identifying a page of results the server should return.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** A token identifying a page of results the server should return. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Requested page size. The value is capped at 1000. Server may return fewer results than
         * requested. If unspecified, server will default to 100.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Requested page size. The value is capped at 1000. Server may return fewer results than requested.
       If unspecified, server will default to 100.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Requested page size. The value is capped at 1000. Server may return fewer results than
         * requested. If unspecified, server will default to 100.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Messages collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Messages.List request = chat.messages().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Messages messages() {
      return new Messages();
    }

    /**
     * The "messages" collection of methods.
     */
    public class Messages {

      /**
       * Creates a message.
       *
       * Create a request for the method "messages.create".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Space resource name, in the form "spaces".
      Example: spaces/AAAAMpdlehY
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+parent}/messages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Creates a message.
         *
         * Create a request for the method "messages.create".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Space resource name, in the form "spaces".
      Example: spaces/AAAAMpdlehY
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Space resource name, in the form "spaces". Example: spaces/AAAAMpdlehY
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAMpdlehY
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. Space resource name, in the form "spaces". Example: spaces/AAAAMpdlehY
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Opaque thread identifier string that can be specified to group messages into a single
         * thread. If this is the first message with a given thread identifier, a new thread is
         * created. Subsequent messages with the same thread identifier will be posted into the same
         * thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID
         * of a thread (created earlier by them) to post further updates to it.
         *
         * Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        @com.google.api.client.util.Key
        private java.lang.String threadKey;

        /** Opaque thread identifier string that can be specified to group messages into a single thread. If
       this is the first message with a given thread identifier, a new thread is created. Subsequent
       messages with the same thread identifier will be posted into the same thread. This relieves bots
       and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them)
       to post further updates to it.

       Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        public java.lang.String getThreadKey() {
          return threadKey;
        }

        /**
         * Opaque thread identifier string that can be specified to group messages into a single
         * thread. If this is the first message with a given thread identifier, a new thread is
         * created. Subsequent messages with the same thread identifier will be posted into the same
         * thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID
         * of a thread (created earlier by them) to post further updates to it.
         *
         * Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        public Create setThreadKey(java.lang.String threadKey) {
          this.threadKey = threadKey;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a message.
       *
       * Create a request for the method "messages.delete".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the message to be deleted, in the form
      "spaces/messages"
      Example:
       *        spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Deletes a message.
         *
         * Create a request for the method "messages.delete".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the message to be deleted, in the form
      "spaces/messages"
      Example:
       *        spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(HangoutsChat.this, "DELETE", REST_PATH, null, com.google.api.services.chat.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the message to be deleted, in the form "spaces/messages"
         *
         * Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the message to be deleted, in the form "spaces/messages"

       Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the message to be deleted, in the form "spaces/messages"
         *
         * Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns a message.
       *
       * Create a request for the method "messages.get".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the message to be retrieved, in the form
      "spaces/messages".
      Example:
       *        spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Returns a message.
         *
         * Create a request for the method "messages.get".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the message to be retrieved, in the form
      "spaces/messages".
      Example:
       *        spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the message to be retrieved, in the form "spaces/messages".
         *
         * Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the message to be retrieved, in the form "spaces/messages".

       Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the message to be retrieved, in the form "spaces/messages".
         *
         * Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Updates a message.
       *
       * Create a request for the method "messages.update".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param name Resource name, in the form "spaces/messages".
      Example:
       *        spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Update update(java.lang.String name, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Update result = new Update(name, content);
        initialize(result);
        return result;
      }

      public class Update extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Updates a message.
         *
         * Create a request for the method "messages.update".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name, in the form "spaces/messages".
      Example:
       *        spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Update(java.lang.String name, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "PUT", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Resource name, in the form "spaces/messages".
         *
         * Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name, in the form "spaces/messages".

       Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Resource name, in the form "spaces/messages".
         *
         * Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        public Update setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The field paths to be updated, comma separated if there are multiple.
         *
         * Currently supported field paths: * text * cards
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The field paths to be updated, comma separated if there are multiple.

       Currently supported field paths: * text * cards
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The field paths to be updated, comma separated if there are multiple.
         *
         * Currently supported field paths: * text * cards
         */
        public Update setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link HangoutsChat}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link HangoutsChat}. */
    @Override
    public HangoutsChat build() {
      return new HangoutsChat(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link HangoutsChatRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setHangoutsChatRequestInitializer(
        HangoutsChatRequestInitializer hangoutschatRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(hangoutschatRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
