/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-04-22 at 12:29:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A button. Can be a text button or an image button.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Hangouts Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Button extends com.google.api.client.json.GenericJson {

  /**
   * A button with image and onclick action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageButton imageButton;

  /**
   * A button with text and onclick action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextButton textButton;

  /**
   * A button with image and onclick action.
   * @return value or {@code null} for none
   */
  public ImageButton getImageButton() {
    return imageButton;
  }

  /**
   * A button with image and onclick action.
   * @param imageButton imageButton or {@code null} for none
   */
  public Button setImageButton(ImageButton imageButton) {
    this.imageButton = imageButton;
    return this;
  }

  /**
   * A button with text and onclick action.
   * @return value or {@code null} for none
   */
  public TextButton getTextButton() {
    return textButton;
  }

  /**
   * A button with text and onclick action.
   * @param textButton textButton or {@code null} for none
   */
  public Button setTextButton(TextButton textButton) {
    this.textButton = textButton;
    return this;
  }

  @Override
  public Button set(String fieldName, Object value) {
    return (Button) super.set(fieldName, value);
  }

  @Override
  public Button clone() {
    return (Button) super.clone();
  }

}
