/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1;

/**
 * Service definition for HangoutsChat (v1).
 *
 * <p>
 * Enables bots to fetch information and perform actions in Google Chat. Authentication using a service account is a prerequisite for using the Google Chat REST API.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/hangouts/chat" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link HangoutsChatRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class HangoutsChat extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Google Chat API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://chat.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://chat.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public HangoutsChat(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  HangoutsChat(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Dms collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Dms.List request = chat.dms().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Dms dms() {
    return new Dms();
  }

  /**
   * The "dms" collection of methods.
   */
  public class Dms {

    /**
     * Legacy path for creating message. Calling these will result in a BadRequest response.
     *
     * Create a request for the method "dms.messages".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Messages#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
     * @param content the {@link com.google.api.services.chat.v1.model.Message}
     * @return the request
     */
    public Messages messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
      Messages result = new Messages(parent, content);
      initialize(result);
      return result;
    }

    public class Messages extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

      private static final String REST_PATH = "v1/{+parent}/messages";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^dms/[^/]+$");

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "dms.messages".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Messages#execute()} method to invoke the remote operation. <p>
       * {@link
       * Messages#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @since 1.13
       */
      protected Messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^dms/[^/]+$");
        }
      }

      @Override
      public Messages set$Xgafv(java.lang.String $Xgafv) {
        return (Messages) super.set$Xgafv($Xgafv);
      }

      @Override
      public Messages setAccessToken(java.lang.String accessToken) {
        return (Messages) super.setAccessToken(accessToken);
      }

      @Override
      public Messages setAlt(java.lang.String alt) {
        return (Messages) super.setAlt(alt);
      }

      @Override
      public Messages setCallback(java.lang.String callback) {
        return (Messages) super.setCallback(callback);
      }

      @Override
      public Messages setFields(java.lang.String fields) {
        return (Messages) super.setFields(fields);
      }

      @Override
      public Messages setKey(java.lang.String key) {
        return (Messages) super.setKey(key);
      }

      @Override
      public Messages setOauthToken(java.lang.String oauthToken) {
        return (Messages) super.setOauthToken(oauthToken);
      }

      @Override
      public Messages setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Messages) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Messages setQuotaUser(java.lang.String quotaUser) {
        return (Messages) super.setQuotaUser(quotaUser);
      }

      @Override
      public Messages setUploadType(java.lang.String uploadType) {
        return (Messages) super.setUploadType(uploadType);
      }

      @Override
      public Messages setUploadProtocol(java.lang.String uploadProtocol) {
        return (Messages) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       */
      public java.lang.String getParent() {
        return parent;
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      public Messages setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^dms/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Optional. A unique request ID for this message. If a message has already been created in the space
     with this request ID, the subsequent request will return the existing message and no new message
     will be created.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      public Messages setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      @com.google.api.client.util.Key
      private java.lang.String threadKey;

      /** Optional. Opaque thread identifier string that can be specified to group messages into a single
     thread. If this is the first message with a given thread identifier, a new thread is created.
     Subsequent messages with the same thread identifier will be posted into the same thread. This
     relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
     earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
     existing thread, is set in message.
       */
      public java.lang.String getThreadKey() {
        return threadKey;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      public Messages setThreadKey(java.lang.String threadKey) {
        this.threadKey = threadKey;
        return this;
      }

      @Override
      public Messages set(String parameterName, Object value) {
        return (Messages) super.set(parameterName, value);
      }
    }
    /**
     * Legacy path for creating message. Calling these will result in a BadRequest response.
     *
     * Create a request for the method "dms.webhooks".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Webhooks#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
     * @param content the {@link com.google.api.services.chat.v1.model.Message}
     * @return the request
     */
    public Webhooks webhooks(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
      Webhooks result = new Webhooks(parent, content);
      initialize(result);
      return result;
    }

    public class Webhooks extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

      private static final String REST_PATH = "v1/{+parent}/webhooks";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^dms/[^/]+$");

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "dms.webhooks".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Webhooks#execute()} method to invoke the remote operation. <p>
       * {@link
       * Webhooks#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @since 1.13
       */
      protected Webhooks(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^dms/[^/]+$");
        }
      }

      @Override
      public Webhooks set$Xgafv(java.lang.String $Xgafv) {
        return (Webhooks) super.set$Xgafv($Xgafv);
      }

      @Override
      public Webhooks setAccessToken(java.lang.String accessToken) {
        return (Webhooks) super.setAccessToken(accessToken);
      }

      @Override
      public Webhooks setAlt(java.lang.String alt) {
        return (Webhooks) super.setAlt(alt);
      }

      @Override
      public Webhooks setCallback(java.lang.String callback) {
        return (Webhooks) super.setCallback(callback);
      }

      @Override
      public Webhooks setFields(java.lang.String fields) {
        return (Webhooks) super.setFields(fields);
      }

      @Override
      public Webhooks setKey(java.lang.String key) {
        return (Webhooks) super.setKey(key);
      }

      @Override
      public Webhooks setOauthToken(java.lang.String oauthToken) {
        return (Webhooks) super.setOauthToken(oauthToken);
      }

      @Override
      public Webhooks setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Webhooks) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Webhooks setQuotaUser(java.lang.String quotaUser) {
        return (Webhooks) super.setQuotaUser(quotaUser);
      }

      @Override
      public Webhooks setUploadType(java.lang.String uploadType) {
        return (Webhooks) super.setUploadType(uploadType);
      }

      @Override
      public Webhooks setUploadProtocol(java.lang.String uploadProtocol) {
        return (Webhooks) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       */
      public java.lang.String getParent() {
        return parent;
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      public Webhooks setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^dms/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Optional. A unique request ID for this message. If a message has already been created in the space
     with this request ID, the subsequent request will return the existing message and no new message
     will be created.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      public Webhooks setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      @com.google.api.client.util.Key
      private java.lang.String threadKey;

      /** Optional. Opaque thread identifier string that can be specified to group messages into a single
     thread. If this is the first message with a given thread identifier, a new thread is created.
     Subsequent messages with the same thread identifier will be posted into the same thread. This
     relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
     earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
     existing thread, is set in message.
       */
      public java.lang.String getThreadKey() {
        return threadKey;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      public Webhooks setThreadKey(java.lang.String threadKey) {
        this.threadKey = threadKey;
        return this;
      }

      @Override
      public Webhooks set(String parameterName, Object value) {
        return (Webhooks) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Conversations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Conversations.List request = chat.conversations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Conversations conversations() {
      return new Conversations();
    }

    /**
     * The "conversations" collection of methods.
     */
    public class Conversations {

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "conversations.messages".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Messages#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Messages messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Messages result = new Messages(parent, content);
        initialize(result);
        return result;
      }

      public class Messages extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+parent}/messages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^dms/[^/]+/conversations/[^/]+$");

        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         *
         * Create a request for the method "conversations.messages".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Messages#execute()} method to invoke the remote operation. <p>
         * {@link
         * Messages#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^dms/[^/]+/conversations/[^/]+$");
          }
        }

        @Override
        public Messages set$Xgafv(java.lang.String $Xgafv) {
          return (Messages) super.set$Xgafv($Xgafv);
        }

        @Override
        public Messages setAccessToken(java.lang.String accessToken) {
          return (Messages) super.setAccessToken(accessToken);
        }

        @Override
        public Messages setAlt(java.lang.String alt) {
          return (Messages) super.setAlt(alt);
        }

        @Override
        public Messages setCallback(java.lang.String callback) {
          return (Messages) super.setCallback(callback);
        }

        @Override
        public Messages setFields(java.lang.String fields) {
          return (Messages) super.setFields(fields);
        }

        @Override
        public Messages setKey(java.lang.String key) {
          return (Messages) super.setKey(key);
        }

        @Override
        public Messages setOauthToken(java.lang.String oauthToken) {
          return (Messages) super.setOauthToken(oauthToken);
        }

        @Override
        public Messages setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Messages) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Messages setQuotaUser(java.lang.String quotaUser) {
          return (Messages) super.setQuotaUser(quotaUser);
        }

        @Override
        public Messages setUploadType(java.lang.String uploadType) {
          return (Messages) super.setUploadType(uploadType);
        }

        @Override
        public Messages setUploadProtocol(java.lang.String uploadProtocol) {
          return (Messages) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
        public Messages setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^dms/[^/]+/conversations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional. A unique request ID for this message. If a message has already been created in
         * the space with this request ID, the subsequent request will return the existing message
         * and no new message will be created.
         */
        @com.google.api.client.util.Key
        private java.lang.String requestId;

        /** Optional. A unique request ID for this message. If a message has already been created in the space
       with this request ID, the subsequent request will return the existing message and no new message
       will be created.
         */
        public java.lang.String getRequestId() {
          return requestId;
        }

        /**
         * Optional. A unique request ID for this message. If a message has already been created in
         * the space with this request ID, the subsequent request will return the existing message
         * and no new message will be created.
         */
        public Messages setRequestId(java.lang.String requestId) {
          this.requestId = requestId;
          return this;
        }

        /**
         * Optional. Opaque thread identifier string that can be specified to group messages into a
         * single thread. If this is the first message with a given thread identifier, a new thread
         * is created. Subsequent messages with the same thread identifier will be posted into the
         * same thread. This relieves bots and webhooks from having to store the Google Chat thread
         * ID of a thread (created earlier by them) to post further updates to it. Has no effect if
         * thread field, corresponding to an existing thread, is set in message.
         */
        @com.google.api.client.util.Key
        private java.lang.String threadKey;

        /** Optional. Opaque thread identifier string that can be specified to group messages into a single
       thread. If this is the first message with a given thread identifier, a new thread is created.
       Subsequent messages with the same thread identifier will be posted into the same thread. This
       relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
       earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
       existing thread, is set in message.
         */
        public java.lang.String getThreadKey() {
          return threadKey;
        }

        /**
         * Optional. Opaque thread identifier string that can be specified to group messages into a
         * single thread. If this is the first message with a given thread identifier, a new thread
         * is created. Subsequent messages with the same thread identifier will be posted into the
         * same thread. This relieves bots and webhooks from having to store the Google Chat thread
         * ID of a thread (created earlier by them) to post further updates to it. Has no effect if
         * thread field, corresponding to an existing thread, is set in message.
         */
        public Messages setThreadKey(java.lang.String threadKey) {
          this.threadKey = threadKey;
          return this;
        }

        @Override
        public Messages set(String parameterName, Object value) {
          return (Messages) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Media collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Media.List request = chat.media().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Media media() {
    return new Media();
  }

  /**
   * The "media" collection of methods.
   */
  public class Media {

    /**
     * Downloads media. Download is supported on the URI `/v1/media/{+name}?alt=media`.
     *
     * Create a request for the method "media.download".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Download#execute()} method to invoke the remote operation.
     *
     * @param resourceName Name of the media that is being downloaded. See ReadRequest.resource_name.
     * @return the request
     */
    public Download download(java.lang.String resourceName) throws java.io.IOException {
      Download result = new Download(resourceName);
      initialize(result);
      return result;
    }

    public class Download extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Media> {

      private static final String REST_PATH = "v1/media/{+resourceName}";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^.*$");

      /**
       * Downloads media. Download is supported on the URI `/v1/media/{+name}?alt=media`.
       *
       * Create a request for the method "media.download".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Download#execute()} method to invoke the remote operation. <p>
       * {@link
       * Download#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceName Name of the media that is being downloaded. See ReadRequest.resource_name.
       * @since 1.13
       */
      protected Download(java.lang.String resourceName) {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Media.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^.*$");
        }
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Download set$Xgafv(java.lang.String $Xgafv) {
        return (Download) super.set$Xgafv($Xgafv);
      }

      @Override
      public Download setAccessToken(java.lang.String accessToken) {
        return (Download) super.setAccessToken(accessToken);
      }

      @Override
      public Download setAlt(java.lang.String alt) {
        return (Download) super.setAlt(alt);
      }

      @Override
      public Download setCallback(java.lang.String callback) {
        return (Download) super.setCallback(callback);
      }

      @Override
      public Download setFields(java.lang.String fields) {
        return (Download) super.setFields(fields);
      }

      @Override
      public Download setKey(java.lang.String key) {
        return (Download) super.setKey(key);
      }

      @Override
      public Download setOauthToken(java.lang.String oauthToken) {
        return (Download) super.setOauthToken(oauthToken);
      }

      @Override
      public Download setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Download) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Download setQuotaUser(java.lang.String quotaUser) {
        return (Download) super.setQuotaUser(quotaUser);
      }

      @Override
      public Download setUploadType(java.lang.String uploadType) {
        return (Download) super.setUploadType(uploadType);
      }

      @Override
      public Download setUploadProtocol(java.lang.String uploadProtocol) {
        return (Download) super.setUploadProtocol(uploadProtocol);
      }

      /** Name of the media that is being downloaded. See ReadRequest.resource_name. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Name of the media that is being downloaded. See ReadRequest.resource_name.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Name of the media that is being downloaded. See ReadRequest.resource_name. */
      public Download setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^.*$");
        }
        this.resourceName = resourceName;
        return this;
      }

      @Override
      public Download set(String parameterName, Object value) {
        return (Download) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Rooms collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Rooms.List request = chat.rooms().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Rooms rooms() {
    return new Rooms();
  }

  /**
   * The "rooms" collection of methods.
   */
  public class Rooms {

    /**
     * Legacy path for creating message. Calling these will result in a BadRequest response.
     *
     * Create a request for the method "rooms.messages".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Messages#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
     * @param content the {@link com.google.api.services.chat.v1.model.Message}
     * @return the request
     */
    public Messages messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
      Messages result = new Messages(parent, content);
      initialize(result);
      return result;
    }

    public class Messages extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

      private static final String REST_PATH = "v1/{+parent}/messages";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^rooms/[^/]+$");

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "rooms.messages".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Messages#execute()} method to invoke the remote operation. <p>
       * {@link
       * Messages#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @since 1.13
       */
      protected Messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^rooms/[^/]+$");
        }
      }

      @Override
      public Messages set$Xgafv(java.lang.String $Xgafv) {
        return (Messages) super.set$Xgafv($Xgafv);
      }

      @Override
      public Messages setAccessToken(java.lang.String accessToken) {
        return (Messages) super.setAccessToken(accessToken);
      }

      @Override
      public Messages setAlt(java.lang.String alt) {
        return (Messages) super.setAlt(alt);
      }

      @Override
      public Messages setCallback(java.lang.String callback) {
        return (Messages) super.setCallback(callback);
      }

      @Override
      public Messages setFields(java.lang.String fields) {
        return (Messages) super.setFields(fields);
      }

      @Override
      public Messages setKey(java.lang.String key) {
        return (Messages) super.setKey(key);
      }

      @Override
      public Messages setOauthToken(java.lang.String oauthToken) {
        return (Messages) super.setOauthToken(oauthToken);
      }

      @Override
      public Messages setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Messages) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Messages setQuotaUser(java.lang.String quotaUser) {
        return (Messages) super.setQuotaUser(quotaUser);
      }

      @Override
      public Messages setUploadType(java.lang.String uploadType) {
        return (Messages) super.setUploadType(uploadType);
      }

      @Override
      public Messages setUploadProtocol(java.lang.String uploadProtocol) {
        return (Messages) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       */
      public java.lang.String getParent() {
        return parent;
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      public Messages setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^rooms/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Optional. A unique request ID for this message. If a message has already been created in the space
     with this request ID, the subsequent request will return the existing message and no new message
     will be created.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      public Messages setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      @com.google.api.client.util.Key
      private java.lang.String threadKey;

      /** Optional. Opaque thread identifier string that can be specified to group messages into a single
     thread. If this is the first message with a given thread identifier, a new thread is created.
     Subsequent messages with the same thread identifier will be posted into the same thread. This
     relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
     earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
     existing thread, is set in message.
       */
      public java.lang.String getThreadKey() {
        return threadKey;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      public Messages setThreadKey(java.lang.String threadKey) {
        this.threadKey = threadKey;
        return this;
      }

      @Override
      public Messages set(String parameterName, Object value) {
        return (Messages) super.set(parameterName, value);
      }
    }
    /**
     * Legacy path for creating message. Calling these will result in a BadRequest response.
     *
     * Create a request for the method "rooms.webhooks".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Webhooks#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
     * @param content the {@link com.google.api.services.chat.v1.model.Message}
     * @return the request
     */
    public Webhooks webhooks(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
      Webhooks result = new Webhooks(parent, content);
      initialize(result);
      return result;
    }

    public class Webhooks extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

      private static final String REST_PATH = "v1/{+parent}/webhooks";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^rooms/[^/]+$");

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "rooms.webhooks".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Webhooks#execute()} method to invoke the remote operation. <p>
       * {@link
       * Webhooks#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @since 1.13
       */
      protected Webhooks(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^rooms/[^/]+$");
        }
      }

      @Override
      public Webhooks set$Xgafv(java.lang.String $Xgafv) {
        return (Webhooks) super.set$Xgafv($Xgafv);
      }

      @Override
      public Webhooks setAccessToken(java.lang.String accessToken) {
        return (Webhooks) super.setAccessToken(accessToken);
      }

      @Override
      public Webhooks setAlt(java.lang.String alt) {
        return (Webhooks) super.setAlt(alt);
      }

      @Override
      public Webhooks setCallback(java.lang.String callback) {
        return (Webhooks) super.setCallback(callback);
      }

      @Override
      public Webhooks setFields(java.lang.String fields) {
        return (Webhooks) super.setFields(fields);
      }

      @Override
      public Webhooks setKey(java.lang.String key) {
        return (Webhooks) super.setKey(key);
      }

      @Override
      public Webhooks setOauthToken(java.lang.String oauthToken) {
        return (Webhooks) super.setOauthToken(oauthToken);
      }

      @Override
      public Webhooks setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Webhooks) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Webhooks setQuotaUser(java.lang.String quotaUser) {
        return (Webhooks) super.setQuotaUser(quotaUser);
      }

      @Override
      public Webhooks setUploadType(java.lang.String uploadType) {
        return (Webhooks) super.setUploadType(uploadType);
      }

      @Override
      public Webhooks setUploadProtocol(java.lang.String uploadProtocol) {
        return (Webhooks) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       */
      public java.lang.String getParent() {
        return parent;
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      public Webhooks setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^rooms/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Optional. A unique request ID for this message. If a message has already been created in the space
     with this request ID, the subsequent request will return the existing message and no new message
     will be created.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      public Webhooks setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      @com.google.api.client.util.Key
      private java.lang.String threadKey;

      /** Optional. Opaque thread identifier string that can be specified to group messages into a single
     thread. If this is the first message with a given thread identifier, a new thread is created.
     Subsequent messages with the same thread identifier will be posted into the same thread. This
     relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
     earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
     existing thread, is set in message.
       */
      public java.lang.String getThreadKey() {
        return threadKey;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      public Webhooks setThreadKey(java.lang.String threadKey) {
        this.threadKey = threadKey;
        return this;
      }

      @Override
      public Webhooks set(String parameterName, Object value) {
        return (Webhooks) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Conversations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Conversations.List request = chat.conversations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Conversations conversations() {
      return new Conversations();
    }

    /**
     * The "conversations" collection of methods.
     */
    public class Conversations {

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "conversations.messages".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Messages#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Messages messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Messages result = new Messages(parent, content);
        initialize(result);
        return result;
      }

      public class Messages extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+parent}/messages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^rooms/[^/]+/conversations/[^/]+$");

        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         *
         * Create a request for the method "conversations.messages".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Messages#execute()} method to invoke the remote operation. <p>
         * {@link
         * Messages#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Messages(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^rooms/[^/]+/conversations/[^/]+$");
          }
        }

        @Override
        public Messages set$Xgafv(java.lang.String $Xgafv) {
          return (Messages) super.set$Xgafv($Xgafv);
        }

        @Override
        public Messages setAccessToken(java.lang.String accessToken) {
          return (Messages) super.setAccessToken(accessToken);
        }

        @Override
        public Messages setAlt(java.lang.String alt) {
          return (Messages) super.setAlt(alt);
        }

        @Override
        public Messages setCallback(java.lang.String callback) {
          return (Messages) super.setCallback(callback);
        }

        @Override
        public Messages setFields(java.lang.String fields) {
          return (Messages) super.setFields(fields);
        }

        @Override
        public Messages setKey(java.lang.String key) {
          return (Messages) super.setKey(key);
        }

        @Override
        public Messages setOauthToken(java.lang.String oauthToken) {
          return (Messages) super.setOauthToken(oauthToken);
        }

        @Override
        public Messages setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Messages) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Messages setQuotaUser(java.lang.String quotaUser) {
          return (Messages) super.setQuotaUser(quotaUser);
        }

        @Override
        public Messages setUploadType(java.lang.String uploadType) {
          return (Messages) super.setUploadType(uploadType);
        }

        @Override
        public Messages setUploadProtocol(java.lang.String uploadProtocol) {
          return (Messages) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
        public Messages setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^rooms/[^/]+/conversations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional. A unique request ID for this message. If a message has already been created in
         * the space with this request ID, the subsequent request will return the existing message
         * and no new message will be created.
         */
        @com.google.api.client.util.Key
        private java.lang.String requestId;

        /** Optional. A unique request ID for this message. If a message has already been created in the space
       with this request ID, the subsequent request will return the existing message and no new message
       will be created.
         */
        public java.lang.String getRequestId() {
          return requestId;
        }

        /**
         * Optional. A unique request ID for this message. If a message has already been created in
         * the space with this request ID, the subsequent request will return the existing message
         * and no new message will be created.
         */
        public Messages setRequestId(java.lang.String requestId) {
          this.requestId = requestId;
          return this;
        }

        /**
         * Optional. Opaque thread identifier string that can be specified to group messages into a
         * single thread. If this is the first message with a given thread identifier, a new thread
         * is created. Subsequent messages with the same thread identifier will be posted into the
         * same thread. This relieves bots and webhooks from having to store the Google Chat thread
         * ID of a thread (created earlier by them) to post further updates to it. Has no effect if
         * thread field, corresponding to an existing thread, is set in message.
         */
        @com.google.api.client.util.Key
        private java.lang.String threadKey;

        /** Optional. Opaque thread identifier string that can be specified to group messages into a single
       thread. If this is the first message with a given thread identifier, a new thread is created.
       Subsequent messages with the same thread identifier will be posted into the same thread. This
       relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
       earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
       existing thread, is set in message.
         */
        public java.lang.String getThreadKey() {
          return threadKey;
        }

        /**
         * Optional. Opaque thread identifier string that can be specified to group messages into a
         * single thread. If this is the first message with a given thread identifier, a new thread
         * is created. Subsequent messages with the same thread identifier will be posted into the
         * same thread. This relieves bots and webhooks from having to store the Google Chat thread
         * ID of a thread (created earlier by them) to post further updates to it. Has no effect if
         * thread field, corresponding to an existing thread, is set in message.
         */
        public Messages setThreadKey(java.lang.String threadKey) {
          this.threadKey = threadKey;
          return this;
        }

        @Override
        public Messages set(String parameterName, Object value) {
          return (Messages) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Spaces collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Spaces.List request = chat.spaces().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Spaces spaces() {
    return new Spaces();
  }

  /**
   * The "spaces" collection of methods.
   */
  public class Spaces {

    /**
     * Returns a space.
     *
     * Create a request for the method "spaces.get".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name Required. Resource name of the space, in the form "spaces". Example: spaces/AAAAAAAAAAAA
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Returns a space.
       *
       * Create a request for the method "spaces.get".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. Resource name of the space, in the form "spaces". Example: spaces/AAAAAAAAAAAA
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Space.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Resource name of the space, in the form "spaces". Example: spaces/AAAAAAAAAAAA
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. Resource name of the space, in the form "spaces". Example: spaces/AAAAAAAAAAAA
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. Resource name of the space, in the form "spaces". Example: spaces/AAAAAAAAAAAA
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists spaces the caller is a member of.
     *
     * Create a request for the method "spaces.list".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListSpacesResponse> {

      private static final String REST_PATH = "v1/spaces";

      /**
       * Lists spaces the caller is a member of.
       *
       * Create a request for the method "spaces.list".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListSpacesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Requested page size. The value is capped at 1000. Server may return fewer results than
       * requested. If unspecified, server will default to 100.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Requested page size. The value is capped at 1000. Server may return fewer results than requested.
     If unspecified, server will default to 100.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Requested page size. The value is capped at 1000. Server may return fewer results than
       * requested. If unspecified, server will default to 100.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** A token identifying a page of results the server should return. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A token identifying a page of results the server should return.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** A token identifying a page of results the server should return. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Legacy path for creating message. Calling these will result in a BadRequest response.
     *
     * Create a request for the method "spaces.webhooks".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Webhooks#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
     * @param content the {@link com.google.api.services.chat.v1.model.Message}
     * @return the request
     */
    public Webhooks webhooks(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
      Webhooks result = new Webhooks(parent, content);
      initialize(result);
      return result;
    }

    public class Webhooks extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

      private static final String REST_PATH = "v1/{+parent}/webhooks";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Legacy path for creating message. Calling these will result in a BadRequest response.
       *
       * Create a request for the method "spaces.webhooks".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Webhooks#execute()} method to invoke the remote operation. <p>
       * {@link
       * Webhooks#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @since 1.13
       */
      protected Webhooks(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      @Override
      public Webhooks set$Xgafv(java.lang.String $Xgafv) {
        return (Webhooks) super.set$Xgafv($Xgafv);
      }

      @Override
      public Webhooks setAccessToken(java.lang.String accessToken) {
        return (Webhooks) super.setAccessToken(accessToken);
      }

      @Override
      public Webhooks setAlt(java.lang.String alt) {
        return (Webhooks) super.setAlt(alt);
      }

      @Override
      public Webhooks setCallback(java.lang.String callback) {
        return (Webhooks) super.setCallback(callback);
      }

      @Override
      public Webhooks setFields(java.lang.String fields) {
        return (Webhooks) super.setFields(fields);
      }

      @Override
      public Webhooks setKey(java.lang.String key) {
        return (Webhooks) super.setKey(key);
      }

      @Override
      public Webhooks setOauthToken(java.lang.String oauthToken) {
        return (Webhooks) super.setOauthToken(oauthToken);
      }

      @Override
      public Webhooks setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Webhooks) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Webhooks setQuotaUser(java.lang.String quotaUser) {
        return (Webhooks) super.setQuotaUser(quotaUser);
      }

      @Override
      public Webhooks setUploadType(java.lang.String uploadType) {
        return (Webhooks) super.setUploadType(uploadType);
      }

      @Override
      public Webhooks setUploadProtocol(java.lang.String uploadProtocol) {
        return (Webhooks) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       */
      public java.lang.String getParent() {
        return parent;
      }

      /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
      public Webhooks setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Optional. A unique request ID for this message. If a message has already been created in the space
     with this request ID, the subsequent request will return the existing message and no new message
     will be created.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Optional. A unique request ID for this message. If a message has already been created in
       * the space with this request ID, the subsequent request will return the existing message and
       * no new message will be created.
       */
      public Webhooks setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      @com.google.api.client.util.Key
      private java.lang.String threadKey;

      /** Optional. Opaque thread identifier string that can be specified to group messages into a single
     thread. If this is the first message with a given thread identifier, a new thread is created.
     Subsequent messages with the same thread identifier will be posted into the same thread. This
     relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
     earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
     existing thread, is set in message.
       */
      public java.lang.String getThreadKey() {
        return threadKey;
      }

      /**
       * Optional. Opaque thread identifier string that can be specified to group messages into a
       * single thread. If this is the first message with a given thread identifier, a new thread is
       * created. Subsequent messages with the same thread identifier will be posted into the same
       * thread. This relieves bots and webhooks from having to store the Google Chat thread ID of a
       * thread (created earlier by them) to post further updates to it. Has no effect if thread
       * field, corresponding to an existing thread, is set in message.
       */
      public Webhooks setThreadKey(java.lang.String threadKey) {
        this.threadKey = threadKey;
        return this;
      }

      @Override
      public Webhooks set(String parameterName, Object value) {
        return (Webhooks) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Members collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Members.List request = chat.members().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Members members() {
      return new Members();
    }

    /**
     * The "members" collection of methods.
     */
    public class Members {

      /**
       * Returns a membership.
       *
       * Create a request for the method "members.get".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the membership to be retrieved, in the form "spaces/members". Example:
       *        spaces/AAAAAAAAAAAA/members/111111111111111111111
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Membership> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/members/[^/]+$");

        /**
         * Returns a membership.
         *
         * Create a request for the method "members.get".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the membership to be retrieved, in the form "spaces/members". Example:
       *        spaces/AAAAAAAAAAAA/members/111111111111111111111
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Membership.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the membership to be retrieved, in the form "spaces/members".
         * Example: spaces/AAAAAAAAAAAA/members/111111111111111111111
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the membership to be retrieved, in the form "spaces/members". Example:
       spaces/AAAAAAAAAAAA/members/111111111111111111111
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the membership to be retrieved, in the form "spaces/members".
         * Example: spaces/AAAAAAAAAAAA/members/111111111111111111111
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists human memberships in a space.
       *
       * Create a request for the method "members.list".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the space for which membership list is to be fetched, in the form
       *        "spaces". Example: spaces/AAAAAAAAAAAA
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListMembershipsResponse> {

        private static final String REST_PATH = "v1/{+parent}/members";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Lists human memberships in a space.
         *
         * Create a request for the method "members.list".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the space for which membership list is to be fetched, in the form
       *        "spaces". Example: spaces/AAAAAAAAAAAA
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListMembershipsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the space for which membership list is to be fetched, in
         * the form "spaces". Example: spaces/AAAAAAAAAAAA
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the space for which membership list is to be fetched, in the form
       "spaces". Example: spaces/AAAAAAAAAAAA
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the space for which membership list is to be fetched, in
         * the form "spaces". Example: spaces/AAAAAAAAAAAA
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Requested page size. The value is capped at 1000. Server may return fewer results than
         * requested. If unspecified, server will default to 100.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Requested page size. The value is capped at 1000. Server may return fewer results than requested.
       If unspecified, server will default to 100.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Requested page size. The value is capped at 1000. Server may return fewer results than
         * requested. If unspecified, server will default to 100.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** A token identifying a page of results the server should return. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A token identifying a page of results the server should return.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** A token identifying a page of results the server should return. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Messages collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Messages.List request = chat.messages().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Messages messages() {
      return new Messages();
    }

    /**
     * The "messages" collection of methods.
     */
    public class Messages {

      /**
       * Creates a message.
       *
       * Create a request for the method "messages.create".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+parent}/messages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Creates a message.
         *
         * Create a request for the method "messages.create".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Space resource name, in the form "spaces". Example: spaces/AAAAAAAAAAA */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional. A unique request ID for this message. If a message has already been created in
         * the space with this request ID, the subsequent request will return the existing message
         * and no new message will be created.
         */
        @com.google.api.client.util.Key
        private java.lang.String requestId;

        /** Optional. A unique request ID for this message. If a message has already been created in the space
       with this request ID, the subsequent request will return the existing message and no new message
       will be created.
         */
        public java.lang.String getRequestId() {
          return requestId;
        }

        /**
         * Optional. A unique request ID for this message. If a message has already been created in
         * the space with this request ID, the subsequent request will return the existing message
         * and no new message will be created.
         */
        public Create setRequestId(java.lang.String requestId) {
          this.requestId = requestId;
          return this;
        }

        /**
         * Optional. Opaque thread identifier string that can be specified to group messages into a
         * single thread. If this is the first message with a given thread identifier, a new thread
         * is created. Subsequent messages with the same thread identifier will be posted into the
         * same thread. This relieves bots and webhooks from having to store the Google Chat thread
         * ID of a thread (created earlier by them) to post further updates to it. Has no effect if
         * thread field, corresponding to an existing thread, is set in message.
         */
        @com.google.api.client.util.Key
        private java.lang.String threadKey;

        /** Optional. Opaque thread identifier string that can be specified to group messages into a single
       thread. If this is the first message with a given thread identifier, a new thread is created.
       Subsequent messages with the same thread identifier will be posted into the same thread. This
       relieves bots and webhooks from having to store the Google Chat thread ID of a thread (created
       earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an
       existing thread, is set in message.
         */
        public java.lang.String getThreadKey() {
          return threadKey;
        }

        /**
         * Optional. Opaque thread identifier string that can be specified to group messages into a
         * single thread. If this is the first message with a given thread identifier, a new thread
         * is created. Subsequent messages with the same thread identifier will be posted into the
         * same thread. This relieves bots and webhooks from having to store the Google Chat thread
         * ID of a thread (created earlier by them) to post further updates to it. Has no effect if
         * thread field, corresponding to an existing thread, is set in message.
         */
        public Create setThreadKey(java.lang.String threadKey) {
          this.threadKey = threadKey;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a message.
       *
       * Create a request for the method "messages.delete".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the message to be deleted, in the form "spaces/messages" Example:
       *        spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Deletes a message.
         *
         * Create a request for the method "messages.delete".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the message to be deleted, in the form "spaces/messages" Example:
       *        spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(HangoutsChat.this, "DELETE", REST_PATH, null, com.google.api.services.chat.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the message to be deleted, in the form "spaces/messages"
         * Example: spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the message to be deleted, in the form "spaces/messages" Example:
       spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the message to be deleted, in the form "spaces/messages"
         * Example: spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns a message.
       *
       * Create a request for the method "messages.get".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the message to be retrieved, in the form "spaces/messages". Example:
       *        spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Returns a message.
         *
         * Create a request for the method "messages.get".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the message to be retrieved, in the form "spaces/messages". Example:
       *        spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the message to be retrieved, in the form "spaces/messages".
         * Example: spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the message to be retrieved, in the form "spaces/messages". Example:
       spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the message to be retrieved, in the form "spaces/messages".
         * Example: spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Updates a message.
       *
       * Create a request for the method "messages.update".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param name Resource name in the form `spaces/messages`. Example:
       *        `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Update update(java.lang.String name, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Update result = new Update(name, content);
        initialize(result);
        return result;
      }

      public class Update extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Updates a message.
         *
         * Create a request for the method "messages.update".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name in the form `spaces/messages`. Example:
       *        `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Update(java.lang.String name, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "PUT", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Resource name in the form `spaces/messages`. Example:
         * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name in the form `spaces/messages`. Example:
       `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Resource name in the form `spaces/messages`. Example:
         * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public Update setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The field paths to be updated, comma separated if there are multiple. Currently
         * supported field paths: * text * cards * gsuite_message_integration_render_data *
         * attachment
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The field paths to be updated, comma separated if there are multiple. Currently supported
       field paths: * text * cards * gsuite_message_integration_render_data * attachment
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The field paths to be updated, comma separated if there are multiple. Currently
         * supported field paths: * text * cards * gsuite_message_integration_render_data *
         * attachment
         */
        public Update setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Attachments collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code HangoutsChat chat = new HangoutsChat(...);}
       *   {@code HangoutsChat.Attachments.List request = chat.attachments().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Attachments attachments() {
        return new Attachments();
      }

      /**
       * The "attachments" collection of methods.
       */
      public class Attachments {

        /**
         * Gets the metadata of a message attachment. The attachment data is fetched using the media API.
         *
         * Create a request for the method "attachments.get".
         *
         * This request holds the parameters needed by the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Resource name of the attachment, in the form "spaces/messages/attachments".
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Attachment> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");

          /**
           * Gets the metadata of a message attachment. The attachment data is fetched using the media API.
           *
           * Create a request for the method "attachments.get".
           *
           * This request holds the parameters needed by the the chat server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Resource name of the attachment, in the form "spaces/messages/attachments".
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Attachment.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Resource name of the attachment, in the form "spaces/messages/attachments". */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Resource name of the attachment, in the form "spaces/messages/attachments".
           */
          public java.lang.String getName() {
            return name;
          }

          /** Resource name of the attachment, in the form "spaces/messages/attachments". */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link HangoutsChat}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link HangoutsChat}. */
    @Override
    public HangoutsChat build() {
      return new HangoutsChat(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link HangoutsChatRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setHangoutsChatRequestInitializer(
        HangoutsChatRequestInitializer hangoutschatRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(hangoutschatRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
