/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * ActionStatus represents status of a request from the bot developer's side. In specific, for each
 * request a bot gets, the bot developer will set both fields below in relation to what the response
 * status and message related to status should be.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActionStatus extends com.google.api.client.json.GenericJson {

  /**
   * The status code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusCode;

  /**
   * This message will be the corresponding string to the above status_code. If unset, an
   * appropriate generic message based on the status_code will be shown to the user. If this field
   * is set then the message will be surfaced to the user for both successes and errors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userFacingMessage;

  /**
   * The status code.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusCode() {
    return statusCode;
  }

  /**
   * The status code.
   * @param statusCode statusCode or {@code null} for none
   */
  public ActionStatus setStatusCode(java.lang.String statusCode) {
    this.statusCode = statusCode;
    return this;
  }

  /**
   * This message will be the corresponding string to the above status_code. If unset, an
   * appropriate generic message based on the status_code will be shown to the user. If this field
   * is set then the message will be surfaced to the user for both successes and errors.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserFacingMessage() {
    return userFacingMessage;
  }

  /**
   * This message will be the corresponding string to the above status_code. If unset, an
   * appropriate generic message based on the status_code will be shown to the user. If this field
   * is set then the message will be surfaced to the user for both successes and errors.
   * @param userFacingMessage userFacingMessage or {@code null} for none
   */
  public ActionStatus setUserFacingMessage(java.lang.String userFacingMessage) {
    this.userFacingMessage = userFacingMessage;
    return this;
  }

  @Override
  public ActionStatus set(String fieldName, Object value) {
    return (ActionStatus) super.set(fieldName, value);
  }

  @Override
  public ActionStatus clone() {
    return (ActionStatus) super.clone();
  }

}
