/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Wrapper around the card body of the dialog.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Dialog extends com.google.api.client.json.GenericJson {

  /**
   * Body of the dialog, which will be rendered in a modal. NOTE: The following fields within the
   * objects are not supported: google.apps.card.v1.Widget.date_time_picker
   * google.apps.card.v1.DecoratedText.SwitchControl.on_change_action
   * google.apps.card.v1.TextInput.on_change_action
   * google.apps.card.v1.SelectionInput.on_change_action
   * google.apps.card.v1.DateTimePicker.on_change_action Setting the fields above will have no
   * effect on the dialog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Card body;

  /**
   * Body of the dialog, which will be rendered in a modal. NOTE: The following fields within the
   * objects are not supported: google.apps.card.v1.Widget.date_time_picker
   * google.apps.card.v1.DecoratedText.SwitchControl.on_change_action
   * google.apps.card.v1.TextInput.on_change_action
   * google.apps.card.v1.SelectionInput.on_change_action
   * google.apps.card.v1.DateTimePicker.on_change_action Setting the fields above will have no
   * effect on the dialog.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Card getBody() {
    return body;
  }

  /**
   * Body of the dialog, which will be rendered in a modal. NOTE: The following fields within the
   * objects are not supported: google.apps.card.v1.Widget.date_time_picker
   * google.apps.card.v1.DecoratedText.SwitchControl.on_change_action
   * google.apps.card.v1.TextInput.on_change_action
   * google.apps.card.v1.SelectionInput.on_change_action
   * google.apps.card.v1.DateTimePicker.on_change_action Setting the fields above will have no
   * effect on the dialog.
   * @param body body or {@code null} for none
   */
  public Dialog setBody(GoogleAppsCardV1Card body) {
    this.body = body;
    return this;
  }

  @Override
  public Dialog set(String fieldName, Object value) {
    return (Dialog) super.set(fieldName, value);
  }

  @Override
  public Dialog clone() {
    return (Dialog) super.clone();
  }

}
