/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * JSON payload of error messages. If the Cloud Logging API is enabled, these error messages are
 * logged to [Google Cloud Logging](https://cloud.google.com/logging/docs).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamiteIntegrationLogEntry extends com.google.api.client.json.GenericJson {

  /**
   * The deployment that caused the error. For Chat bots built in Apps Script, this is the
   * deployment ID defined by Apps Script.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deployment;

  /**
   * The unencrypted `callback_method` name that was running when the error was encountered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deploymentFunction;

  /**
   * The error code and message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Status error;

  /**
   * The deployment that caused the error. For Chat bots built in Apps Script, this is the
   * deployment ID defined by Apps Script.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeployment() {
    return deployment;
  }

  /**
   * The deployment that caused the error. For Chat bots built in Apps Script, this is the
   * deployment ID defined by Apps Script.
   * @param deployment deployment or {@code null} for none
   */
  public DynamiteIntegrationLogEntry setDeployment(java.lang.String deployment) {
    this.deployment = deployment;
    return this;
  }

  /**
   * The unencrypted `callback_method` name that was running when the error was encountered.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeploymentFunction() {
    return deploymentFunction;
  }

  /**
   * The unencrypted `callback_method` name that was running when the error was encountered.
   * @param deploymentFunction deploymentFunction or {@code null} for none
   */
  public DynamiteIntegrationLogEntry setDeploymentFunction(java.lang.String deploymentFunction) {
    this.deploymentFunction = deploymentFunction;
    return this;
  }

  /**
   * The error code and message.
   * @return value or {@code null} for none
   */
  public Status getError() {
    return error;
  }

  /**
   * The error code and message.
   * @param error error or {@code null} for none
   */
  public DynamiteIntegrationLogEntry setError(Status error) {
    this.error = error;
    return this;
  }

  @Override
  public DynamiteIntegrationLogEntry set(String fieldName, Object value) {
    return (DynamiteIntegrationLogEntry) super.set(fieldName, value);
  }

  @Override
  public DynamiteIntegrationLogEntry clone() {
    return (DynamiteIntegrationLogEntry) super.clone();
  }

}
