/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A button. Can be a text button or an image button.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Button extends com.google.api.client.json.GenericJson {

  /**
   * The alternative text used for accessibility. Has no effect when an icon is set; use
   * `icon.alt_text` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String altText;

  /**
   * If set, the button is filled with a solid background.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color color;

  /**
   * If true, the button is displayed in a disabled state and doesn't respond to user actions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * The icon image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Icon icon;

  /**
   * The action to perform when the button is clicked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1OnClick onClick;

  /**
   * The text of the button.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * The alternative text used for accessibility. Has no effect when an icon is set; use
   * `icon.alt_text` instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getAltText() {
    return altText;
  }

  /**
   * The alternative text used for accessibility. Has no effect when an icon is set; use
   * `icon.alt_text` instead.
   * @param altText altText or {@code null} for none
   */
  public GoogleAppsCardV1Button setAltText(java.lang.String altText) {
    this.altText = altText;
    return this;
  }

  /**
   * If set, the button is filled with a solid background.
   * @return value or {@code null} for none
   */
  public Color getColor() {
    return color;
  }

  /**
   * If set, the button is filled with a solid background.
   * @param color color or {@code null} for none
   */
  public GoogleAppsCardV1Button setColor(Color color) {
    this.color = color;
    return this;
  }

  /**
   * If true, the button is displayed in a disabled state and doesn't respond to user actions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * If true, the button is displayed in a disabled state and doesn't respond to user actions.
   * @param disabled disabled or {@code null} for none
   */
  public GoogleAppsCardV1Button setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * The icon image.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Icon getIcon() {
    return icon;
  }

  /**
   * The icon image.
   * @param icon icon or {@code null} for none
   */
  public GoogleAppsCardV1Button setIcon(GoogleAppsCardV1Icon icon) {
    this.icon = icon;
    return this;
  }

  /**
   * The action to perform when the button is clicked.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1OnClick getOnClick() {
    return onClick;
  }

  /**
   * The action to perform when the button is clicked.
   * @param onClick onClick or {@code null} for none
   */
  public GoogleAppsCardV1Button setOnClick(GoogleAppsCardV1OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  /**
   * The text of the button.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The text of the button.
   * @param text text or {@code null} for none
   */
  public GoogleAppsCardV1Button setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public GoogleAppsCardV1Button set(String fieldName, Object value) {
    return (GoogleAppsCardV1Button) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Button clone() {
    return (GoogleAppsCardV1Button) super.clone();
  }

}
