/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A card action is the action associated with the card. For example, an invoice card might include
 * actions such as delete invoice, email invoice, or open the invoice in a browser.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1CardAction extends com.google.api.client.json.GenericJson {

  /**
   * The label that displays as the action menu item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actionLabel;

  /**
   * The onclick action for this action item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1OnClick onClick;

  /**
   * The label that displays as the action menu item.
   * @return value or {@code null} for none
   */
  public java.lang.String getActionLabel() {
    return actionLabel;
  }

  /**
   * The label that displays as the action menu item.
   * @param actionLabel actionLabel or {@code null} for none
   */
  public GoogleAppsCardV1CardAction setActionLabel(java.lang.String actionLabel) {
    this.actionLabel = actionLabel;
    return this;
  }

  /**
   * The onclick action for this action item.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1OnClick getOnClick() {
    return onClick;
  }

  /**
   * The onclick action for this action item.
   * @param onClick onClick or {@code null} for none
   */
  public GoogleAppsCardV1CardAction setOnClick(GoogleAppsCardV1OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  @Override
  public GoogleAppsCardV1CardAction set(String fieldName, Object value) {
    return (GoogleAppsCardV1CardAction) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1CardAction clone() {
    return (GoogleAppsCardV1CardAction) super.clone();
  }

}
