/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A widget that displays text with optional decorations such as a label above or below the text, an
 * icon in front of the text, a selection widget or a button after the text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1DecoratedText extends com.google.api.client.json.GenericJson {

  /**
   * The formatted text label that shows below the main text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bottomLabel;

  /**
   * A button that can be clicked to trigger an action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Button button;

  /**
   * An icon displayed after the text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Icon endIcon;

  /**
   * Deprecated in favor of start_icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Icon icon;

  /**
   * Only the top and bottom label and content region are clickable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1OnClick onClick;

  /**
   * The icon displayed in front of the text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Icon startIcon;

  /**
   * A switch widget can be clicked to change its state or trigger an action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1SwitchControl switchControl;

  /**
   * Required. The main widget formatted text. See Text formatting for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * The formatted text label that shows above the main text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topLabel;

  /**
   * The wrap text setting. If `true`, the text is wrapped and displayed in multiline. Otherwise,
   * the text is truncated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean wrapText;

  /**
   * The formatted text label that shows below the main text.
   * @return value or {@code null} for none
   */
  public java.lang.String getBottomLabel() {
    return bottomLabel;
  }

  /**
   * The formatted text label that shows below the main text.
   * @param bottomLabel bottomLabel or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setBottomLabel(java.lang.String bottomLabel) {
    this.bottomLabel = bottomLabel;
    return this;
  }

  /**
   * A button that can be clicked to trigger an action.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Button getButton() {
    return button;
  }

  /**
   * A button that can be clicked to trigger an action.
   * @param button button or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setButton(GoogleAppsCardV1Button button) {
    this.button = button;
    return this;
  }

  /**
   * An icon displayed after the text.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Icon getEndIcon() {
    return endIcon;
  }

  /**
   * An icon displayed after the text.
   * @param endIcon endIcon or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setEndIcon(GoogleAppsCardV1Icon endIcon) {
    this.endIcon = endIcon;
    return this;
  }

  /**
   * Deprecated in favor of start_icon.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Icon getIcon() {
    return icon;
  }

  /**
   * Deprecated in favor of start_icon.
   * @param icon icon or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setIcon(GoogleAppsCardV1Icon icon) {
    this.icon = icon;
    return this;
  }

  /**
   * Only the top and bottom label and content region are clickable.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1OnClick getOnClick() {
    return onClick;
  }

  /**
   * Only the top and bottom label and content region are clickable.
   * @param onClick onClick or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setOnClick(GoogleAppsCardV1OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  /**
   * The icon displayed in front of the text.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Icon getStartIcon() {
    return startIcon;
  }

  /**
   * The icon displayed in front of the text.
   * @param startIcon startIcon or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setStartIcon(GoogleAppsCardV1Icon startIcon) {
    this.startIcon = startIcon;
    return this;
  }

  /**
   * A switch widget can be clicked to change its state or trigger an action.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1SwitchControl getSwitchControl() {
    return switchControl;
  }

  /**
   * A switch widget can be clicked to change its state or trigger an action.
   * @param switchControl switchControl or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setSwitchControl(GoogleAppsCardV1SwitchControl switchControl) {
    this.switchControl = switchControl;
    return this;
  }

  /**
   * Required. The main widget formatted text. See Text formatting for details.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * Required. The main widget formatted text. See Text formatting for details.
   * @param text text or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  /**
   * The formatted text label that shows above the main text.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopLabel() {
    return topLabel;
  }

  /**
   * The formatted text label that shows above the main text.
   * @param topLabel topLabel or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setTopLabel(java.lang.String topLabel) {
    this.topLabel = topLabel;
    return this;
  }

  /**
   * The wrap text setting. If `true`, the text is wrapped and displayed in multiline. Otherwise,
   * the text is truncated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWrapText() {
    return wrapText;
  }

  /**
   * The wrap text setting. If `true`, the text is wrapped and displayed in multiline. Otherwise,
   * the text is truncated.
   * @param wrapText wrapText or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText setWrapText(java.lang.Boolean wrapText) {
    this.wrapText = wrapText;
    return this;
  }

  @Override
  public GoogleAppsCardV1DecoratedText set(String fieldName, Object value) {
    return (GoogleAppsCardV1DecoratedText) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1DecoratedText clone() {
    return (GoogleAppsCardV1DecoratedText) super.clone();
  }

}
