/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Represents a Grid widget that displays items in a configurable grid layout.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Grid extends com.google.api.client.json.GenericJson {

  /**
   * The border style to apply to each grid item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1BorderStyle borderStyle;

  /**
   * The number of columns to display in the grid. A default value is used if this field isn't
   * specified, and that default value is different depending on where the grid is shown (dialog
   * versus companion).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer columnCount;

  /**
   * The items to display in the grid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1GridItem> items;

  /**
   * This callback is reused by each individual grid item, but with the item's identifier and index
   * in the items list added to the callback's parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1OnClick onClick;

  /**
   * The text that displays in the grid header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The border style to apply to each grid item.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1BorderStyle getBorderStyle() {
    return borderStyle;
  }

  /**
   * The border style to apply to each grid item.
   * @param borderStyle borderStyle or {@code null} for none
   */
  public GoogleAppsCardV1Grid setBorderStyle(GoogleAppsCardV1BorderStyle borderStyle) {
    this.borderStyle = borderStyle;
    return this;
  }

  /**
   * The number of columns to display in the grid. A default value is used if this field isn't
   * specified, and that default value is different depending on where the grid is shown (dialog
   * versus companion).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getColumnCount() {
    return columnCount;
  }

  /**
   * The number of columns to display in the grid. A default value is used if this field isn't
   * specified, and that default value is different depending on where the grid is shown (dialog
   * versus companion).
   * @param columnCount columnCount or {@code null} for none
   */
  public GoogleAppsCardV1Grid setColumnCount(java.lang.Integer columnCount) {
    this.columnCount = columnCount;
    return this;
  }

  /**
   * The items to display in the grid.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1GridItem> getItems() {
    return items;
  }

  /**
   * The items to display in the grid.
   * @param items items or {@code null} for none
   */
  public GoogleAppsCardV1Grid setItems(java.util.List<GoogleAppsCardV1GridItem> items) {
    this.items = items;
    return this;
  }

  /**
   * This callback is reused by each individual grid item, but with the item's identifier and index
   * in the items list added to the callback's parameters.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1OnClick getOnClick() {
    return onClick;
  }

  /**
   * This callback is reused by each individual grid item, but with the item's identifier and index
   * in the items list added to the callback's parameters.
   * @param onClick onClick or {@code null} for none
   */
  public GoogleAppsCardV1Grid setOnClick(GoogleAppsCardV1OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  /**
   * The text that displays in the grid header.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The text that displays in the grid header.
   * @param title title or {@code null} for none
   */
  public GoogleAppsCardV1Grid setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public GoogleAppsCardV1Grid set(String fieldName, Object value) {
    return (GoogleAppsCardV1Grid) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Grid clone() {
    return (GoogleAppsCardV1Grid) super.clone();
  }

}
