/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Model definition for GoogleAppsCardV1Icon.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Icon extends com.google.api.client.json.GenericJson {

  /**
   * The description of the icon, used for accessibility. The default value is provided if you don't
   * specify one.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String altText;

  /**
   * The icon specified by a URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconUrl;

  /**
   * The crop style applied to the image. In some cases, applying a `CIRCLE` crop causes the image
   * to be drawn larger than a standard icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageType;

  /**
   * The icon specified by the string name of a list of known icons
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String knownIcon;

  /**
   * The description of the icon, used for accessibility. The default value is provided if you don't
   * specify one.
   * @return value or {@code null} for none
   */
  public java.lang.String getAltText() {
    return altText;
  }

  /**
   * The description of the icon, used for accessibility. The default value is provided if you don't
   * specify one.
   * @param altText altText or {@code null} for none
   */
  public GoogleAppsCardV1Icon setAltText(java.lang.String altText) {
    this.altText = altText;
    return this;
  }

  /**
   * The icon specified by a URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconUrl() {
    return iconUrl;
  }

  /**
   * The icon specified by a URL.
   * @param iconUrl iconUrl or {@code null} for none
   */
  public GoogleAppsCardV1Icon setIconUrl(java.lang.String iconUrl) {
    this.iconUrl = iconUrl;
    return this;
  }

  /**
   * The crop style applied to the image. In some cases, applying a `CIRCLE` crop causes the image
   * to be drawn larger than a standard icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageType() {
    return imageType;
  }

  /**
   * The crop style applied to the image. In some cases, applying a `CIRCLE` crop causes the image
   * to be drawn larger than a standard icon.
   * @param imageType imageType or {@code null} for none
   */
  public GoogleAppsCardV1Icon setImageType(java.lang.String imageType) {
    this.imageType = imageType;
    return this;
  }

  /**
   * The icon specified by the string name of a list of known icons
   * @return value or {@code null} for none
   */
  public java.lang.String getKnownIcon() {
    return knownIcon;
  }

  /**
   * The icon specified by the string name of a list of known icons
   * @param knownIcon knownIcon or {@code null} for none
   */
  public GoogleAppsCardV1Icon setKnownIcon(java.lang.String knownIcon) {
    this.knownIcon = knownIcon;
    return this;
  }

  @Override
  public GoogleAppsCardV1Icon set(String fieldName, Object value) {
    return (GoogleAppsCardV1Icon) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Icon clone() {
    return (GoogleAppsCardV1Icon) super.clone();
  }

}
