/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Represents the crop style applied to an image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1ImageCropStyle extends com.google.api.client.json.GenericJson {

  /**
   * The aspect ratio to use if the crop type is `RECTANGLE_CUSTOM`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double aspectRatio;

  /**
   * The crop type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The aspect ratio to use if the crop type is `RECTANGLE_CUSTOM`.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAspectRatio() {
    return aspectRatio;
  }

  /**
   * The aspect ratio to use if the crop type is `RECTANGLE_CUSTOM`.
   * @param aspectRatio aspectRatio or {@code null} for none
   */
  public GoogleAppsCardV1ImageCropStyle setAspectRatio(java.lang.Double aspectRatio) {
    this.aspectRatio = aspectRatio;
    return this;
  }

  /**
   * The crop type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The crop type.
   * @param type type or {@code null} for none
   */
  public GoogleAppsCardV1ImageCropStyle setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public GoogleAppsCardV1ImageCropStyle set(String fieldName, Object value) {
    return (GoogleAppsCardV1ImageCropStyle) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1ImageCropStyle clone() {
    return (GoogleAppsCardV1ImageCropStyle) super.clone();
  }

}
