/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A section contains a collection of widgets that are rendered vertically in the order that they
 * are specified. Across all platforms, cards have a narrow fixed width, so there is currently no
 * need for layout properties, for example, float.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Section extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether this section is collapsible. If a section is collapsible, the description
   * must be given.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean collapsible;

  /**
   * The header of the section. Formatted text is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String header;

  /**
   * The number of uncollapsible widgets. For example, when a section contains five widgets and the
   * `numUncollapsibleWidget` is set to `2`, the first two widgets are always shown and the last
   * three are collapsed as default. The `numUncollapsibleWidget` is taken into account only when
   * collapsible is set to `true`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer uncollapsibleWidgetsCount;

  /**
   * A section must contain at least 1 widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1Widget> widgets;

  /**
   * Indicates whether this section is collapsible. If a section is collapsible, the description
   * must be given.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCollapsible() {
    return collapsible;
  }

  /**
   * Indicates whether this section is collapsible. If a section is collapsible, the description
   * must be given.
   * @param collapsible collapsible or {@code null} for none
   */
  public GoogleAppsCardV1Section setCollapsible(java.lang.Boolean collapsible) {
    this.collapsible = collapsible;
    return this;
  }

  /**
   * The header of the section. Formatted text is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeader() {
    return header;
  }

  /**
   * The header of the section. Formatted text is supported.
   * @param header header or {@code null} for none
   */
  public GoogleAppsCardV1Section setHeader(java.lang.String header) {
    this.header = header;
    return this;
  }

  /**
   * The number of uncollapsible widgets. For example, when a section contains five widgets and the
   * `numUncollapsibleWidget` is set to `2`, the first two widgets are always shown and the last
   * three are collapsed as default. The `numUncollapsibleWidget` is taken into account only when
   * collapsible is set to `true`.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUncollapsibleWidgetsCount() {
    return uncollapsibleWidgetsCount;
  }

  /**
   * The number of uncollapsible widgets. For example, when a section contains five widgets and the
   * `numUncollapsibleWidget` is set to `2`, the first two widgets are always shown and the last
   * three are collapsed as default. The `numUncollapsibleWidget` is taken into account only when
   * collapsible is set to `true`.
   * @param uncollapsibleWidgetsCount uncollapsibleWidgetsCount or {@code null} for none
   */
  public GoogleAppsCardV1Section setUncollapsibleWidgetsCount(java.lang.Integer uncollapsibleWidgetsCount) {
    this.uncollapsibleWidgetsCount = uncollapsibleWidgetsCount;
    return this;
  }

  /**
   * A section must contain at least 1 widget.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1Widget> getWidgets() {
    return widgets;
  }

  /**
   * A section must contain at least 1 widget.
   * @param widgets widgets or {@code null} for none
   */
  public GoogleAppsCardV1Section setWidgets(java.util.List<GoogleAppsCardV1Widget> widgets) {
    this.widgets = widgets;
    return this;
  }

  @Override
  public GoogleAppsCardV1Section set(String fieldName, Object value) {
    return (GoogleAppsCardV1Section) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Section clone() {
    return (GoogleAppsCardV1Section) super.clone();
  }

}
