/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Model definition for GoogleAppsCardV1SwitchControl.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1SwitchControl extends com.google.api.client.json.GenericJson {

  /**
   * The control type, either switch or checkbox.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String controlType;

  /**
   * The name of the switch widget that's used in formInput.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The action when the switch state is changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Action onChangeAction;

  /**
   * If the switch is selected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean selected;

  /**
   * The value is what is passed back in the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The control type, either switch or checkbox.
   * @return value or {@code null} for none
   */
  public java.lang.String getControlType() {
    return controlType;
  }

  /**
   * The control type, either switch or checkbox.
   * @param controlType controlType or {@code null} for none
   */
  public GoogleAppsCardV1SwitchControl setControlType(java.lang.String controlType) {
    this.controlType = controlType;
    return this;
  }

  /**
   * The name of the switch widget that's used in formInput.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the switch widget that's used in formInput.
   * @param name name or {@code null} for none
   */
  public GoogleAppsCardV1SwitchControl setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The action when the switch state is changed.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Action getOnChangeAction() {
    return onChangeAction;
  }

  /**
   * The action when the switch state is changed.
   * @param onChangeAction onChangeAction or {@code null} for none
   */
  public GoogleAppsCardV1SwitchControl setOnChangeAction(GoogleAppsCardV1Action onChangeAction) {
    this.onChangeAction = onChangeAction;
    return this;
  }

  /**
   * If the switch is selected.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSelected() {
    return selected;
  }

  /**
   * If the switch is selected.
   * @param selected selected or {@code null} for none
   */
  public GoogleAppsCardV1SwitchControl setSelected(java.lang.Boolean selected) {
    this.selected = selected;
    return this;
  }

  /**
   * The value is what is passed back in the callback.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value is what is passed back in the callback.
   * @param value value or {@code null} for none
   */
  public GoogleAppsCardV1SwitchControl setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public GoogleAppsCardV1SwitchControl set(String fieldName, Object value) {
    return (GoogleAppsCardV1SwitchControl) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1SwitchControl clone() {
    return (GoogleAppsCardV1SwitchControl) super.clone();
  }

}
