/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A text input is a UI item where users can input text. A text input can also have an onChange
 * action and suggestions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1TextInput extends com.google.api.client.json.GenericJson {

  /**
   * The refresh function that returns suggestions based on the user's input text. If the callback
   * is not specified, autocomplete is done in client side based on the initial suggestion items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Action autoCompleteAction;

  /**
   * The hint text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hintText;

  /**
   * The initial suggestions made before any user input.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Suggestions initialSuggestions;

  /**
   * At least one of label and hintText must be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The name of the text input which is used in formInput.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The onChange action, for example, invoke a function.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Action onChangeAction;

  /**
   * The style of the text, for example, a single line or multiple lines.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The default value when there is no input from the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The refresh function that returns suggestions based on the user's input text. If the callback
   * is not specified, autocomplete is done in client side based on the initial suggestion items.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Action getAutoCompleteAction() {
    return autoCompleteAction;
  }

  /**
   * The refresh function that returns suggestions based on the user's input text. If the callback
   * is not specified, autocomplete is done in client side based on the initial suggestion items.
   * @param autoCompleteAction autoCompleteAction or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setAutoCompleteAction(GoogleAppsCardV1Action autoCompleteAction) {
    this.autoCompleteAction = autoCompleteAction;
    return this;
  }

  /**
   * The hint text.
   * @return value or {@code null} for none
   */
  public java.lang.String getHintText() {
    return hintText;
  }

  /**
   * The hint text.
   * @param hintText hintText or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setHintText(java.lang.String hintText) {
    this.hintText = hintText;
    return this;
  }

  /**
   * The initial suggestions made before any user input.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Suggestions getInitialSuggestions() {
    return initialSuggestions;
  }

  /**
   * The initial suggestions made before any user input.
   * @param initialSuggestions initialSuggestions or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setInitialSuggestions(GoogleAppsCardV1Suggestions initialSuggestions) {
    this.initialSuggestions = initialSuggestions;
    return this;
  }

  /**
   * At least one of label and hintText must be specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * At least one of label and hintText must be specified.
   * @param label label or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * The name of the text input which is used in formInput.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the text input which is used in formInput.
   * @param name name or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The onChange action, for example, invoke a function.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Action getOnChangeAction() {
    return onChangeAction;
  }

  /**
   * The onChange action, for example, invoke a function.
   * @param onChangeAction onChangeAction or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setOnChangeAction(GoogleAppsCardV1Action onChangeAction) {
    this.onChangeAction = onChangeAction;
    return this;
  }

  /**
   * The style of the text, for example, a single line or multiple lines.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The style of the text, for example, a single line or multiple lines.
   * @param type type or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The default value when there is no input from the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The default value when there is no input from the user.
   * @param value value or {@code null} for none
   */
  public GoogleAppsCardV1TextInput setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public GoogleAppsCardV1TextInput set(String fieldName, Object value) {
    return (GoogleAppsCardV1TextInput) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1TextInput clone() {
    return (GoogleAppsCardV1TextInput) super.clone();
  }

}
