/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Model definition for ListSpacesResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListSpacesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Continuation token to retrieve the next page of results. It will be empty for the last page of
   * results. Tokens expire in an hour. An error is thrown if an expired token is passed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of spaces in the requested (or first) page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Space> spaces;

  /**
   * Continuation token to retrieve the next page of results. It will be empty for the last page of
   * results. Tokens expire in an hour. An error is thrown if an expired token is passed.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Continuation token to retrieve the next page of results. It will be empty for the last page of
   * results. Tokens expire in an hour. An error is thrown if an expired token is passed.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListSpacesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * List of spaces in the requested (or first) page.
   * @return value or {@code null} for none
   */
  public java.util.List<Space> getSpaces() {
    return spaces;
  }

  /**
   * List of spaces in the requested (or first) page.
   * @param spaces spaces or {@code null} for none
   */
  public ListSpacesResponse setSpaces(java.util.List<Space> spaces) {
    this.spaces = spaces;
    return this;
  }

  @Override
  public ListSpacesResponse set(String fieldName, Object value) {
    return (ListSpacesResponse) super.set(fieldName, value);
  }

  @Override
  public ListSpacesResponse clone() {
    return (ListSpacesResponse) super.clone();
  }

}
