/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * An onclick action (e.g. open a link).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OnClick extends com.google.api.client.json.GenericJson {

  /**
   * A form action will be triggered by this onclick if specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FormAction action;

  /**
   * This onclick triggers an open link action if specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OpenLink openLink;

  /**
   * A form action will be triggered by this onclick if specified.
   * @return value or {@code null} for none
   */
  public FormAction getAction() {
    return action;
  }

  /**
   * A form action will be triggered by this onclick if specified.
   * @param action action or {@code null} for none
   */
  public OnClick setAction(FormAction action) {
    this.action = action;
    return this;
  }

  /**
   * This onclick triggers an open link action if specified.
   * @return value or {@code null} for none
   */
  public OpenLink getOpenLink() {
    return openLink;
  }

  /**
   * This onclick triggers an open link action if specified.
   * @param openLink openLink or {@code null} for none
   */
  public OnClick setOpenLink(OpenLink openLink) {
    this.openLink = openLink;
    return this;
  }

  @Override
  public OnClick set(String fieldName, Object value) {
    return (OnClick) super.set(fieldName, value);
  }

  @Override
  public OnClick clone() {
    return (OnClick) super.clone();
  }

}
