/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A section contains a collection of widgets that are rendered (vertically) in the order that they
 * are specified. Across all platforms, cards have a narrow fixed width, so there is currently no
 * need for layout properties (e.g. float).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Section extends com.google.api.client.json.GenericJson {

  /**
   * The header of the section, text formatted supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String header;

  /**
   * A section must contain at least 1 widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WidgetMarkup> widgets;

  /**
   * The header of the section, text formatted supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeader() {
    return header;
  }

  /**
   * The header of the section, text formatted supported.
   * @param header header or {@code null} for none
   */
  public Section setHeader(java.lang.String header) {
    this.header = header;
    return this;
  }

  /**
   * A section must contain at least 1 widget.
   * @return value or {@code null} for none
   */
  public java.util.List<WidgetMarkup> getWidgets() {
    return widgets;
  }

  /**
   * A section must contain at least 1 widget.
   * @param widgets widgets or {@code null} for none
   */
  public Section setWidgets(java.util.List<WidgetMarkup> widgets) {
    this.widgets = widgets;
    return this;
  }

  @Override
  public Section set(String fieldName, Object value) {
    return (Section) super.set(fieldName, value);
  }

  @Override
  public Section clone() {
    return (Section) super.clone();
  }

}
