/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1;

/**
 * Service definition for HangoutsChat (v1).
 *
 * <p>
 * Enables apps to fetch information and perform actions in Google Chat. Authentication is a prerequisite for using the Google Chat REST API.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/hangouts/chat" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link HangoutsChatRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class HangoutsChat extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Chat API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://chat.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://chat.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public HangoutsChat(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  HangoutsChat(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Media collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Media.List request = chat.media().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Media media() {
    return new Media();
  }

  /**
   * The "media" collection of methods.
   */
  public class Media {

    /**
     * Downloads media. Download is supported on the URI `/v1/media/{+name}?alt=media`.
     *
     * Create a request for the method "media.download".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Download#execute()} method to invoke the remote operation.
     *
     * @param resourceName Name of the media that is being downloaded. See ReadRequest.resource_name.
     * @return the request
     */
    public Download download(java.lang.String resourceName) throws java.io.IOException {
      Download result = new Download(resourceName);
      initialize(result);
      return result;
    }

    public class Download extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Media> {

      private static final String REST_PATH = "v1/media/{+resourceName}";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^.*$");

      /**
       * Downloads media. Download is supported on the URI `/v1/media/{+name}?alt=media`.
       *
       * Create a request for the method "media.download".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Download#execute()} method to invoke the remote operation. <p>
       * {@link
       * Download#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceName Name of the media that is being downloaded. See ReadRequest.resource_name.
       * @since 1.13
       */
      protected Download(java.lang.String resourceName) {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Media.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^.*$");
        }
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Download set$Xgafv(java.lang.String $Xgafv) {
        return (Download) super.set$Xgafv($Xgafv);
      }

      @Override
      public Download setAccessToken(java.lang.String accessToken) {
        return (Download) super.setAccessToken(accessToken);
      }

      @Override
      public Download setAlt(java.lang.String alt) {
        return (Download) super.setAlt(alt);
      }

      @Override
      public Download setCallback(java.lang.String callback) {
        return (Download) super.setCallback(callback);
      }

      @Override
      public Download setFields(java.lang.String fields) {
        return (Download) super.setFields(fields);
      }

      @Override
      public Download setKey(java.lang.String key) {
        return (Download) super.setKey(key);
      }

      @Override
      public Download setOauthToken(java.lang.String oauthToken) {
        return (Download) super.setOauthToken(oauthToken);
      }

      @Override
      public Download setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Download) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Download setQuotaUser(java.lang.String quotaUser) {
        return (Download) super.setQuotaUser(quotaUser);
      }

      @Override
      public Download setUploadType(java.lang.String uploadType) {
        return (Download) super.setUploadType(uploadType);
      }

      @Override
      public Download setUploadProtocol(java.lang.String uploadProtocol) {
        return (Download) super.setUploadProtocol(uploadProtocol);
      }

      /** Name of the media that is being downloaded. See ReadRequest.resource_name. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Name of the media that is being downloaded. See ReadRequest.resource_name.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Name of the media that is being downloaded. See ReadRequest.resource_name. */
      public Download setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^.*$");
        }
        this.resourceName = resourceName;
        return this;
      }

      @Override
      public Download set(String parameterName, Object value) {
        return (Download) super.set(parameterName, value);
      }
    }
    /**
     * Uploads an attachment. For an example, see [Upload media as a file
     * attachment](https://developers.google.com/chat/api/guides/v1/media-and-attachments/upload).
     * Requires user [authentication](https://developers.google.com/chat/api/guides/auth/users). You can
     * upload attachments up to 200 MB. Certain file types aren't supported. For details, see [File
     * types blocked by Google Chat](https://support.google.com/chat/answer/7651457?=GENIE.Platform%3DDe
     * sktop#File%20types%20blocked%20in%20Google%20Chat).
     *
     * Create a request for the method "media.upload".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Resource name of the Chat space in which the attachment is uploaded. Format
     *        "spaces/{space}".
     * @param content the {@link com.google.api.services.chat.v1.model.UploadAttachmentRequest}
     * @return the request
     */
    public Upload upload(java.lang.String parent, com.google.api.services.chat.v1.model.UploadAttachmentRequest content) throws java.io.IOException {
      Upload result = new Upload(parent, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads an attachment. For an example, see [Upload media as a file
     * attachment](https://developers.google.com/chat/api/guides/v1/media-and-attachments/upload).
     * Requires user [authentication](https://developers.google.com/chat/api/guides/auth/users). You can
     * upload attachments up to 200 MB. Certain file types aren't supported. For details, see [File
     * types blocked by Google Chat](https://support.google.com/chat/answer/7651457?=GENIE.Platform%3DDe
     * sktop#File%20types%20blocked%20in%20Google%20Chat).
     *
     * Create a request for the method "media.upload".
     *
     * This request holds the parameters needed by the the chat server.  After setting any optional
     * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param parent Required. Resource name of the Chat space in which the attachment is uploaded. Format
     *        "spaces/{space}".
     * @param content the {@link com.google.api.services.chat.v1.model.UploadAttachmentRequest} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Upload upload(java.lang.String parent, com.google.api.services.chat.v1.model.UploadAttachmentRequest content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Upload result = new Upload(parent, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Upload extends HangoutsChatRequest<com.google.api.services.chat.v1.model.UploadAttachmentResponse> {

      private static final String REST_PATH = "v1/{+parent}/attachments:upload";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Uploads an attachment. For an example, see [Upload media as a file
       * attachment](https://developers.google.com/chat/api/guides/v1/media-and-attachments/upload).
       * Requires user [authentication](https://developers.google.com/chat/api/guides/auth/users). You
       * can upload attachments up to 200 MB. Certain file types aren't supported. For details, see
       * [File types blocked by Google Chat](https://support.google.com/chat/answer/7651457?=GENIE.Platf
       * orm%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
       *
       * Create a request for the method "media.upload".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Upload#execute()} method to invoke the remote operation. <p> {@link
       * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Resource name of the Chat space in which the attachment is uploaded. Format
     *        "spaces/{space}".
       * @param content the {@link com.google.api.services.chat.v1.model.UploadAttachmentRequest}
       * @since 1.13
       */
      protected Upload(java.lang.String parent, com.google.api.services.chat.v1.model.UploadAttachmentRequest content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.UploadAttachmentResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      /**
       * Uploads an attachment. For an example, see [Upload media as a file
       * attachment](https://developers.google.com/chat/api/guides/v1/media-and-attachments/upload).
       * Requires user [authentication](https://developers.google.com/chat/api/guides/auth/users). You
       * can upload attachments up to 200 MB. Certain file types aren't supported. For details, see
       * [File types blocked by Google Chat](https://support.google.com/chat/answer/7651457?=GENIE.Platf
       * orm%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
       *
       * Create a request for the method "media.upload".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Upload#execute()} method to invoke the remote operation. <p> {@link
       * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param parent Required. Resource name of the Chat space in which the attachment is uploaded. Format
     *        "spaces/{space}".
       * @param content the {@link com.google.api.services.chat.v1.model.UploadAttachmentRequest} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Upload(java.lang.String parent, com.google.api.services.chat.v1.model.UploadAttachmentRequest content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(HangoutsChat.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.chat.v1.model.UploadAttachmentResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Upload set$Xgafv(java.lang.String $Xgafv) {
        return (Upload) super.set$Xgafv($Xgafv);
      }

      @Override
      public Upload setAccessToken(java.lang.String accessToken) {
        return (Upload) super.setAccessToken(accessToken);
      }

      @Override
      public Upload setAlt(java.lang.String alt) {
        return (Upload) super.setAlt(alt);
      }

      @Override
      public Upload setCallback(java.lang.String callback) {
        return (Upload) super.setCallback(callback);
      }

      @Override
      public Upload setFields(java.lang.String fields) {
        return (Upload) super.setFields(fields);
      }

      @Override
      public Upload setKey(java.lang.String key) {
        return (Upload) super.setKey(key);
      }

      @Override
      public Upload setOauthToken(java.lang.String oauthToken) {
        return (Upload) super.setOauthToken(oauthToken);
      }

      @Override
      public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Upload) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Upload setQuotaUser(java.lang.String quotaUser) {
        return (Upload) super.setQuotaUser(quotaUser);
      }

      @Override
      public Upload setUploadType(java.lang.String uploadType) {
        return (Upload) super.setUploadType(uploadType);
      }

      @Override
      public Upload setUploadProtocol(java.lang.String uploadProtocol) {
        return (Upload) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Resource name of the Chat space in which the attachment is uploaded. Format
       * "spaces/{space}".
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Resource name of the Chat space in which the attachment is uploaded. Format
     "spaces/{space}".
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Required. Resource name of the Chat space in which the attachment is uploaded. Format
       * "spaces/{space}".
       */
      public Upload setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      @Override
      public Upload set(String parameterName, Object value) {
        return (Upload) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Spaces collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code HangoutsChat chat = new HangoutsChat(...);}
   *   {@code HangoutsChat.Spaces.List request = chat.spaces().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Spaces spaces() {
    return new Spaces();
  }

  /**
   * The "spaces" collection of methods.
   */
  public class Spaces {

    /**
     * Creates a named space. Spaces grouped by topics aren't supported. For an example, see [Create a
     * space](https://developers.google.com/chat/api/guides/v1/spaces/create). If you receive the error
     * message `ALREADY_EXISTS` when creating a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display name. Requires [user
     * authentication](https://developers.google.com/chat/api/guides/auth/users).
     *
     * Create a request for the method "spaces.create".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.chat.v1.model.Space}
     * @return the request
     */
    public Create create(com.google.api.services.chat.v1.model.Space content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/spaces";

      /**
       * Creates a named space. Spaces grouped by topics aren't supported. For an example, see [Create a
       * space](https://developers.google.com/chat/api/guides/v1/spaces/create). If you receive the
       * error message `ALREADY_EXISTS` when creating a space, try a different `displayName`. An
       * existing space within the Google Workspace organization might already use this display name.
       * Requires [user authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "spaces.create".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.chat.v1.model.Space}
       * @since 1.13
       */
      protected Create(com.google.api.services.chat.v1.model.Space content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Space.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. A unique identifier for this request. A random UUID is recommended. Specifying an
       * existing request ID returns the space created with that ID instead of creating a new space.
       * Specifying an existing request ID from the same Chat app with a different authenticated
       * user returns an error.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Optional. A unique identifier for this request. A random UUID is recommended. Specifying an
     existing request ID returns the space created with that ID instead of creating a new space.
     Specifying an existing request ID from the same Chat app with a different authenticated user
     returns an error.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Optional. A unique identifier for this request. A random UUID is recommended. Specifying an
       * existing request ID returns the space created with that ID instead of creating a new space.
       * Specifying an existing request ID from the same Chat app with a different authenticated
       * user returns an error.
       */
      public Create setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a named space. Always performs a cascading delete, which means that the space's child
     * resources—like messages posted in the space and memberships in the space—are also deleted. For an
     * example, see [Delete a space](https://developers.google.com/chat/api/guides/v1/spaces/delete).
     * Requires [user authentication](https://developers.google.com/chat/api/guides/auth/users) from a
     * user who has permission to delete the space.
     *
     * Create a request for the method "spaces.delete".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param name Required. Resource name of the space to delete. Format: `spaces/{space}`
     * @return the request
     */
    public Delete delete(java.lang.String name) throws java.io.IOException {
      Delete result = new Delete(name);
      initialize(result);
      return result;
    }

    public class Delete extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Deletes a named space. Always performs a cascading delete, which means that the space's child
       * resources—like messages posted in the space and memberships in the space—are also deleted. For
       * an example, see [Delete a
       * space](https://developers.google.com/chat/api/guides/v1/spaces/delete). Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users) from a user who has
       * permission to delete the space.
       *
       * Create a request for the method "spaces.delete".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. Resource name of the space to delete. Format: `spaces/{space}`
       * @since 1.13
       */
      protected Delete(java.lang.String name) {
        super(HangoutsChat.this, "DELETE", REST_PATH, null, com.google.api.services.chat.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Resource name of the space to delete. Format: `spaces/{space}` */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. Resource name of the space to delete. Format: `spaces/{space}`
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. Resource name of the space to delete. Format: `spaces/{space}` */
      public Delete setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the existing direct message with the specified user. If no direct message space is found,
     * returns a `404 NOT_FOUND` error. For an example, see [Find a direct
     * message](/chat/api/guides/v1/spaces/find-direct-message). With [user
     * authentication](https://developers.google.com/chat/api/guides/auth/users), returns the direct
     * message space between the specified user and the authenticated user. With [service account
     * authentication](https://developers.google.com/chat/api/guides/auth/service-accounts), returns the
     * direct message space between the specified user and the calling Chat app. Requires [user
     * authentication](https://developers.google.com/chat/api/guides/auth/users) or [service account
     * authentication](https://developers.google.com/chat/api/guides/auth/service-accounts).
     *
     * Create a request for the method "spaces.findDirectMessage".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link FindDirectMessage#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public FindDirectMessage findDirectMessage() throws java.io.IOException {
      FindDirectMessage result = new FindDirectMessage();
      initialize(result);
      return result;
    }

    public class FindDirectMessage extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/spaces:findDirectMessage";

      /**
       * Returns the existing direct message with the specified user. If no direct message space is
       * found, returns a `404 NOT_FOUND` error. For an example, see [Find a direct
       * message](/chat/api/guides/v1/spaces/find-direct-message). With [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users), returns the direct
       * message space between the specified user and the authenticated user. With [service account
       * authentication](https://developers.google.com/chat/api/guides/auth/service-accounts), returns
       * the direct message space between the specified user and the calling Chat app. Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users) or [service account
       * authentication](https://developers.google.com/chat/api/guides/auth/service-accounts).
       *
       * Create a request for the method "spaces.findDirectMessage".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link FindDirectMessage#execute()} method to invoke the remote operation.
       * <p> {@link FindDirectMessage#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @since 1.13
       */
      protected FindDirectMessage() {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Space.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public FindDirectMessage set$Xgafv(java.lang.String $Xgafv) {
        return (FindDirectMessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public FindDirectMessage setAccessToken(java.lang.String accessToken) {
        return (FindDirectMessage) super.setAccessToken(accessToken);
      }

      @Override
      public FindDirectMessage setAlt(java.lang.String alt) {
        return (FindDirectMessage) super.setAlt(alt);
      }

      @Override
      public FindDirectMessage setCallback(java.lang.String callback) {
        return (FindDirectMessage) super.setCallback(callback);
      }

      @Override
      public FindDirectMessage setFields(java.lang.String fields) {
        return (FindDirectMessage) super.setFields(fields);
      }

      @Override
      public FindDirectMessage setKey(java.lang.String key) {
        return (FindDirectMessage) super.setKey(key);
      }

      @Override
      public FindDirectMessage setOauthToken(java.lang.String oauthToken) {
        return (FindDirectMessage) super.setOauthToken(oauthToken);
      }

      @Override
      public FindDirectMessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (FindDirectMessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public FindDirectMessage setQuotaUser(java.lang.String quotaUser) {
        return (FindDirectMessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public FindDirectMessage setUploadType(java.lang.String uploadType) {
        return (FindDirectMessage) super.setUploadType(uploadType);
      }

      @Override
      public FindDirectMessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (FindDirectMessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Resource name of the user to find direct message with. Format: `users/{user}`,
       * where `{user}` is either the `{person_id}` for the
       * [person](https://developers.google.com/people/api/rest/v1/people) from the People API, or
       * the `id` for the [user](https://developers.google.com/admin-
       * sdk/directory/reference/rest/v1/users) in the Directory API. For example, if the People API
       * `Person.resourceName` is `people/123456789`, you can find a direct message with that person
       * by using `users/123456789` as the `name`. When [authenticated as a
       * user](https://developers.google.com/chat/api/guides/auth/users), you can use the email as
       * an alias for `{user}`. For example, `users/example@gmail.com` where `example@gmail.com` is
       * the email of the Google Chat user.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. Resource name of the user to find direct message with. Format: `users/{user}`, where
     `{user}` is either the `{person_id}` for the
     [person](https://developers.google.com/people/api/rest/v1/people) from the People API, or the `id`
     for the [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users) in the
     Directory API. For example, if the People API `Person.resourceName` is `people/123456789`, you can
     find a direct message with that person by using `users/123456789` as the `name`. When
     [authenticated as a user](https://developers.google.com/chat/api/guides/auth/users), you can use
     the email as an alias for `{user}`. For example, `users/example@gmail.com` where
     `example@gmail.com` is the email of the Google Chat user.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. Resource name of the user to find direct message with. Format: `users/{user}`,
       * where `{user}` is either the `{person_id}` for the
       * [person](https://developers.google.com/people/api/rest/v1/people) from the People API, or
       * the `id` for the [user](https://developers.google.com/admin-
       * sdk/directory/reference/rest/v1/users) in the Directory API. For example, if the People API
       * `Person.resourceName` is `people/123456789`, you can find a direct message with that person
       * by using `users/123456789` as the `name`. When [authenticated as a
       * user](https://developers.google.com/chat/api/guides/auth/users), you can use the email as
       * an alias for `{user}`. For example, `users/example@gmail.com` where `example@gmail.com` is
       * the email of the Google Chat user.
       */
      public FindDirectMessage setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @Override
      public FindDirectMessage set(String parameterName, Object value) {
        return (FindDirectMessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns details about a space. For an example, see [Get a
     * space](https://developers.google.com/chat/api/guides/v1/spaces/get). Requires
     * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
     * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
     * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
     * authentication](https://developers.google.com/chat/api/guides/auth/users).
     *
     * Create a request for the method "spaces.get".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name Required. Resource name of the space, in the form "spaces". Format: `spaces/{space}`
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Returns details about a space. For an example, see [Get a
       * space](https://developers.google.com/chat/api/guides/v1/spaces/get). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
       * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "spaces.get".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. Resource name of the space, in the form "spaces". Format: `spaces/{space}`
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Space.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Resource name of the space, in the form "spaces". Format: `spaces/{space}` */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. Resource name of the space, in the form "spaces". Format: `spaces/{space}`
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. Resource name of the space, in the form "spaces". Format: `spaces/{space}` */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists spaces the caller is a member of. Group chats and DMs aren't listed until the first message
     * is sent. For an example, see [List
     * spaces](https://developers.google.com/chat/api/guides/v1/spaces/list). Requires
     * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
     * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
     * [user authentication](https://developers.google.com/chat/api/guides/auth/users). Lists spaces
     * visible to the caller or authenticated user. Group chats and DMs aren't listed until the first
     * message is sent.
     *
     * Create a request for the method "spaces.list".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListSpacesResponse> {

      private static final String REST_PATH = "v1/spaces";

      /**
       * Lists spaces the caller is a member of. Group chats and DMs aren't listed until the first
       * message is sent. For an example, see [List
       * spaces](https://developers.google.com/chat/api/guides/v1/spaces/list). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
       * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). Lists
       * spaces visible to the caller or authenticated user. Group chats and DMs aren't listed until the
       * first message is sent.
       *
       * Create a request for the method "spaces.list".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListSpacesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. A query filter. Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users). You can filter
       * spaces by the space type ([`space_type`](https://developers.google.com/chat/api/reference/r
       * est/v1/spaces#spacetype)). To filter by space type, you must specify valid enum value, such
       * as `SPACE` or `GROUP_CHAT` (the `space_type` can't be `SPACE_TYPE_UNSPECIFIED`). To query
       * for multiple space types, use the `OR` operator. For example, the following queries are
       * valid: ``` space_type = "SPACE" spaceType = "GROUP_CHAT" OR spaceType = "DIRECT_MESSAGE"
       * ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT` error. With
       * [service account authentication](https://developers.google.com/chat/api/guides/auth
       * /service-accounts), this field is ignored and the query always returns all spaces. But the
       * Chat API still validates the query syntax with service accounts, so invalid queries are
       * still rejected.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. A query filter. Requires [user
     authentication](https://developers.google.com/chat/api/guides/auth/users). You can filter spaces by
     the space type
     ([`space_type`](https://developers.google.com/chat/api/reference/rest/v1/spaces#spacetype)). To
     filter by space type, you must specify valid enum value, such as `SPACE` or `GROUP_CHAT` (the
     `space_type` can't be `SPACE_TYPE_UNSPECIFIED`). To query for multiple space types, use the `OR`
     operator. For example, the following queries are valid: ``` space_type = "SPACE" spaceType =
     "GROUP_CHAT" OR spaceType = "DIRECT_MESSAGE" ``` Invalid queries are rejected by the server with an
     `INVALID_ARGUMENT` error. With [service account
     authentication](https://developers.google.com/chat/api/guides/auth/service-accounts), this field is
     ignored and the query always returns all spaces. But the Chat API still validates the query syntax
     with service accounts, so invalid queries are still rejected.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Optional. A query filter. Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users). You can filter
       * spaces by the space type ([`space_type`](https://developers.google.com/chat/api/reference/r
       * est/v1/spaces#spacetype)). To filter by space type, you must specify valid enum value, such
       * as `SPACE` or `GROUP_CHAT` (the `space_type` can't be `SPACE_TYPE_UNSPECIFIED`). To query
       * for multiple space types, use the `OR` operator. For example, the following queries are
       * valid: ``` space_type = "SPACE" spaceType = "GROUP_CHAT" OR spaceType = "DIRECT_MESSAGE"
       * ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT` error. With
       * [service account authentication](https://developers.google.com/chat/api/guides/auth
       * /service-accounts), this field is ignored and the query always returns all spaces. But the
       * Chat API still validates the query syntax with service accounts, so invalid queries are
       * still rejected.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. The maximum number of spaces to return. The service might return fewer than this
       * value. If unspecified, at most 100 spaces are returned. The maximum value is 1,000. If you
       * use a value more than 1,000, it's automatically changed to 1,000. Negative values return an
       * `INVALID_ARGUMENT` error.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The maximum number of spaces to return. The service might return fewer than this value.
     If unspecified, at most 100 spaces are returned. The maximum value is 1,000. If you use a value
     more than 1,000, it's automatically changed to 1,000. Negative values return an `INVALID_ARGUMENT`
     error.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The maximum number of spaces to return. The service might return fewer than this
       * value. If unspecified, at most 100 spaces are returned. The maximum value is 1,000. If you
       * use a value more than 1,000, it's automatically changed to 1,000. Negative values return an
       * `INVALID_ARGUMENT` error.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. A page token, received from a previous list spaces call. Provide this parameter
       * to retrieve the subsequent page. When paginating, the filter value should match the call
       * that provided the page token. Passing a different value may lead to unexpected results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A page token, received from a previous list spaces call. Provide this parameter to
     retrieve the subsequent page. When paginating, the filter value should match the call that provided
     the page token. Passing a different value may lead to unexpected results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A page token, received from a previous list spaces call. Provide this parameter
       * to retrieve the subsequent page. When paginating, the filter value should match the call
       * that provided the page token. Passing a different value may lead to unexpected results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a space. For an example, see [Update a
     * space](https://developers.google.com/chat/api/guides/v1/spaces/update). If you're updating the
     * `displayName` field and receive the error message `ALREADY_EXISTS`, try a different display
     * name.. An existing space within the Google Workspace organization might already use this display
     * name. Requires [user authentication](https://developers.google.com/chat/api/guides/auth/users).
     *
     * Create a request for the method "spaces.patch".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param name Resource name of the space. Format: `spaces/{space}`
     * @param content the {@link com.google.api.services.chat.v1.model.Space}
     * @return the request
     */
    public Patch patch(java.lang.String name, com.google.api.services.chat.v1.model.Space content) throws java.io.IOException {
      Patch result = new Patch(name, content);
      initialize(result);
      return result;
    }

    public class Patch extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^spaces/[^/]+$");

      /**
       * Updates a space. For an example, see [Update a
       * space](https://developers.google.com/chat/api/guides/v1/spaces/update). If you're updating the
       * `displayName` field and receive the error message `ALREADY_EXISTS`, try a different display
       * name.. An existing space within the Google Workspace organization might already use this
       * display name. Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "spaces.patch".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Resource name of the space. Format: `spaces/{space}`
       * @param content the {@link com.google.api.services.chat.v1.model.Space}
       * @since 1.13
       */
      protected Patch(java.lang.String name, com.google.api.services.chat.v1.model.Space content) {
        super(HangoutsChat.this, "PATCH", REST_PATH, content, com.google.api.services.chat.v1.model.Space.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Resource name of the space. Format: `spaces/{space}` */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Resource name of the space. Format: `spaces/{space}`
       */
      public java.lang.String getName() {
        return name;
      }

      /** Resource name of the space. Format: `spaces/{space}` */
      public Patch setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^spaces/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /**
       * Required. The updated field paths, comma separated if there are multiple. Currently
       * supported field paths: - `display_name` (Only supports changing the display name of a space
       * with the `SPACE` type, or when also including the `space_type` mask to change a
       * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a `GROUP_CHAT` or
       * a `DIRECT_MESSAGE` space results in an invalid argument error. If you receive the error
       * message `ALREADY_EXISTS` when updating the `displayName`, try a different `displayName`. An
       * existing space within the Google Workspace organization might already use this display
       * name.) - `space_type` (Only supports changing a `GROUP_CHAT` space type to `SPACE`. Include
       * `display_name` together with `space_type` in the update mask and ensure that the specified
       * space has a non-empty display name and the `SPACE` space type. Including the `space_type`
       * mask and the `SPACE` type in the specified space when updating the display name is optional
       * if the existing space already has the `SPACE` type. Trying to update the space type in
       * other ways results in an invalid argument error). - `space_details` - `space_history_state`
       * (Supports [turning history on or off for the
       * space](https://support.google.com/chat/answer/7664687) if [the organization allows users to
       * change their history setting](https://support.google.com/a/answer/7664184). Warning:
       * mutually exclusive with all other field paths.)
       */
      @com.google.api.client.util.Key
      private String updateMask;

      /** Required. The updated field paths, comma separated if there are multiple. Currently supported field
     paths: - `display_name` (Only supports changing the display name of a space with the `SPACE` type,
     or when also including the `space_type` mask to change a `GROUP_CHAT` space type to `SPACE`. Trying
     to update the display name of a `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid
     argument error. If you receive the error message `ALREADY_EXISTS` when updating the `displayName`,
     try a different `displayName`. An existing space within the Google Workspace organization might
     already use this display name.) - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     `SPACE`. Include `display_name` together with `space_type` in the update mask and ensure that the
     specified space has a non-empty display name and the `SPACE` space type. Including the `space_type`
     mask and the `SPACE` type in the specified space when updating the display name is optional if the
     existing space already has the `SPACE` type. Trying to update the space type in other ways results
     in an invalid argument error). - `space_details` - `space_history_state` (Supports [turning history
     on or off for the space](https://support.google.com/chat/answer/7664687) if [the organization
     allows users to change their history setting](https://support.google.com/a/answer/7664184).
     Warning: mutually exclusive with all other field paths.)
       */
      public String getUpdateMask() {
        return updateMask;
      }

      /**
       * Required. The updated field paths, comma separated if there are multiple. Currently
       * supported field paths: - `display_name` (Only supports changing the display name of a space
       * with the `SPACE` type, or when also including the `space_type` mask to change a
       * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a `GROUP_CHAT` or
       * a `DIRECT_MESSAGE` space results in an invalid argument error. If you receive the error
       * message `ALREADY_EXISTS` when updating the `displayName`, try a different `displayName`. An
       * existing space within the Google Workspace organization might already use this display
       * name.) - `space_type` (Only supports changing a `GROUP_CHAT` space type to `SPACE`. Include
       * `display_name` together with `space_type` in the update mask and ensure that the specified
       * space has a non-empty display name and the `SPACE` space type. Including the `space_type`
       * mask and the `SPACE` type in the specified space when updating the display name is optional
       * if the existing space already has the `SPACE` type. Trying to update the space type in
       * other ways results in an invalid argument error). - `space_details` - `space_history_state`
       * (Supports [turning history on or off for the
       * space](https://support.google.com/chat/answer/7664687) if [the organization allows users to
       * change their history setting](https://support.google.com/a/answer/7664184). Warning:
       * mutually exclusive with all other field paths.)
       */
      public Patch setUpdateMask(String updateMask) {
        this.updateMask = updateMask;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Creates a space and adds specified users to it. The calling user is automatically added to the
     * space, and shouldn't be specified as a membership in the request. For an example, see [Set up a
     * space](https://developers.google.com/chat/api/guides/v1/spaces/set-up). To specify the human
     * members to add, add memberships with the appropriate `member.name` in the `SetUpSpaceRequest`. To
     * add a human user, use `users/{user}`, where `{user}` can be the email address for the user. For
     * users in the same Workspace organization `{user}` can also be the `{person_id}` for the person
     * from the People API, or the `id` for the user in the Directory API. For example, if the People
     * API Person `resourceName` for `user@example.com` is `people/123456789`, you can add the user to
     * the space by setting the `membership.member.name` to `users/user@example.com` or
     * `users/123456789`. For a space or group chat, if the caller blocks or is blocked by some members,
     * then those members aren't added to the created space. To create a direct message (DM) between the
     * calling user and another human user, specify exactly one membership to represent the human user.
     * If one user blocks the other, the request fails and the DM isn't created. To create a DM between
     * the calling user and the calling app, set `Space.singleUserBotDm` to `true` and don't specify any
     * memberships. You can only use this method to set up a DM with the calling app. To add the calling
     * app as a member of a space or an existing DM between two human users, see [create a
     * membership](https://developers.google.com/chat/api/guides/v1/members/create). If a DM already
     * exists between two users, even when one user blocks the other at the time a request is made, then
     * the existing DM is returned. Spaces with threaded replies aren't supported. If you receive the
     * error message `ALREADY_EXISTS` when setting up a space, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use this display name.
     * Requires [user authentication](https://developers.google.com/chat/api/guides/auth/users).
     *
     * Create a request for the method "spaces.setup".
     *
     * This request holds the parameters needed by the chat server.  After setting any optional
     * parameters, call the {@link Setup#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.chat.v1.model.SetUpSpaceRequest}
     * @return the request
     */
    public Setup setup(com.google.api.services.chat.v1.model.SetUpSpaceRequest content) throws java.io.IOException {
      Setup result = new Setup(content);
      initialize(result);
      return result;
    }

    public class Setup extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Space> {

      private static final String REST_PATH = "v1/spaces:setup";

      /**
       * Creates a space and adds specified users to it. The calling user is automatically added to the
       * space, and shouldn't be specified as a membership in the request. For an example, see [Set up a
       * space](https://developers.google.com/chat/api/guides/v1/spaces/set-up). To specify the human
       * members to add, add memberships with the appropriate `member.name` in the `SetUpSpaceRequest`.
       * To add a human user, use `users/{user}`, where `{user}` can be the email address for the user.
       * For users in the same Workspace organization `{user}` can also be the `{person_id}` for the
       * person from the People API, or the `id` for the user in the Directory API. For example, if the
       * People API Person `resourceName` for `user@example.com` is `people/123456789`, you can add the
       * user to the space by setting the `membership.member.name` to `users/user@example.com` or
       * `users/123456789`. For a space or group chat, if the caller blocks or is blocked by some
       * members, then those members aren't added to the created space. To create a direct message (DM)
       * between the calling user and another human user, specify exactly one membership to represent
       * the human user. If one user blocks the other, the request fails and the DM isn't created. To
       * create a DM between the calling user and the calling app, set `Space.singleUserBotDm` to `true`
       * and don't specify any memberships. You can only use this method to set up a DM with the calling
       * app. To add the calling app as a member of a space or an existing DM between two human users,
       * see [create a membership](https://developers.google.com/chat/api/guides/v1/members/create). If
       * a DM already exists between two users, even when one user blocks the other at the time a
       * request is made, then the existing DM is returned. Spaces with threaded replies aren't
       * supported. If you receive the error message `ALREADY_EXISTS` when setting up a space, try a
       * different `displayName`. An existing space within the Google Workspace organization might
       * already use this display name. Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "spaces.setup".
       *
       * This request holds the parameters needed by the the chat server.  After setting any optional
       * parameters, call the {@link Setup#execute()} method to invoke the remote operation. <p> {@link
       * Setup#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.chat.v1.model.SetUpSpaceRequest}
       * @since 1.13
       */
      protected Setup(com.google.api.services.chat.v1.model.SetUpSpaceRequest content) {
        super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Space.class);
      }

      @Override
      public Setup set$Xgafv(java.lang.String $Xgafv) {
        return (Setup) super.set$Xgafv($Xgafv);
      }

      @Override
      public Setup setAccessToken(java.lang.String accessToken) {
        return (Setup) super.setAccessToken(accessToken);
      }

      @Override
      public Setup setAlt(java.lang.String alt) {
        return (Setup) super.setAlt(alt);
      }

      @Override
      public Setup setCallback(java.lang.String callback) {
        return (Setup) super.setCallback(callback);
      }

      @Override
      public Setup setFields(java.lang.String fields) {
        return (Setup) super.setFields(fields);
      }

      @Override
      public Setup setKey(java.lang.String key) {
        return (Setup) super.setKey(key);
      }

      @Override
      public Setup setOauthToken(java.lang.String oauthToken) {
        return (Setup) super.setOauthToken(oauthToken);
      }

      @Override
      public Setup setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Setup) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Setup setQuotaUser(java.lang.String quotaUser) {
        return (Setup) super.setQuotaUser(quotaUser);
      }

      @Override
      public Setup setUploadType(java.lang.String uploadType) {
        return (Setup) super.setUploadType(uploadType);
      }

      @Override
      public Setup setUploadProtocol(java.lang.String uploadProtocol) {
        return (Setup) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Setup set(String parameterName, Object value) {
        return (Setup) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Members collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Members.List request = chat.members().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Members members() {
      return new Members();
    }

    /**
     * The "members" collection of methods.
     */
    public class Members {

      /**
       * Creates a human membership or app membership for the calling app. Creating memberships for other
       * apps isn't supported. For an example, see [ Create a
       * membership](https://developers.google.com/chat/api/guides/v1/members/create). When creating a
       * membership, if the specified member has their auto-accept policy turned off, then they're
       * invited, and must accept the space invitation before joining. Otherwise, creating a membership
       * adds the member directly to the specified space. Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users). To specify the member
       * to add, set the `membership.member.name` in the `CreateMembershipRequest`: - To add the calling
       * app to a space or a direct message between two human users, use `users/app`. Unable to add other
       * apps to the space. - To add a human user, use `users/{user}`, where `{user}` can be the email
       * address for the user. For users in the same Workspace organization `{user}` can also be the
       * `{person_id}` for the person from the People API, or the `id` for the user in the Directory API.
       * For example, if the People API Person `resourceName` for `user@example.com` is
       * `people/123456789`, you can add the user to the space by setting the `membership.member.name` to
       * `users/user@example.com` or `users/123456789`.
       *
       * Create a request for the method "members.create".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the space for which to create the membership. Format: spaces/{space}
       * @param content the {@link com.google.api.services.chat.v1.model.Membership}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.chat.v1.model.Membership content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Membership> {

        private static final String REST_PATH = "v1/{+parent}/members";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Creates a human membership or app membership for the calling app. Creating memberships for
         * other apps isn't supported. For an example, see [ Create a
         * membership](https://developers.google.com/chat/api/guides/v1/members/create). When creating a
         * membership, if the specified member has their auto-accept policy turned off, then they're
         * invited, and must accept the space invitation before joining. Otherwise, creating a membership
         * adds the member directly to the specified space. Requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users). To specify the
         * member to add, set the `membership.member.name` in the `CreateMembershipRequest`: - To add the
         * calling app to a space or a direct message between two human users, use `users/app`. Unable to
         * add other apps to the space. - To add a human user, use `users/{user}`, where `{user}` can be
         * the email address for the user. For users in the same Workspace organization `{user}` can also
         * be the `{person_id}` for the person from the People API, or the `id` for the user in the
         * Directory API. For example, if the People API Person `resourceName` for `user@example.com` is
         * `people/123456789`, you can add the user to the space by setting the `membership.member.name`
         * to `users/user@example.com` or `users/123456789`.
         *
         * Create a request for the method "members.create".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the space for which to create the membership. Format: spaces/{space}
         * @param content the {@link com.google.api.services.chat.v1.model.Membership}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.chat.v1.model.Membership content) {
          super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Membership.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the space for which to create the membership. Format:
         * spaces/{space}
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the space for which to create the membership. Format: spaces/{space}
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the space for which to create the membership. Format:
         * spaces/{space}
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a membership. For an example, see [Delete a
       * membership](https://developers.google.com/chat/api/guides/v1/members/delete). Requires [user
       * authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "members.delete".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the membership to delete. Chat apps can delete human users' or their own
       *        memberships. Chat apps can't delete other apps' memberships. When deleting a human
       *        membership, requires the `chat.memberships` scope and `spaces/{space}/members/{member}`
       *        format. You can use the email as an alias for `{member}`. For example,
       *        `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the email of the
       *        Google Chat user. When deleting an app membership, requires the `chat.memberships.app`
       *        scope and `spaces/{space}/members/app` format. Format: `spaces/{space}/members/{member}`
       *        or `spaces/{space}/members/app`.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Membership> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/members/[^/]+$");

        /**
         * Deletes a membership. For an example, see [Delete a
         * membership](https://developers.google.com/chat/api/guides/v1/members/delete). Requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         *
         * Create a request for the method "members.delete".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the membership to delete. Chat apps can delete human users' or their own
       *        memberships. Chat apps can't delete other apps' memberships. When deleting a human
       *        membership, requires the `chat.memberships` scope and `spaces/{space}/members/{member}`
       *        format. You can use the email as an alias for `{member}`. For example,
       *        `spaces/{space}/members/example@gmail.com` where `example@gmail.com` is the email of the
       *        Google Chat user. When deleting an app membership, requires the `chat.memberships.app`
       *        scope and `spaces/{space}/members/app` format. Format: `spaces/{space}/members/{member}`
       *        or `spaces/{space}/members/app`.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(HangoutsChat.this, "DELETE", REST_PATH, null, com.google.api.services.chat.v1.model.Membership.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the membership to delete. Chat apps can delete human users' or
         * their own memberships. Chat apps can't delete other apps' memberships. When deleting a
         * human membership, requires the `chat.memberships` scope and
         * `spaces/{space}/members/{member}` format. You can use the email as an alias for
         * `{member}`. For example, `spaces/{space}/members/example@gmail.com` where
         * `example@gmail.com` is the email of the Google Chat user. When deleting an app
         * membership, requires the `chat.memberships.app` scope and `spaces/{space}/members/app`
         * format. Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the membership to delete. Chat apps can delete human users' or their own
       memberships. Chat apps can't delete other apps' memberships. When deleting a human membership,
       requires the `chat.memberships` scope and `spaces/{space}/members/{member}` format. You can use the
       email as an alias for `{member}`. For example, `spaces/{space}/members/example@gmail.com` where
       `example@gmail.com` is the email of the Google Chat user. When deleting an app membership, requires
       the `chat.memberships.app` scope and `spaces/{space}/members/app` format. Format:
       `spaces/{space}/members/{member}` or `spaces/{space}/members/app`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the membership to delete. Chat apps can delete human users' or
         * their own memberships. Chat apps can't delete other apps' memberships. When deleting a
         * human membership, requires the `chat.memberships` scope and
         * `spaces/{space}/members/{member}` format. You can use the email as an alias for
         * `{member}`. For example, `spaces/{space}/members/example@gmail.com` where
         * `example@gmail.com` is the email of the Google Chat user. When deleting an app
         * membership, requires the `chat.memberships.app` scope and `spaces/{space}/members/app`
         * format. Format: `spaces/{space}/members/{member}` or `spaces/{space}/members/app`.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns details about a membership. For an example, see [Get a
       * membership](https://developers.google.com/chat/api/guides/v1/members/get). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "members.get".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the membership to retrieve. To get the app's own membership, you can
       *        optionally use `spaces/{space}/members/app`. Format: `spaces/{space}/members/{member}` or
       *        `spaces/{space}/members/app` When [authenticated as a
       *        user](https://developers.google.com/chat/api/guides/auth/users), you can use the user's
       *        email as an alias for `{member}`. For example, `spaces/{space}/members/example@gmail.com`
       *        where `example@gmail.com` is the email of the Google Chat user.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Membership> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/members/[^/]+$");

        /**
         * Returns details about a membership. For an example, see [Get a
         * membership](https://developers.google.com/chat/api/guides/v1/members/get). Requires
         * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
         * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
         * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         *
         * Create a request for the method "members.get".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the membership to retrieve. To get the app's own membership, you can
       *        optionally use `spaces/{space}/members/app`. Format: `spaces/{space}/members/{member}` or
       *        `spaces/{space}/members/app` When [authenticated as a
       *        user](https://developers.google.com/chat/api/guides/auth/users), you can use the user's
       *        email as an alias for `{member}`. For example, `spaces/{space}/members/example@gmail.com`
       *        where `example@gmail.com` is the email of the Google Chat user.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Membership.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the membership to retrieve. To get the app's own membership,
         * you can optionally use `spaces/{space}/members/app`. Format:
         * `spaces/{space}/members/{member}` or `spaces/{space}/members/app` When [authenticated as
         * a user](https://developers.google.com/chat/api/guides/auth/users), you can use the user's
         * email as an alias for `{member}`. For example, `spaces/{space}/members/example@gmail.com`
         * where `example@gmail.com` is the email of the Google Chat user.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the membership to retrieve. To get the app's own membership, you can
       optionally use `spaces/{space}/members/app`. Format: `spaces/{space}/members/{member}` or
       `spaces/{space}/members/app` When [authenticated as a
       user](https://developers.google.com/chat/api/guides/auth/users), you can use the user's email as an
       alias for `{member}`. For example, `spaces/{space}/members/example@gmail.com` where
       `example@gmail.com` is the email of the Google Chat user.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the membership to retrieve. To get the app's own membership,
         * you can optionally use `spaces/{space}/members/app`. Format:
         * `spaces/{space}/members/{member}` or `spaces/{space}/members/app` When [authenticated as
         * a user](https://developers.google.com/chat/api/guides/auth/users), you can use the user's
         * email as an alias for `{member}`. For example, `spaces/{space}/members/example@gmail.com`
         * where `example@gmail.com` is the email of the Google Chat user.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/members/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists memberships in a space. For an example, see [List
       * memberships](https://developers.google.com/chat/api/guides/v1/members/list). Listing memberships
       * with [app authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
       * lists memberships in spaces that the Chat app has access to, but excludes Chat app memberships,
       * including its own. Listing memberships with [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users) lists memberships in
       * spaces that the authenticated user has access to. Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "members.list".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the space for which to fetch a membership list. Format:
       *        spaces/{space}
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListMembershipsResponse> {

        private static final String REST_PATH = "v1/{+parent}/members";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Lists memberships in a space. For an example, see [List
         * memberships](https://developers.google.com/chat/api/guides/v1/members/list). Listing
         * memberships with [app authentication](https://developers.google.com/chat/api/guides/auth
         * /service-accounts) lists memberships in spaces that the Chat app has access to, but excludes
         * Chat app memberships, including its own. Listing memberships with [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users) lists memberships in
         * spaces that the authenticated user has access to. Requires
         * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
         * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
         * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         *
         * Create a request for the method "members.list".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the space for which to fetch a membership list. Format:
       *        spaces/{space}
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListMembershipsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the space for which to fetch a membership list. Format:
         * spaces/{space}
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the space for which to fetch a membership list. Format:
       spaces/{space}
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the space for which to fetch a membership list. Format:
         * spaces/{space}
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional. A query filter. You can filter memberships by a member's role ([`role`](https:/
         * /developers.google.com/chat/api/reference/rest/v1/spaces.members#membershiprole)) and
         * type
         * ([`member.type`](https://developers.google.com/chat/api/reference/rest/v1/User#type)). To
         * filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`. To filter by type, set
         * `member.type` to `HUMAN` or `BOT`. To filter by both role and type, use the `AND`
         * operator. To filter by either role or type, use the `OR` operator. For example, the
         * following queries are valid: ``` role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
         * member.type = "HUMAN" AND role = "ROLE_MANAGER" ``` The following queries are invalid:
         * ``` member.type = "HUMAN" AND member.type = "BOT" role = "ROLE_MANAGER" AND role =
         * "ROLE_MEMBER" ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
         * error.
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** Optional. A query filter. You can filter memberships by a member's role
       ([`role`](https://developers.google.com/chat/api/reference/rest/v1/spaces.members#membershiprole))
       and type ([`member.type`](https://developers.google.com/chat/api/reference/rest/v1/User#type)). To
       filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`. To filter by type, set `member.type`
       to `HUMAN` or `BOT`. To filter by both role and type, use the `AND` operator. To filter by either
       role or type, use the `OR` operator. For example, the following queries are valid: ``` role =
       "ROLE_MANAGER" OR role = "ROLE_MEMBER" member.type = "HUMAN" AND role = "ROLE_MANAGER" ``` The
       following queries are invalid: ``` member.type = "HUMAN" AND member.type = "BOT" role =
       "ROLE_MANAGER" AND role = "ROLE_MEMBER" ``` Invalid queries are rejected by the server with an
       `INVALID_ARGUMENT` error.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * Optional. A query filter. You can filter memberships by a member's role ([`role`](https:/
         * /developers.google.com/chat/api/reference/rest/v1/spaces.members#membershiprole)) and
         * type
         * ([`member.type`](https://developers.google.com/chat/api/reference/rest/v1/User#type)). To
         * filter by role, set `role` to `ROLE_MEMBER` or `ROLE_MANAGER`. To filter by type, set
         * `member.type` to `HUMAN` or `BOT`. To filter by both role and type, use the `AND`
         * operator. To filter by either role or type, use the `OR` operator. For example, the
         * following queries are valid: ``` role = "ROLE_MANAGER" OR role = "ROLE_MEMBER"
         * member.type = "HUMAN" AND role = "ROLE_MANAGER" ``` The following queries are invalid:
         * ``` member.type = "HUMAN" AND member.type = "BOT" role = "ROLE_MANAGER" AND role =
         * "ROLE_MEMBER" ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
         * error.
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * Optional. The maximum number of memberships to return. The service might return fewer
         * than this value. If unspecified, at most 100 memberships are returned. The maximum value
         * is 1,000. If you use a value more than 1,000, it's automatically changed to 1,000.
         * Negative values return an `INVALID_ARGUMENT` error.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Optional. The maximum number of memberships to return. The service might return fewer than this
       value. If unspecified, at most 100 memberships are returned. The maximum value is 1,000. If you use
       a value more than 1,000, it's automatically changed to 1,000. Negative values return an
       `INVALID_ARGUMENT` error.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Optional. The maximum number of memberships to return. The service might return fewer
         * than this value. If unspecified, at most 100 memberships are returned. The maximum value
         * is 1,000. If you use a value more than 1,000, it's automatically changed to 1,000.
         * Negative values return an `INVALID_ARGUMENT` error.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Optional. A page token, received from a previous call to list memberships. Provide this
         * parameter to retrieve the subsequent page. When paginating, all other parameters provided
         * should match the call that provided the page token. Passing different values to the other
         * parameters might lead to unexpected results.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional. A page token, received from a previous call to list memberships. Provide this parameter
       to retrieve the subsequent page. When paginating, all other parameters provided should match the
       call that provided the page token. Passing different values to the other parameters might lead to
       unexpected results.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Optional. A page token, received from a previous call to list memberships. Provide this
         * parameter to retrieve the subsequent page. When paginating, all other parameters provided
         * should match the call that provided the page token. Passing different values to the other
         * parameters might lead to unexpected results.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Optional. When `true`, also returns memberships associated with invited members, in
         * addition to other types of memberships. If a filter is set, invited memberships that
         * don't match the filter criteria aren't returned. Currently requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean showInvited;

        /** Optional. When `true`, also returns memberships associated with invited members, in addition to
       other types of memberships. If a filter is set, invited memberships that don't match the filter
       criteria aren't returned. Currently requires [user
       authentication](https://developers.google.com/chat/api/guides/auth/users).
         */
        public java.lang.Boolean getShowInvited() {
          return showInvited;
        }

        /**
         * Optional. When `true`, also returns memberships associated with invited members, in
         * addition to other types of memberships. If a filter is set, invited memberships that
         * don't match the filter criteria aren't returned. Currently requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         */
        public List setShowInvited(java.lang.Boolean showInvited) {
          this.showInvited = showInvited;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Messages collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code HangoutsChat chat = new HangoutsChat(...);}
     *   {@code HangoutsChat.Messages.List request = chat.messages().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Messages messages() {
      return new Messages();
    }

    /**
     * The "messages" collection of methods.
     */
    public class Messages {

      /**
       * Creates a message in a Google Chat space. For an example, see [Create a
       * message](https://developers.google.com/chat/api/guides/v1/messages/create). Calling this method
       * requires [authentication](https://developers.google.com/chat/api/guides/auth) and supports the
       * following authentication types: - For text messages, user authentication or app authentication
       * are supported. - For card messages, only app authentication is supported. (Only Chat apps can
       * create card messages.)
       *
       * Create a request for the method "messages.create".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the space in which to create a message. Format: `spaces/{space}`
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+parent}/messages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Creates a message in a Google Chat space. For an example, see [Create a
         * message](https://developers.google.com/chat/api/guides/v1/messages/create). Calling this method
         * requires [authentication](https://developers.google.com/chat/api/guides/auth) and supports the
         * following authentication types: - For text messages, user authentication or app authentication
         * are supported. - For card messages, only app authentication is supported. (Only Chat apps can
         * create card messages.)
         *
         * Create a request for the method "messages.create".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the space in which to create a message. Format: `spaces/{space}`
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the space in which to create a message. Format:
         * `spaces/{space}`
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the space in which to create a message. Format: `spaces/{space}`
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the space in which to create a message. Format:
         * `spaces/{space}`
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional. A custom name for a Chat message assigned at creation. Must start with
         * `client-` and contain only lowercase letters, numbers, and hyphens up to 63 characters in
         * length. Specify this field to get, update, or delete the message with the specified
         * value. Assigning a custom name lets a a Chat app recall the message without saving the
         * message `name` from the [response body](/chat/api/reference/rest/v1/spaces.messages/get
         * #response-body) returned when creating the message. Assigning a custom name doesn't
         * replace the generated `name` field, the message's resource name. Instead, it sets the
         * custom name as the `clientAssignedMessageId` field, which you can reference while
         * processing later operations, like updating or deleting the message. For example usage,
         * see [Name a created message](https://developers.google.com/chat/api/guides/v1/messages/cr
         * eate#name_a_created_message).
         */
        @com.google.api.client.util.Key
        private java.lang.String messageId;

        /** Optional. A custom name for a Chat message assigned at creation. Must start with `client-` and
       contain only lowercase letters, numbers, and hyphens up to 63 characters in length. Specify this
       field to get, update, or delete the message with the specified value. Assigning a custom name lets
       a a Chat app recall the message without saving the message `name` from the [response
       body](/chat/api/reference/rest/v1/spaces.messages/get#response-body) returned when creating the
       message. Assigning a custom name doesn't replace the generated `name` field, the message's resource
       name. Instead, it sets the custom name as the `clientAssignedMessageId` field, which you can
       reference while processing later operations, like updating or deleting the message. For example
       usage, see [Name a created
       message](https://developers.google.com/chat/api/guides/v1/messages/create#name_a_created_message).
         */
        public java.lang.String getMessageId() {
          return messageId;
        }

        /**
         * Optional. A custom name for a Chat message assigned at creation. Must start with
         * `client-` and contain only lowercase letters, numbers, and hyphens up to 63 characters in
         * length. Specify this field to get, update, or delete the message with the specified
         * value. Assigning a custom name lets a a Chat app recall the message without saving the
         * message `name` from the [response body](/chat/api/reference/rest/v1/spaces.messages/get
         * #response-body) returned when creating the message. Assigning a custom name doesn't
         * replace the generated `name` field, the message's resource name. Instead, it sets the
         * custom name as the `clientAssignedMessageId` field, which you can reference while
         * processing later operations, like updating or deleting the message. For example usage,
         * see [Name a created message](https://developers.google.com/chat/api/guides/v1/messages/cr
         * eate#name_a_created_message).
         */
        public Create setMessageId(java.lang.String messageId) {
          this.messageId = messageId;
          return this;
        }

        /**
         * Optional. Specifies whether a message starts a thread or replies to one. Only supported
         * in named spaces.
         */
        @com.google.api.client.util.Key
        private java.lang.String messageReplyOption;

        /** Optional. Specifies whether a message starts a thread or replies to one. Only supported in named
       spaces.
         */
        public java.lang.String getMessageReplyOption() {
          return messageReplyOption;
        }

        /**
         * Optional. Specifies whether a message starts a thread or replies to one. Only supported
         * in named spaces.
         */
        public Create setMessageReplyOption(java.lang.String messageReplyOption) {
          this.messageReplyOption = messageReplyOption;
          return this;
        }

        /**
         * Optional. A unique request ID for this message. Specifying an existing request ID returns
         * the message created with that ID instead of creating a new message.
         */
        @com.google.api.client.util.Key
        private java.lang.String requestId;

        /** Optional. A unique request ID for this message. Specifying an existing request ID returns the
       message created with that ID instead of creating a new message.
         */
        public java.lang.String getRequestId() {
          return requestId;
        }

        /**
         * Optional. A unique request ID for this message. Specifying an existing request ID returns
         * the message created with that ID instead of creating a new message.
         */
        public Create setRequestId(java.lang.String requestId) {
          this.requestId = requestId;
          return this;
        }

        /**
         * Optional. Deprecated: Use thread.thread_key instead. ID for the thread. Supports up to
         * 4000 characters. To start or add to a thread, create a message and specify a `threadKey`
         * or the thread.name. For example usage, see [Start or reply to a message thread](https://d
         * evelopers.google.com/chat/api/guides/crudl/messages#start_or_reply_to_a_message_thread).
         */
        @com.google.api.client.util.Key
        private java.lang.String threadKey;

        /** Optional. Deprecated: Use thread.thread_key instead. ID for the thread. Supports up to 4000
       characters. To start or add to a thread, create a message and specify a `threadKey` or the
       thread.name. For example usage, see [Start or reply to a message thread](https://developers.google.
       com/chat/api/guides/crudl/messages#start_or_reply_to_a_message_thread).
         */
        public java.lang.String getThreadKey() {
          return threadKey;
        }

        /**
         * Optional. Deprecated: Use thread.thread_key instead. ID for the thread. Supports up to
         * 4000 characters. To start or add to a thread, create a message and specify a `threadKey`
         * or the thread.name. For example usage, see [Start or reply to a message thread](https://d
         * evelopers.google.com/chat/api/guides/crudl/messages#start_or_reply_to_a_message_thread).
         */
        public Create setThreadKey(java.lang.String threadKey) {
          this.threadKey = threadKey;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a message. For an example, see [Delete a
       * message](https://developers.google.com/chat/api/guides/v1/messages/delete). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users). Requests authenticated
       * with service accounts can only delete messages created by the calling Chat app.
       *
       * Create a request for the method "messages.delete".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the message that you want to delete, in the form `spaces/messages`
       *        Example: `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Deletes a message. For an example, see [Delete a
         * message](https://developers.google.com/chat/api/guides/v1/messages/delete). Requires
         * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
         * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
         * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users). Requests
         * authenticated with service accounts can only delete messages created by the calling Chat app.
         *
         * Create a request for the method "messages.delete".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the message that you want to delete, in the form `spaces/messages`
       *        Example: `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(HangoutsChat.this, "DELETE", REST_PATH, null, com.google.api.services.chat.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the message that you want to delete, in the form
         * `spaces/messages` Example: `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the message that you want to delete, in the form `spaces/messages`
       Example: `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the message that you want to delete, in the form
         * `spaces/messages` Example: `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * When `true`, deleting a message also deletes its threaded replies. When `false`, if a
         * message has threaded replies, deletion fails. Only applies when [authenticating as a
         * user](https://developers.google.com/chat/api/guides/auth/users). Has no effect when
         * [authenticating with a service account]
         * (https://developers.google.com/chat/api/guides/auth/service-accounts).
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean force;

        /** When `true`, deleting a message also deletes its threaded replies. When `false`, if a message has
       threaded replies, deletion fails. Only applies when [authenticating as a
       user](https://developers.google.com/chat/api/guides/auth/users). Has no effect when [authenticating
       with a service account] (https://developers.google.com/chat/api/guides/auth/service-accounts).
         */
        public java.lang.Boolean getForce() {
          return force;
        }

        /**
         * When `true`, deleting a message also deletes its threaded replies. When `false`, if a
         * message has threaded replies, deletion fails. Only applies when [authenticating as a
         * user](https://developers.google.com/chat/api/guides/auth/users). Has no effect when
         * [authenticating with a service account]
         * (https://developers.google.com/chat/api/guides/auth/service-accounts).
         */
        public Delete setForce(java.lang.Boolean force) {
          this.force = force;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns details about a message. For an example, see [Read a
       * message](https://developers.google.com/chat/api/guides/v1/messages/get). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users). Note: Might return a
       * message from a blocked member or space.
       *
       * Create a request for the method "messages.get".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. Resource name of the message to retrieve. Format: `spaces/{space}/messages/{message}` If
       *        the message begins with `client-`, then it has a custom name assigned by a Chat app that
       *        created it with the Chat REST API. That Chat app (but not others) can pass the custom name
       *        to get, update, or delete the message. To learn more, see [create and name a message]
       *        (https://developers.google.com/chat/api/guides/v1/messages/create#name_a_created_message).
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Returns details about a message. For an example, see [Read a
         * message](https://developers.google.com/chat/api/guides/v1/messages/get). Requires
         * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
         * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
         * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users). Note: Might return a
         * message from a blocked member or space.
         *
         * Create a request for the method "messages.get".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Resource name of the message to retrieve. Format: `spaces/{space}/messages/{message}` If
       *        the message begins with `client-`, then it has a custom name assigned by a Chat app that
       *        created it with the Chat REST API. That Chat app (but not others) can pass the custom name
       *        to get, update, or delete the message. To learn more, see [create and name a message]
       *        (https://developers.google.com/chat/api/guides/v1/messages/create#name_a_created_message).
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Resource name of the message to retrieve. Format:
         * `spaces/{space}/messages/{message}` If the message begins with `client-`, then it has a
         * custom name assigned by a Chat app that created it with the Chat REST API. That Chat app
         * (but not others) can pass the custom name to get, update, or delete the message. To learn
         * more, see [create and name a message] (https://developers.google.com/chat/api/guides/v1/m
         * essages/create#name_a_created_message).
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Resource name of the message to retrieve. Format: `spaces/{space}/messages/{message}` If
       the message begins with `client-`, then it has a custom name assigned by a Chat app that created it
       with the Chat REST API. That Chat app (but not others) can pass the custom name to get, update, or
       delete the message. To learn more, see [create and name a message]
       (https://developers.google.com/chat/api/guides/v1/messages/create#name_a_created_message).
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Resource name of the message to retrieve. Format:
         * `spaces/{space}/messages/{message}` If the message begins with `client-`, then it has a
         * custom name assigned by a Chat app that created it with the Chat REST API. That Chat app
         * (but not others) can pass the custom name to get, update, or delete the message. To learn
         * more, see [create and name a message] (https://developers.google.com/chat/api/guides/v1/m
         * essages/create#name_a_created_message).
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists messages in a space that the caller is a member of, including messages from blocked members
       * and spaces. For an example, see [List messages](/chat/api/guides/v1/messages/list). Requires
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users).
       *
       * Create a request for the method "messages.list".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the space to list messages from. Format: `spaces/{space}`
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListMessagesResponse> {

        private static final String REST_PATH = "v1/{+parent}/messages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+$");

        /**
         * Lists messages in a space that the caller is a member of, including messages from blocked
         * members and spaces. For an example, see [List messages](/chat/api/guides/v1/messages/list).
         * Requires [user authentication](https://developers.google.com/chat/api/guides/auth/users).
         *
         * Create a request for the method "messages.list".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the space to list messages from. Format: `spaces/{space}`
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListMessagesResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the space to list messages from. Format: `spaces/{space}`
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the space to list messages from. Format: `spaces/{space}`
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the space to list messages from. Format: `spaces/{space}`
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^spaces/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * A query filter. You can filter messages by date (`create_time`) and thread
         * (`thread.name`). To filter messages by the date they were created, specify the
         * `create_time` with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
         * format and double quotation marks. For example, `"2023-04-21T11:30:00-04:00"`. You can
         * use the greater than operator `>` to list messages that were created after a timestamp,
         * or the less than operator `<` to list messages that were created before a timestamp. To
         * filter messages within a time interval, use the `AND` operator between two timestamps. To
         * filter by thread, specify the `thread.name`, formatted as
         * `spaces/{space}/threads/{thread}`. You can only specify one `thread.name` per query. To
         * filter by both thread and date, use the `AND` operator in your query. For example, the
         * following queries are valid: ``` create_time > "2012-04-21T11:30:00-04:00" create_time >
         * "2012-04-21T11:30:00-04:00" AND thread.name = spaces/AAAAAAAAAAA/threads/123 create_time
         * > "2012-04-21T11:30:00+00:00" AND create_time < "2013-01-01T00:00:00+00:00" AND
         * thread.name = spaces/AAAAAAAAAAA/threads/123 thread.name = spaces/AAAAAAAAAAA/threads/123
         * ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT` error.
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A query filter. You can filter messages by date (`create_time`) and thread (`thread.name`). To
       filter messages by the date they were created, specify the `create_time` with a timestamp in
       [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and double quotation marks. For example,
       `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to list messages that were
       created after a timestamp, or the less than operator `<` to list messages that were created before
       a timestamp. To filter messages within a time interval, use the `AND` operator between two
       timestamps. To filter by thread, specify the `thread.name`, formatted as
       `spaces/{space}/threads/{thread}`. You can only specify one `thread.name` per query. To filter by
       both thread and date, use the `AND` operator in your query. For example, the following queries are
       valid: ``` create_time > "2012-04-21T11:30:00-04:00" create_time > "2012-04-21T11:30:00-04:00" AND
       thread.name = spaces/AAAAAAAAAAA/threads/123 create_time > "2012-04-21T11:30:00+00:00" AND
       create_time < "2013-01-01T00:00:00+00:00" AND thread.name = spaces/AAAAAAAAAAA/threads/123
       thread.name = spaces/AAAAAAAAAAA/threads/123 ``` Invalid queries are rejected by the server with an
       `INVALID_ARGUMENT` error.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A query filter. You can filter messages by date (`create_time`) and thread
         * (`thread.name`). To filter messages by the date they were created, specify the
         * `create_time` with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
         * format and double quotation marks. For example, `"2023-04-21T11:30:00-04:00"`. You can
         * use the greater than operator `>` to list messages that were created after a timestamp,
         * or the less than operator `<` to list messages that were created before a timestamp. To
         * filter messages within a time interval, use the `AND` operator between two timestamps. To
         * filter by thread, specify the `thread.name`, formatted as
         * `spaces/{space}/threads/{thread}`. You can only specify one `thread.name` per query. To
         * filter by both thread and date, use the `AND` operator in your query. For example, the
         * following queries are valid: ``` create_time > "2012-04-21T11:30:00-04:00" create_time >
         * "2012-04-21T11:30:00-04:00" AND thread.name = spaces/AAAAAAAAAAA/threads/123 create_time
         * > "2012-04-21T11:30:00+00:00" AND create_time < "2013-01-01T00:00:00+00:00" AND
         * thread.name = spaces/AAAAAAAAAAA/threads/123 thread.name = spaces/AAAAAAAAAAA/threads/123
         * ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT` error.
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * Optional, if resuming from a previous query. How the list of messages is ordered. Specify
         * a value to order by an ordering operation. Valid ordering operation values are as
         * follows: - `ASC` for ascending. - `DESC` for descending. The default ordering is
         * `create_time ASC`.
         */
        @com.google.api.client.util.Key
        private java.lang.String orderBy;

        /** Optional, if resuming from a previous query. How the list of messages is ordered. Specify a value
       to order by an ordering operation. Valid ordering operation values are as follows: - `ASC` for
       ascending. - `DESC` for descending. The default ordering is `create_time ASC`.
         */
        public java.lang.String getOrderBy() {
          return orderBy;
        }

        /**
         * Optional, if resuming from a previous query. How the list of messages is ordered. Specify
         * a value to order by an ordering operation. Valid ordering operation values are as
         * follows: - `ASC` for ascending. - `DESC` for descending. The default ordering is
         * `create_time ASC`.
         */
        public List setOrderBy(java.lang.String orderBy) {
          this.orderBy = orderBy;
          return this;
        }

        /**
         * The maximum number of messages returned. The service might return fewer messages than
         * this value. If unspecified, at most 25 are returned. The maximum value is 1,000. If you
         * use a value more than 1,000, it's automatically changed to 1,000. Negative values return
         * an `INVALID_ARGUMENT` error.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of messages returned. The service might return fewer messages than this value.
       If unspecified, at most 25 are returned. The maximum value is 1,000. If you use a value more than
       1,000, it's automatically changed to 1,000. Negative values return an `INVALID_ARGUMENT` error.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of messages returned. The service might return fewer messages than
         * this value. If unspecified, at most 25 are returned. The maximum value is 1,000. If you
         * use a value more than 1,000, it's automatically changed to 1,000. Negative values return
         * an `INVALID_ARGUMENT` error.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Optional, if resuming from a previous query. A page token received from a previous list
         * messages call. Provide this parameter to retrieve the subsequent page. When paginating,
         * all other parameters provided should match the call that provided the page token. Passing
         * different values to the other parameters might lead to unexpected results.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional, if resuming from a previous query. A page token received from a previous list messages
       call. Provide this parameter to retrieve the subsequent page. When paginating, all other parameters
       provided should match the call that provided the page token. Passing different values to the other
       parameters might lead to unexpected results.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Optional, if resuming from a previous query. A page token received from a previous list
         * messages call. Provide this parameter to retrieve the subsequent page. When paginating,
         * all other parameters provided should match the call that provided the page token. Passing
         * different values to the other parameters might lead to unexpected results.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Whether to include deleted messages. Deleted messages include deleted time and metadata
         * about their deletion, but message content is unavailable.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean showDeleted;

        /** Whether to include deleted messages. Deleted messages include deleted time and metadata about their
       deletion, but message content is unavailable.
         */
        public java.lang.Boolean getShowDeleted() {
          return showDeleted;
        }

        /**
         * Whether to include deleted messages. Deleted messages include deleted time and metadata
         * about their deletion, but message content is unavailable.
         */
        public List setShowDeleted(java.lang.Boolean showDeleted) {
          this.showDeleted = showDeleted;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a message. There's a difference between the `patch` and `update` methods. The `patch`
       * method uses a `patch` request while the `update` method uses a `put` request. We recommend using
       * the `patch` method. For an example, see [Update a
       * message](https://developers.google.com/chat/api/guides/v1/messages/update). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users). Requests authenticated
       * with service accounts can only update messages created by the calling Chat app.
       *
       * Create a request for the method "messages.patch".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Resource name in the form `spaces/messages`. Example:
       *        `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Updates a message. There's a difference between the `patch` and `update` methods. The `patch`
         * method uses a `patch` request while the `update` method uses a `put` request. We recommend
         * using the `patch` method. For an example, see [Update a
         * message](https://developers.google.com/chat/api/guides/v1/messages/update). Requires
         * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
         * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
         * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users). Requests
         * authenticated with service accounts can only update messages created by the calling Chat app.
         *
         * Create a request for the method "messages.patch".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name in the form `spaces/messages`. Example:
       *        `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "PATCH", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Resource name in the form `spaces/messages`. Example:
         * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name in the form `spaces/messages`. Example:
       `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Resource name in the form `spaces/messages`. Example:
         * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. If `true` and the message isn't found, a new message is created and
         * `updateMask` is ignored. The specified message ID must be [client-assigned](https://devel
         * opers.google.com/chat/api/guides/v1/messages/create#name_a_created_message) or the
         * request fails.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean allowMissing;

        /** Optional. If `true` and the message isn't found, a new message is created and `updateMask` is
       ignored. The specified message ID must be [client-
       assigned](https://developers.google.com/chat/api/guides/v1/messages/create#name_a_created_message)
       or the request fails.
         */
        public java.lang.Boolean getAllowMissing() {
          return allowMissing;
        }

        /**
         * Optional. If `true` and the message isn't found, a new message is created and
         * `updateMask` is ignored. The specified message ID must be [client-assigned](https://devel
         * opers.google.com/chat/api/guides/v1/messages/create#name_a_created_message) or the
         * request fails.
         */
        public Patch setAllowMissing(java.lang.Boolean allowMissing) {
          this.allowMissing = allowMissing;
          return this;
        }

        /**
         * Required. The field paths to update. Separate multiple values with commas. Currently
         * supported field paths: - `text` - `attachment` - `cards` (Requires [service account
         * authentication](/chat/api/guides/auth/service-accounts).) - `cards_v2` (Requires [service
         * account authentication](/chat/api/guides/auth/service-accounts).)
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The field paths to update. Separate multiple values with commas. Currently supported
       field paths: - `text` - `attachment` - `cards` (Requires [service account
       authentication](/chat/api/guides/auth/service-accounts).) - `cards_v2` (Requires [service account
       authentication](/chat/api/guides/auth/service-accounts).)
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The field paths to update. Separate multiple values with commas. Currently
         * supported field paths: - `text` - `attachment` - `cards` (Requires [service account
         * authentication](/chat/api/guides/auth/service-accounts).) - `cards_v2` (Requires [service
         * account authentication](/chat/api/guides/auth/service-accounts).)
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates a message. There's a difference between the `patch` and `update` methods. The `patch`
       * method uses a `patch` request while the `update` method uses a `put` request. We recommend using
       * the `patch` method. For an example, see [Update a
       * message](https://developers.google.com/chat/api/guides/v1/messages/update). Requires
       * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
       * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts) and
       * [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
       * authentication](https://developers.google.com/chat/api/guides/auth/users). Requests authenticated
       * with service accounts can only update messages created by the calling Chat app.
       *
       * Create a request for the method "messages.update".
       *
       * This request holds the parameters needed by the chat server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param name Resource name in the form `spaces/messages`. Example:
       *        `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
       * @param content the {@link com.google.api.services.chat.v1.model.Message}
       * @return the request
       */
      public Update update(java.lang.String name, com.google.api.services.chat.v1.model.Message content) throws java.io.IOException {
        Update result = new Update(name, content);
        initialize(result);
        return result;
      }

      public class Update extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Message> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

        /**
         * Updates a message. There's a difference between the `patch` and `update` methods. The `patch`
         * method uses a `patch` request while the `update` method uses a `put` request. We recommend
         * using the `patch` method. For an example, see [Update a
         * message](https://developers.google.com/chat/api/guides/v1/messages/update). Requires
         * [authentication](https://developers.google.com/chat/api/guides/auth). Fully supports [service
         * account authentication](https://developers.google.com/chat/api/guides/auth/service-accounts)
         * and [user authentication](https://developers.google.com/chat/api/guides/auth/users). [User
         * authentication](https://developers.google.com/chat/api/guides/auth/users). Requests
         * authenticated with service accounts can only update messages created by the calling Chat app.
         *
         * Create a request for the method "messages.update".
         *
         * This request holds the parameters needed by the the chat server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name in the form `spaces/messages`. Example:
       *        `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         * @param content the {@link com.google.api.services.chat.v1.model.Message}
         * @since 1.13
         */
        protected Update(java.lang.String name, com.google.api.services.chat.v1.model.Message content) {
          super(HangoutsChat.this, "PUT", REST_PATH, content, com.google.api.services.chat.v1.model.Message.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Resource name in the form `spaces/messages`. Example:
         * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name in the form `spaces/messages`. Example:
       `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Resource name in the form `spaces/messages`. Example:
         * `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`
         */
        public Update setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^spaces/[^/]+/messages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. If `true` and the message isn't found, a new message is created and
         * `updateMask` is ignored. The specified message ID must be [client-assigned](https://devel
         * opers.google.com/chat/api/guides/v1/messages/create#name_a_created_message) or the
         * request fails.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean allowMissing;

        /** Optional. If `true` and the message isn't found, a new message is created and `updateMask` is
       ignored. The specified message ID must be [client-
       assigned](https://developers.google.com/chat/api/guides/v1/messages/create#name_a_created_message)
       or the request fails.
         */
        public java.lang.Boolean getAllowMissing() {
          return allowMissing;
        }

        /**
         * Optional. If `true` and the message isn't found, a new message is created and
         * `updateMask` is ignored. The specified message ID must be [client-assigned](https://devel
         * opers.google.com/chat/api/guides/v1/messages/create#name_a_created_message) or the
         * request fails.
         */
        public Update setAllowMissing(java.lang.Boolean allowMissing) {
          this.allowMissing = allowMissing;
          return this;
        }

        /**
         * Required. The field paths to update. Separate multiple values with commas. Currently
         * supported field paths: - `text` - `attachment` - `cards` (Requires [service account
         * authentication](/chat/api/guides/auth/service-accounts).) - `cards_v2` (Requires [service
         * account authentication](/chat/api/guides/auth/service-accounts).)
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The field paths to update. Separate multiple values with commas. Currently supported
       field paths: - `text` - `attachment` - `cards` (Requires [service account
       authentication](/chat/api/guides/auth/service-accounts).) - `cards_v2` (Requires [service account
       authentication](/chat/api/guides/auth/service-accounts).)
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The field paths to update. Separate multiple values with commas. Currently
         * supported field paths: - `text` - `attachment` - `cards` (Requires [service account
         * authentication](/chat/api/guides/auth/service-accounts).) - `cards_v2` (Requires [service
         * account authentication](/chat/api/guides/auth/service-accounts).)
         */
        public Update setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Attachments collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code HangoutsChat chat = new HangoutsChat(...);}
       *   {@code HangoutsChat.Attachments.List request = chat.attachments().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Attachments attachments() {
        return new Attachments();
      }

      /**
       * The "attachments" collection of methods.
       */
      public class Attachments {

        /**
         * Gets the metadata of a message attachment. The attachment data is fetched using the [media
         * API](https://developers.google.com/chat/api/reference/rest/v1/media/download). For an example,
         * see [Get a message attachment](https://developers.google.com/chat/api/guides/v1/media-and-
         * attachments/get). Requires [service account
         * authentication](https://developers.google.com/chat/api/guides/auth/service-accounts).
         *
         * Create a request for the method "attachments.get".
         *
         * This request holds the parameters needed by the chat server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Resource name of the attachment, in the form `spaces/messages/attachments`.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Attachment> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");

          /**
           * Gets the metadata of a message attachment. The attachment data is fetched using the [media
           * API](https://developers.google.com/chat/api/reference/rest/v1/media/download). For an example,
           * see [Get a message attachment](https://developers.google.com/chat/api/guides/v1/media-and-
           * attachments/get). Requires [service account
           * authentication](https://developers.google.com/chat/api/guides/auth/service-accounts).
           *
           * Create a request for the method "attachments.get".
           *
           * This request holds the parameters needed by the the chat server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Resource name of the attachment, in the form `spaces/messages/attachments`.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Attachment.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Resource name of the attachment, in the form `spaces/messages/attachments`.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Resource name of the attachment, in the form `spaces/messages/attachments`.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Resource name of the attachment, in the form `spaces/messages/attachments`.
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Reactions collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code HangoutsChat chat = new HangoutsChat(...);}
       *   {@code HangoutsChat.Reactions.List request = chat.reactions().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Reactions reactions() {
        return new Reactions();
      }

      /**
       * The "reactions" collection of methods.
       */
      public class Reactions {

        /**
         * Creates a reaction and adds it to a message. For an example, see [Create a
         * reaction](https://developers.google.com/chat/api/guides/v1/reactions/create). Requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users). Only unicode emoji are
         * supported.
         *
         * Create a request for the method "reactions.create".
         *
         * This request holds the parameters needed by the chat server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The message where the reaction is created. Format: `spaces/{space}/messages/{message}`
         * @param content the {@link com.google.api.services.chat.v1.model.Reaction}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.chat.v1.model.Reaction content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Reaction> {

          private static final String REST_PATH = "v1/{+parent}/reactions";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

          /**
           * Creates a reaction and adds it to a message. For an example, see [Create a
           * reaction](https://developers.google.com/chat/api/guides/v1/reactions/create). Requires [user
           * authentication](https://developers.google.com/chat/api/guides/auth/users). Only unicode emoji
           * are supported.
           *
           * Create a request for the method "reactions.create".
           *
           * This request holds the parameters needed by the the chat server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The message where the reaction is created. Format: `spaces/{space}/messages/{message}`
           * @param content the {@link com.google.api.services.chat.v1.model.Reaction}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.chat.v1.model.Reaction content) {
            super(HangoutsChat.this, "POST", REST_PATH, content, com.google.api.services.chat.v1.model.Reaction.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The message where the reaction is created. Format:
           * `spaces/{space}/messages/{message}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The message where the reaction is created. Format: `spaces/{space}/messages/{message}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The message where the reaction is created. Format:
           * `spaces/{space}/messages/{message}`
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a reaction to a message. For an example, see [Delete a
         * reaction](https://developers.google.com/chat/api/guides/v1/reactions/delete). Requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         *
         * Create a request for the method "reactions.delete".
         *
         * This request holds the parameters needed by the chat server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the reaction to delete. Format:
         *        `spaces/{space}/messages/{message}/reactions/{reaction}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+/reactions/[^/]+$");

          /**
           * Deletes a reaction to a message. For an example, see [Delete a
           * reaction](https://developers.google.com/chat/api/guides/v1/reactions/delete). Requires [user
           * authentication](https://developers.google.com/chat/api/guides/auth/users).
           *
           * Create a request for the method "reactions.delete".
           *
           * This request holds the parameters needed by the the chat server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the reaction to delete. Format:
         *        `spaces/{space}/messages/{message}/reactions/{reaction}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(HangoutsChat.this, "DELETE", REST_PATH, null, com.google.api.services.chat.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+/reactions/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Name of the reaction to delete. Format:
           * `spaces/{space}/messages/{message}/reactions/{reaction}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the reaction to delete. Format:
         `spaces/{space}/messages/{message}/reactions/{reaction}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Name of the reaction to delete. Format:
           * `spaces/{space}/messages/{message}/reactions/{reaction}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+/reactions/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Lists reactions to a message. For an example, see [List
         * reactions](https://developers.google.com/chat/api/guides/v1/reactions/list). Requires [user
         * authentication](https://developers.google.com/chat/api/guides/auth/users).
         *
         * Create a request for the method "reactions.list".
         *
         * This request holds the parameters needed by the chat server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The message users reacted to. Format: `spaces/{space}/messages/{message}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends HangoutsChatRequest<com.google.api.services.chat.v1.model.ListReactionsResponse> {

          private static final String REST_PATH = "v1/{+parent}/reactions";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^spaces/[^/]+/messages/[^/]+$");

          /**
           * Lists reactions to a message. For an example, see [List
           * reactions](https://developers.google.com/chat/api/guides/v1/reactions/list). Requires [user
           * authentication](https://developers.google.com/chat/api/guides/auth/users).
           *
           * Create a request for the method "reactions.list".
           *
           * This request holds the parameters needed by the the chat server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The message users reacted to. Format: `spaces/{space}/messages/{message}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.ListReactionsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The message users reacted to. Format: `spaces/{space}/messages/{message}`
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The message users reacted to. Format: `spaces/{space}/messages/{message}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The message users reacted to. Format: `spaces/{space}/messages/{message}`
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^spaces/[^/]+/messages/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Optional. A query filter. You can filter reactions by
           * [emoji](https://developers.google.com/chat/api/reference/rest/v1/Emoji) (either
           * `emoji.unicode` or `emoji.custom_emoji.uid`) and
           * [user](https://developers.google.com/chat/api/reference/rest/v1/User) (`user.name`). To
           * filter reactions for multiple emojis or users, join similar fields with the `OR`
           * operator, such as `emoji.unicode = "🙂" OR emoji.unicode = "👍"` and `user.name =
           * "users/AAAAAA" OR user.name = "users/BBBBBB"`. To filter reactions by emoji and user,
           * use the `AND` operator, such as `emoji.unicode = "🙂" AND user.name = "users/AAAAAA"`.
           * If your query uses both `AND` and `OR`, group them with parentheses. For example, the
           * following queries are valid: ``` user.name = "users/{user}" emoji.unicode = "🙂"
           * emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" OR emoji.unicode = "👍"
           * emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" AND
           * user.name = "users/{user}" (emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}")
           * AND user.name = "users/{user}" ``` The following queries are invalid: ``` emoji.unicode
           * = "🙂" AND emoji.unicode = "👍" emoji.unicode = "🙂" AND emoji.custom_emoji.uid = "{uid}"
           * emoji.unicode = "🙂" OR user.name = "users/{user}" emoji.unicode = "🙂" OR
           * emoji.custom_emoji.uid = "{uid}" OR user.name = "users/{user}" emoji.unicode = "🙂" OR
           * emoji.custom_emoji.uid = "{uid}" AND user.name = "users/{user}" ``` Invalid queries are
           * rejected by the server with an `INVALID_ARGUMENT` error.
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. A query filter. You can filter reactions by
         [emoji](https://developers.google.com/chat/api/reference/rest/v1/Emoji) (either `emoji.unicode` or
         `emoji.custom_emoji.uid`) and [user](https://developers.google.com/chat/api/reference/rest/v1/User)
         (`user.name`). To filter reactions for multiple emojis or users, join similar fields with the `OR`
         operator, such as `emoji.unicode = "🙂" OR emoji.unicode = "👍"` and `user.name = "users/AAAAAA" OR
         user.name = "users/BBBBBB"`. To filter reactions by emoji and user, use the `AND` operator, such as
         `emoji.unicode = "🙂" AND user.name = "users/AAAAAA"`. If your query uses both `AND` and `OR`, group
         them with parentheses. For example, the following queries are valid: ``` user.name = "users/{user}"
         emoji.unicode = "🙂" emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" OR emoji.unicode = "👍"
         emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" AND user.name =
         "users/{user}" (emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}") AND user.name =
         "users/{user}" ``` The following queries are invalid: ``` emoji.unicode = "🙂" AND emoji.unicode =
         "👍" emoji.unicode = "🙂" AND emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" OR user.name =
         "users/{user}" emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}" OR user.name =
         "users/{user}" emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}" AND user.name =
         "users/{user}" ``` Invalid queries are rejected by the server with an `INVALID_ARGUMENT` error.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. A query filter. You can filter reactions by
           * [emoji](https://developers.google.com/chat/api/reference/rest/v1/Emoji) (either
           * `emoji.unicode` or `emoji.custom_emoji.uid`) and
           * [user](https://developers.google.com/chat/api/reference/rest/v1/User) (`user.name`). To
           * filter reactions for multiple emojis or users, join similar fields with the `OR`
           * operator, such as `emoji.unicode = "🙂" OR emoji.unicode = "👍"` and `user.name =
           * "users/AAAAAA" OR user.name = "users/BBBBBB"`. To filter reactions by emoji and user,
           * use the `AND` operator, such as `emoji.unicode = "🙂" AND user.name = "users/AAAAAA"`.
           * If your query uses both `AND` and `OR`, group them with parentheses. For example, the
           * following queries are valid: ``` user.name = "users/{user}" emoji.unicode = "🙂"
           * emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" OR emoji.unicode = "👍"
           * emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}" emoji.unicode = "🙂" AND
           * user.name = "users/{user}" (emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}")
           * AND user.name = "users/{user}" ``` The following queries are invalid: ``` emoji.unicode
           * = "🙂" AND emoji.unicode = "👍" emoji.unicode = "🙂" AND emoji.custom_emoji.uid = "{uid}"
           * emoji.unicode = "🙂" OR user.name = "users/{user}" emoji.unicode = "🙂" OR
           * emoji.custom_emoji.uid = "{uid}" OR user.name = "users/{user}" emoji.unicode = "🙂" OR
           * emoji.custom_emoji.uid = "{uid}" AND user.name = "users/{user}" ``` Invalid queries are
           * rejected by the server with an `INVALID_ARGUMENT` error.
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. The maximum number of reactions returned. The service can return fewer
           * reactions than this value. If unspecified, the default value is 25. The maximum value
           * is 200; values above 200 are changed to 200.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. The maximum number of reactions returned. The service can return fewer reactions than
         this value. If unspecified, the default value is 25. The maximum value is 200; values above 200 are
         changed to 200.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * Optional. The maximum number of reactions returned. The service can return fewer
           * reactions than this value. If unspecified, the default value is 25. The maximum value
           * is 200; values above 200 are changed to 200.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. (If resuming from a previous query.) A page token received from a previous
           * list reactions call. Provide this to retrieve the subsequent page. When paginating, the
           * filter value should match the call that provided the page token. Passing a different
           * value might lead to unexpected results.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. (If resuming from a previous query.) A page token received from a previous list reactions
         call. Provide this to retrieve the subsequent page. When paginating, the filter value should match
         the call that provided the page token. Passing a different value might lead to unexpected results.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. (If resuming from a previous query.) A page token received from a previous
           * list reactions call. Provide this to retrieve the subsequent page. When paginating, the
           * filter value should match the call that provided the page token. Passing a different
           * value might lead to unexpected results.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link HangoutsChat}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link HangoutsChat}. */
    @Override
    public HangoutsChat build() {
      return new HangoutsChat(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link HangoutsChatRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setHangoutsChatRequestInitializer(
        HangoutsChatRequestInitializer hangoutschatRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(hangoutschatRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
