/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Model definition for AttachmentDataRef.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AttachmentDataRef extends com.google.api.client.json.GenericJson {

  /**
   * Opaque token containing a reference to an uploaded attachment. Treated by clients as an opaque
   * string and used to create or update Chat messages with attachments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attachmentUploadToken;

  /**
   * The resource name of the attachment data. This field is used with the media API to download the
   * attachment data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceName;

  /**
   * Opaque token containing a reference to an uploaded attachment. Treated by clients as an opaque
   * string and used to create or update Chat messages with attachments.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttachmentUploadToken() {
    return attachmentUploadToken;
  }

  /**
   * Opaque token containing a reference to an uploaded attachment. Treated by clients as an opaque
   * string and used to create or update Chat messages with attachments.
   * @param attachmentUploadToken attachmentUploadToken or {@code null} for none
   */
  public AttachmentDataRef setAttachmentUploadToken(java.lang.String attachmentUploadToken) {
    this.attachmentUploadToken = attachmentUploadToken;
    return this;
  }

  /**
   * The resource name of the attachment data. This field is used with the media API to download the
   * attachment data.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceName() {
    return resourceName;
  }

  /**
   * The resource name of the attachment data. This field is used with the media API to download the
   * attachment data.
   * @param resourceName resourceName or {@code null} for none
   */
  public AttachmentDataRef setResourceName(java.lang.String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  @Override
  public AttachmentDataRef set(String fieldName, Object value) {
    return (AttachmentDataRef) super.set(fieldName, value);
  }

  @Override
  public AttachmentDataRef clone() {
    return (AttachmentDataRef) super.clone();
  }

}
