/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A [card](https://developers.google.com/chat/api/reference/rest/v1/cards) in a Google Chat
 * message. Only Chat apps can create cards. If your Chat app [authenticates as a
 * user](https://developers.google.com/chat/api/guides/auth/users), the message can't contain cards.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CardWithId extends com.google.api.client.json.GenericJson {

  /**
   * A card. Maximum size is 32 KB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Card card;

  /**
   * Required if the message contains multiple cards. A unique identifier for a card in a message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cardId;

  /**
   * A card. Maximum size is 32 KB.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Card getCard() {
    return card;
  }

  /**
   * A card. Maximum size is 32 KB.
   * @param card card or {@code null} for none
   */
  public CardWithId setCard(GoogleAppsCardV1Card card) {
    this.card = card;
    return this;
  }

  /**
   * Required if the message contains multiple cards. A unique identifier for a card in a message.
   * @return value or {@code null} for none
   */
  public java.lang.String getCardId() {
    return cardId;
  }

  /**
   * Required if the message contains multiple cards. A unique identifier for a card in a message.
   * @param cardId cardId or {@code null} for none
   */
  public CardWithId setCardId(java.lang.String cardId) {
    this.cardId = cardId;
    return this;
  }

  @Override
  public CardWithId set(String fieldName, Object value) {
    return (CardWithId) super.set(fieldName, value);
  }

  @Override
  public CardWithId clone() {
    return (CardWithId) super.clone();
  }

}
