/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Chat apps only. For a `SelectionInput` widget that uses a multi-select menu, a data source from
 * Google Chat. For example, a list of Google Chat spaces of which the user is a member. [Developer
 * Preview](https://developers.google.com/workspace/preview).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChatClientDataSourceMarkup extends com.google.api.client.json.GenericJson {

  /**
   * A data source representing a Google Chat space. Format: spaces/{space} [Developer
   * Preview](https://developers.google.com/workspace/preview).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpaceDataSource spaceDataSource;

  /**
   * A data source representing a Google Chat space. Format: spaces/{space} [Developer
   * Preview](https://developers.google.com/workspace/preview).
   * @return value or {@code null} for none
   */
  public SpaceDataSource getSpaceDataSource() {
    return spaceDataSource;
  }

  /**
   * A data source representing a Google Chat space. Format: spaces/{space} [Developer
   * Preview](https://developers.google.com/workspace/preview).
   * @param spaceDataSource spaceDataSource or {@code null} for none
   */
  public ChatClientDataSourceMarkup setSpaceDataSource(SpaceDataSource spaceDataSource) {
    this.spaceDataSource = spaceDataSource;
    return this;
  }

  @Override
  public ChatClientDataSourceMarkup set(String fieldName, Object value) {
    return (ChatClientDataSourceMarkup) super.set(fieldName, value);
  }

  @Override
  public ChatClientDataSourceMarkup clone() {
    return (ChatClientDataSourceMarkup) super.clone();
  }

}
