/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A persistent (sticky) footer that that appears at the bottom of the card. For an example in
 * Google Chat apps, see [Card footer](https://developers.google.com/chat/ui/widgets/card-fixed-
 * footer). Setting `fixedFooter` without specifying a `primaryButton` or a `secondaryButton` causes
 * an error. Supported by Google Workspace Add-ons and Chat apps. For Chat apps, you can use fixed
 * footers in [dialogs](https://developers.google.com/chat/how-tos/dialogs), but not [card
 * messages](https://developers.google.com/chat/api/guides/message-formats/cards).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1CardFixedFooter extends com.google.api.client.json.GenericJson {

  /**
   * The primary button of the fixed footer. The button must be a text button with text and color
   * set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Button primaryButton;

  /**
   * The secondary button of the fixed footer. The button must be a text button with text and color
   * set. If `secondaryButton` is set, you must also set `primaryButton`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Button secondaryButton;

  /**
   * The primary button of the fixed footer. The button must be a text button with text and color
   * set.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Button getPrimaryButton() {
    return primaryButton;
  }

  /**
   * The primary button of the fixed footer. The button must be a text button with text and color
   * set.
   * @param primaryButton primaryButton or {@code null} for none
   */
  public GoogleAppsCardV1CardFixedFooter setPrimaryButton(GoogleAppsCardV1Button primaryButton) {
    this.primaryButton = primaryButton;
    return this;
  }

  /**
   * The secondary button of the fixed footer. The button must be a text button with text and color
   * set. If `secondaryButton` is set, you must also set `primaryButton`.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Button getSecondaryButton() {
    return secondaryButton;
  }

  /**
   * The secondary button of the fixed footer. The button must be a text button with text and color
   * set. If `secondaryButton` is set, you must also set `primaryButton`.
   * @param secondaryButton secondaryButton or {@code null} for none
   */
  public GoogleAppsCardV1CardFixedFooter setSecondaryButton(GoogleAppsCardV1Button secondaryButton) {
    this.secondaryButton = secondaryButton;
    return this;
  }

  @Override
  public GoogleAppsCardV1CardFixedFooter set(String fieldName, Object value) {
    return (GoogleAppsCardV1CardFixedFooter) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1CardFixedFooter clone() {
    return (GoogleAppsCardV1CardFixedFooter) super.clone();
  }

}
