/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Column extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether widgets align to the left, right, or center of a column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String horizontalAlignment;

  /**
   * Specifies how a column fills the width of the card.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String horizontalSizeStyle;

  /**
   * Specifies whether widgets align to the top, bottom, or center of a column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verticalAlignment;

  /**
   * An array of widgets included in a column. Widgets appear in the order that they are specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1Widgets> widgets;

  /**
   * Specifies whether widgets align to the left, right, or center of a column.
   * @return value or {@code null} for none
   */
  public java.lang.String getHorizontalAlignment() {
    return horizontalAlignment;
  }

  /**
   * Specifies whether widgets align to the left, right, or center of a column.
   * @param horizontalAlignment horizontalAlignment or {@code null} for none
   */
  public GoogleAppsCardV1Column setHorizontalAlignment(java.lang.String horizontalAlignment) {
    this.horizontalAlignment = horizontalAlignment;
    return this;
  }

  /**
   * Specifies how a column fills the width of the card.
   * @return value or {@code null} for none
   */
  public java.lang.String getHorizontalSizeStyle() {
    return horizontalSizeStyle;
  }

  /**
   * Specifies how a column fills the width of the card.
   * @param horizontalSizeStyle horizontalSizeStyle or {@code null} for none
   */
  public GoogleAppsCardV1Column setHorizontalSizeStyle(java.lang.String horizontalSizeStyle) {
    this.horizontalSizeStyle = horizontalSizeStyle;
    return this;
  }

  /**
   * Specifies whether widgets align to the top, bottom, or center of a column.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerticalAlignment() {
    return verticalAlignment;
  }

  /**
   * Specifies whether widgets align to the top, bottom, or center of a column.
   * @param verticalAlignment verticalAlignment or {@code null} for none
   */
  public GoogleAppsCardV1Column setVerticalAlignment(java.lang.String verticalAlignment) {
    this.verticalAlignment = verticalAlignment;
    return this;
  }

  /**
   * An array of widgets included in a column. Widgets appear in the order that they are specified.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1Widgets> getWidgets() {
    return widgets;
  }

  /**
   * An array of widgets included in a column. Widgets appear in the order that they are specified.
   * @param widgets widgets or {@code null} for none
   */
  public GoogleAppsCardV1Column setWidgets(java.util.List<GoogleAppsCardV1Widgets> widgets) {
    this.widgets = widgets;
    return this;
  }

  @Override
  public GoogleAppsCardV1Column set(String fieldName, Object value) {
    return (GoogleAppsCardV1Column) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Column clone() {
    return (GoogleAppsCardV1Column) super.clone();
  }

}
