/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * The `Columns` widget displays up to 2 columns in a card message or dialog. You can add widgets to
 * each column; the widgets appear in the order that they are specified. For an example in Google
 * Chat apps, see [Columns](https://developers.google.com/chat/ui/widgets/columns). The height of
 * each column is determined by the taller column. For example, if the first column is taller than
 * the second column, both columns have the height of the first column. Because each column can
 * contain a different number of widgets, you can't define rows or align widgets between the
 * columns. Columns are displayed side-by-side. You can customize the width of each column using the
 * `HorizontalSizeStyle` field. If the user's screen width is too narrow, the second column wraps
 * below the first: * On web, the second column wraps if the screen width is less than or equal to
 * 480 pixels. * On iOS devices, the second column wraps if the screen width is less than or equal
 * to 300 pt. * On Android devices, the second column wraps if the screen width is less than or
 * equal to 320 dp. To include more than 2 columns, or to use rows, use the `Grid` widget. Supported
 * by Chat apps, but not Google Workspace Add-ons.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Columns extends com.google.api.client.json.GenericJson {

  /**
   * An array of columns. You can include up to 2 columns in a card or dialog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1Column> columnItems;

  static {
    // hack to force ProGuard to consider GoogleAppsCardV1Column used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsCardV1Column.class);
  }

  /**
   * An array of columns. You can include up to 2 columns in a card or dialog.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1Column> getColumnItems() {
    return columnItems;
  }

  /**
   * An array of columns. You can include up to 2 columns in a card or dialog.
   * @param columnItems columnItems or {@code null} for none
   */
  public GoogleAppsCardV1Columns setColumnItems(java.util.List<GoogleAppsCardV1Column> columnItems) {
    this.columnItems = columnItems;
    return this;
  }

  @Override
  public GoogleAppsCardV1Columns set(String fieldName, Object value) {
    return (GoogleAppsCardV1Columns) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Columns clone() {
    return (GoogleAppsCardV1Columns) super.clone();
  }

}
