/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * An item that users can select in a selection input, such as a checkbox or switch.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1SelectionItem extends com.google.api.client.json.GenericJson {

  /**
   * For multi-select menus, a text description or label that's displayed below the item's `text`
   * field. [Developer Preview](https://developers.google.com/workspace/preview).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bottomText;

  /**
   * Whether the item is selected by default. If the selection input only accepts one value (such as
   * for radio buttons or a dropdown menu), only set this field for one item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean selected;

  /**
   * For multi-select menus, the URL for the icon displayed next to the item's `text` field.
   * Supports PNG and JPEG files. Must be an `HTTPS` URL. For example,
   * `https://developers.google.com/chat/images/quickstart-app-avatar.png`. [Developer
   * Preview](https://developers.google.com/workspace/preview).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startIconUri;

  /**
   * The text that identifies or describes the item to users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * The value associated with this item. The client should use this as a form input value. For
   * details about working with form inputs, see [Receive form
   * data](https://developers.google.com/chat/ui/read-form-data).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * For multi-select menus, a text description or label that's displayed below the item's `text`
   * field. [Developer Preview](https://developers.google.com/workspace/preview).
   * @return value or {@code null} for none
   */
  public java.lang.String getBottomText() {
    return bottomText;
  }

  /**
   * For multi-select menus, a text description or label that's displayed below the item's `text`
   * field. [Developer Preview](https://developers.google.com/workspace/preview).
   * @param bottomText bottomText or {@code null} for none
   */
  public GoogleAppsCardV1SelectionItem setBottomText(java.lang.String bottomText) {
    this.bottomText = bottomText;
    return this;
  }

  /**
   * Whether the item is selected by default. If the selection input only accepts one value (such as
   * for radio buttons or a dropdown menu), only set this field for one item.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSelected() {
    return selected;
  }

  /**
   * Whether the item is selected by default. If the selection input only accepts one value (such as
   * for radio buttons or a dropdown menu), only set this field for one item.
   * @param selected selected or {@code null} for none
   */
  public GoogleAppsCardV1SelectionItem setSelected(java.lang.Boolean selected) {
    this.selected = selected;
    return this;
  }

  /**
   * For multi-select menus, the URL for the icon displayed next to the item's `text` field.
   * Supports PNG and JPEG files. Must be an `HTTPS` URL. For example,
   * `https://developers.google.com/chat/images/quickstart-app-avatar.png`. [Developer
   * Preview](https://developers.google.com/workspace/preview).
   * @return value or {@code null} for none
   */
  public java.lang.String getStartIconUri() {
    return startIconUri;
  }

  /**
   * For multi-select menus, the URL for the icon displayed next to the item's `text` field.
   * Supports PNG and JPEG files. Must be an `HTTPS` URL. For example,
   * `https://developers.google.com/chat/images/quickstart-app-avatar.png`. [Developer
   * Preview](https://developers.google.com/workspace/preview).
   * @param startIconUri startIconUri or {@code null} for none
   */
  public GoogleAppsCardV1SelectionItem setStartIconUri(java.lang.String startIconUri) {
    this.startIconUri = startIconUri;
    return this;
  }

  /**
   * The text that identifies or describes the item to users.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The text that identifies or describes the item to users.
   * @param text text or {@code null} for none
   */
  public GoogleAppsCardV1SelectionItem setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  /**
   * The value associated with this item. The client should use this as a form input value. For
   * details about working with form inputs, see [Receive form
   * data](https://developers.google.com/chat/ui/read-form-data).
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value associated with this item. The client should use this as a form input value. For
   * details about working with form inputs, see [Receive form
   * data](https://developers.google.com/chat/ui/read-form-data).
   * @param value value or {@code null} for none
   */
  public GoogleAppsCardV1SelectionItem setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public GoogleAppsCardV1SelectionItem set(String fieldName, Object value) {
    return (GoogleAppsCardV1SelectionItem) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1SelectionItem clone() {
    return (GoogleAppsCardV1SelectionItem) super.clone();
  }

}
