/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A UI element contains a key (label) and a value (content). This element can also contain some
 * actions such as `onclick` button.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KeyValue extends com.google.api.client.json.GenericJson {

  /**
   * The text of the bottom label. Formatted text supported. For more information about formatting
   * text, see [Formatting text in Google Chat apps](https://developers.google.com/chat/api/guides
   * /message-formats/cards#card_text_formatting) and [Formatting text in Google Workspace Add-
   * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bottomLabel;

  /**
   * A button that can be clicked to trigger an action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Button button;

  /**
   * The text of the content. Formatted text supported and always required. For more information
   * about formatting text, see [Formatting text in Google Chat
   * apps](https://developers.google.com/chat/api/guides/message-formats/cards#card_text_formatting)
   * and [Formatting text in Google Workspace Add-ons](https://developers.google.com/apps-script
   * /add-ons/concepts/widgets#text_formatting).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * If the content should be multiline.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean contentMultiline;

  /**
   * An enum value that's replaced by the Chat API with the corresponding icon image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String icon;

  /**
   * The icon specified by a URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconUrl;

  /**
   * The `onclick` action. Only the top label, bottom label, and content region are clickable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OnClick onClick;

  /**
   * The text of the top label. Formatted text supported. For more information about formatting
   * text, see [Formatting text in Google Chat apps](https://developers.google.com/chat/api/guides
   * /message-formats/cards#card_text_formatting) and [Formatting text in Google Workspace Add-
   * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topLabel;

  /**
   * The text of the bottom label. Formatted text supported. For more information about formatting
   * text, see [Formatting text in Google Chat apps](https://developers.google.com/chat/api/guides
   * /message-formats/cards#card_text_formatting) and [Formatting text in Google Workspace Add-
   * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * @return value or {@code null} for none
   */
  public java.lang.String getBottomLabel() {
    return bottomLabel;
  }

  /**
   * The text of the bottom label. Formatted text supported. For more information about formatting
   * text, see [Formatting text in Google Chat apps](https://developers.google.com/chat/api/guides
   * /message-formats/cards#card_text_formatting) and [Formatting text in Google Workspace Add-
   * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * @param bottomLabel bottomLabel or {@code null} for none
   */
  public KeyValue setBottomLabel(java.lang.String bottomLabel) {
    this.bottomLabel = bottomLabel;
    return this;
  }

  /**
   * A button that can be clicked to trigger an action.
   * @return value or {@code null} for none
   */
  public Button getButton() {
    return button;
  }

  /**
   * A button that can be clicked to trigger an action.
   * @param button button or {@code null} for none
   */
  public KeyValue setButton(Button button) {
    this.button = button;
    return this;
  }

  /**
   * The text of the content. Formatted text supported and always required. For more information
   * about formatting text, see [Formatting text in Google Chat
   * apps](https://developers.google.com/chat/api/guides/message-formats/cards#card_text_formatting)
   * and [Formatting text in Google Workspace Add-ons](https://developers.google.com/apps-script
   * /add-ons/concepts/widgets#text_formatting).
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The text of the content. Formatted text supported and always required. For more information
   * about formatting text, see [Formatting text in Google Chat
   * apps](https://developers.google.com/chat/api/guides/message-formats/cards#card_text_formatting)
   * and [Formatting text in Google Workspace Add-ons](https://developers.google.com/apps-script
   * /add-ons/concepts/widgets#text_formatting).
   * @param content content or {@code null} for none
   */
  public KeyValue setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * If the content should be multiline.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getContentMultiline() {
    return contentMultiline;
  }

  /**
   * If the content should be multiline.
   * @param contentMultiline contentMultiline or {@code null} for none
   */
  public KeyValue setContentMultiline(java.lang.Boolean contentMultiline) {
    this.contentMultiline = contentMultiline;
    return this;
  }

  /**
   * An enum value that's replaced by the Chat API with the corresponding icon image.
   * @return value or {@code null} for none
   */
  public java.lang.String getIcon() {
    return icon;
  }

  /**
   * An enum value that's replaced by the Chat API with the corresponding icon image.
   * @param icon icon or {@code null} for none
   */
  public KeyValue setIcon(java.lang.String icon) {
    this.icon = icon;
    return this;
  }

  /**
   * The icon specified by a URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconUrl() {
    return iconUrl;
  }

  /**
   * The icon specified by a URL.
   * @param iconUrl iconUrl or {@code null} for none
   */
  public KeyValue setIconUrl(java.lang.String iconUrl) {
    this.iconUrl = iconUrl;
    return this;
  }

  /**
   * The `onclick` action. Only the top label, bottom label, and content region are clickable.
   * @return value or {@code null} for none
   */
  public OnClick getOnClick() {
    return onClick;
  }

  /**
   * The `onclick` action. Only the top label, bottom label, and content region are clickable.
   * @param onClick onClick or {@code null} for none
   */
  public KeyValue setOnClick(OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  /**
   * The text of the top label. Formatted text supported. For more information about formatting
   * text, see [Formatting text in Google Chat apps](https://developers.google.com/chat/api/guides
   * /message-formats/cards#card_text_formatting) and [Formatting text in Google Workspace Add-
   * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * @return value or {@code null} for none
   */
  public java.lang.String getTopLabel() {
    return topLabel;
  }

  /**
   * The text of the top label. Formatted text supported. For more information about formatting
   * text, see [Formatting text in Google Chat apps](https://developers.google.com/chat/api/guides
   * /message-formats/cards#card_text_formatting) and [Formatting text in Google Workspace Add-
   * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   * @param topLabel topLabel or {@code null} for none
   */
  public KeyValue setTopLabel(java.lang.String topLabel) {
    this.topLabel = topLabel;
    return this;
  }

  @Override
  public KeyValue set(String fieldName, Object value) {
    return (KeyValue) super.set(fieldName, value);
  }

  @Override
  public KeyValue clone() {
    return (KeyValue) super.clone();
  }

}
