/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A space in Google Chat. Spaces are conversations between two or more users or 1:1 messages
 * between a user and a Chat app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Space extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Whether the Chat app was installed by a Google Workspace administrator.
   * Administrators can install a Chat app for their domain, organizational unit, or a group of
   * users. Administrators can only install Chat apps for direct messaging between users and the
   * app. To support admin install, your app must feature direct messaging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminInstalled;

  /**
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/chat/api/reference/rest/v1/spaces/create). If you receive
   * the error message `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace organization might
   * already use this display name. For direct messages, this field might be empty. Supports up to
   * 128 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Immutable. Whether this space permits any Google Chat user as a member. Input when creating a
   * space in a Google Workspace organization. For Google Chat users that use a Google Account, omit
   * this field when creating a space (By default, the space permits any Google Chat user). For
   * existing spaces, this field is output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean externalUserAllowed;

  /**
   * Resource name of the space. Format: `spaces/{space}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. Whether the space is a DM between a Chat app and a single human.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean singleUserBotDm;

  /**
   * Details about the space including description and rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpaceDetails spaceDetails;

  /**
   * The message history state for messages and threads in this space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceHistoryState;

  /**
   * Output only. The threading state in the Chat space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceThreadingState;

  /**
   * The type of space. Required when creating a space or updating the space type of a space. Output
   * only for other usage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceType;

  /**
   * Output only. Deprecated: Use `spaceThreadingState` instead. Whether messages are threaded in
   * this space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean threaded;

  /**
   * Output only. Deprecated: Use `space_type` instead. The type of a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. Whether the Chat app was installed by a Google Workspace administrator.
   * Administrators can install a Chat app for their domain, organizational unit, or a group of
   * users. Administrators can only install Chat apps for direct messaging between users and the
   * app. To support admin install, your app must feature direct messaging.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminInstalled() {
    return adminInstalled;
  }

  /**
   * Output only. Whether the Chat app was installed by a Google Workspace administrator.
   * Administrators can install a Chat app for their domain, organizational unit, or a group of
   * users. Administrators can only install Chat apps for direct messaging between users and the
   * app. To support admin install, your app must feature direct messaging.
   * @param adminInstalled adminInstalled or {@code null} for none
   */
  public Space setAdminInstalled(java.lang.Boolean adminInstalled) {
    this.adminInstalled = adminInstalled;
    return this;
  }

  /**
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/chat/api/reference/rest/v1/spaces/create). If you receive
   * the error message `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace organization might
   * already use this display name. For direct messages, this field might be empty. Supports up to
   * 128 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/chat/api/reference/rest/v1/spaces/create). If you receive
   * the error message `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
   * different `displayName`. An existing space within the Google Workspace organization might
   * already use this display name. For direct messages, this field might be empty. Supports up to
   * 128 characters.
   * @param displayName displayName or {@code null} for none
   */
  public Space setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Immutable. Whether this space permits any Google Chat user as a member. Input when creating a
   * space in a Google Workspace organization. For Google Chat users that use a Google Account, omit
   * this field when creating a space (By default, the space permits any Google Chat user). For
   * existing spaces, this field is output only.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExternalUserAllowed() {
    return externalUserAllowed;
  }

  /**
   * Immutable. Whether this space permits any Google Chat user as a member. Input when creating a
   * space in a Google Workspace organization. For Google Chat users that use a Google Account, omit
   * this field when creating a space (By default, the space permits any Google Chat user). For
   * existing spaces, this field is output only.
   * @param externalUserAllowed externalUserAllowed or {@code null} for none
   */
  public Space setExternalUserAllowed(java.lang.Boolean externalUserAllowed) {
    this.externalUserAllowed = externalUserAllowed;
    return this;
  }

  /**
   * Resource name of the space. Format: `spaces/{space}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the space. Format: `spaces/{space}`
   * @param name name or {@code null} for none
   */
  public Space setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. Whether the space is a DM between a Chat app and a single human.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSingleUserBotDm() {
    return singleUserBotDm;
  }

  /**
   * Optional. Whether the space is a DM between a Chat app and a single human.
   * @param singleUserBotDm singleUserBotDm or {@code null} for none
   */
  public Space setSingleUserBotDm(java.lang.Boolean singleUserBotDm) {
    this.singleUserBotDm = singleUserBotDm;
    return this;
  }

  /**
   * Details about the space including description and rules.
   * @return value or {@code null} for none
   */
  public SpaceDetails getSpaceDetails() {
    return spaceDetails;
  }

  /**
   * Details about the space including description and rules.
   * @param spaceDetails spaceDetails or {@code null} for none
   */
  public Space setSpaceDetails(SpaceDetails spaceDetails) {
    this.spaceDetails = spaceDetails;
    return this;
  }

  /**
   * The message history state for messages and threads in this space.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceHistoryState() {
    return spaceHistoryState;
  }

  /**
   * The message history state for messages and threads in this space.
   * @param spaceHistoryState spaceHistoryState or {@code null} for none
   */
  public Space setSpaceHistoryState(java.lang.String spaceHistoryState) {
    this.spaceHistoryState = spaceHistoryState;
    return this;
  }

  /**
   * Output only. The threading state in the Chat space.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceThreadingState() {
    return spaceThreadingState;
  }

  /**
   * Output only. The threading state in the Chat space.
   * @param spaceThreadingState spaceThreadingState or {@code null} for none
   */
  public Space setSpaceThreadingState(java.lang.String spaceThreadingState) {
    this.spaceThreadingState = spaceThreadingState;
    return this;
  }

  /**
   * The type of space. Required when creating a space or updating the space type of a space. Output
   * only for other usage.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceType() {
    return spaceType;
  }

  /**
   * The type of space. Required when creating a space or updating the space type of a space. Output
   * only for other usage.
   * @param spaceType spaceType or {@code null} for none
   */
  public Space setSpaceType(java.lang.String spaceType) {
    this.spaceType = spaceType;
    return this;
  }

  /**
   * Output only. Deprecated: Use `spaceThreadingState` instead. Whether messages are threaded in
   * this space.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getThreaded() {
    return threaded;
  }

  /**
   * Output only. Deprecated: Use `spaceThreadingState` instead. Whether messages are threaded in
   * this space.
   * @param threaded threaded or {@code null} for none
   */
  public Space setThreaded(java.lang.Boolean threaded) {
    this.threaded = threaded;
    return this;
  }

  /**
   * Output only. Deprecated: Use `space_type` instead. The type of a space.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Deprecated: Use `space_type` instead. The type of a space.
   * @param type type or {@code null} for none
   */
  public Space setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Space set(String fieldName, Object value) {
    return (Space) super.set(fieldName, value);
  }

  @Override
  public Space clone() {
    return (Space) super.clone();
  }

}
