/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * The timezone ID and offset from Coordinated Universal Time (UTC). Only supported for the event
 * types [`CARD_CLICKED`](https://developers.google.com/chat/api/reference/rest/v1/EventType#ENUM_VA
 * LUES.CARD_CLICKED) and [`SUBMIT_DIALOG`](https://developers.google.com/chat/api/reference/rest/v1
 * /DialogEventType#ENUM_VALUES.SUBMIT_DIALOG).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimeZone extends com.google.api.client.json.GenericJson {

  /**
   * The [IANA TZ](https://www.iana.org/time-zones) time zone database code, such as
   * "America/Toronto".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The user timezone offset, in milliseconds, from Coordinated Universal Time (UTC).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer offset;

  /**
   * The [IANA TZ](https://www.iana.org/time-zones) time zone database code, such as
   * "America/Toronto".
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The [IANA TZ](https://www.iana.org/time-zones) time zone database code, such as
   * "America/Toronto".
   * @param id id or {@code null} for none
   */
  public TimeZone setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The user timezone offset, in milliseconds, from Coordinated Universal Time (UTC).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOffset() {
    return offset;
  }

  /**
   * The user timezone offset, in milliseconds, from Coordinated Universal Time (UTC).
   * @param offset offset or {@code null} for none
   */
  public TimeZone setOffset(java.lang.Integer offset) {
    this.offset = offset;
    return this;
  }

  @Override
  public TimeZone set(String fieldName, Object value) {
    return (TimeZone) super.set(fieldName, value);
  }

  @Override
  public TimeZone clone() {
    return (TimeZone) super.clone();
  }

}
