/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * List of string parameters to supply when the action method is invoked. For example, consider
 * three snooze buttons: snooze now, snooze one day, snooze next week. You might use `action method
 * = snooze()`, passing the snooze type and snooze time in the list of string parameters.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActionParameter extends com.google.api.client.json.GenericJson {

  /**
   * The name of the parameter for the action script.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * The value of the parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The name of the parameter for the action script.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * The name of the parameter for the action script.
   * @param key key or {@code null} for none
   */
  public ActionParameter setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * The value of the parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value of the parameter.
   * @param value value or {@code null} for none
   */
  public ActionParameter setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public ActionParameter set(String fieldName, Object value) {
    return (ActionParameter) super.set(fieldName, value);
  }

  @Override
  public ActionParameter clone() {
    return (ActionParameter) super.clone();
  }

}
