/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Information about a deleted message. A message is deleted when `delete_time` is set.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeletionMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Indicates who deleted the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deletionType;

  /**
   * Indicates who deleted the message.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeletionType() {
    return deletionType;
  }

  /**
   * Indicates who deleted the message.
   * @param deletionType deletionType or {@code null} for none
   */
  public DeletionMetadata setDeletionType(java.lang.String deletionType) {
    this.deletionType = deletionType;
    return this;
  }

  @Override
  public DeletionMetadata set(String fieldName, Object value) {
    return (DeletionMetadata) super.set(fieldName, value);
  }

  @Override
  public DeletionMetadata clone() {
    return (DeletionMetadata) super.clone();
  }

}
