/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A widget that creates one or more UI items that users can select. For example, a dropdown menu or
 * checkboxes. You can use this widget to collect data that can be predicted or enumerated. For an
 * example in Google Chat apps, see [Add selectable UI elements](/workspace/chat/design-interactive-
 * card-dialog#add_selectable_ui_elements). Chat apps can process the value of items that users
 * select or input. For details about working with form inputs, see [Receive form
 * data](https://developers.google.com/workspace/chat/read-form-data). To collect undefined or
 * abstract data from users, use the TextInput widget. [Google Workspace Add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1SelectionInput extends com.google.api.client.json.GenericJson {

  /**
   * An external data source, such as a relational data base.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Action externalDataSource;

  /**
   * An array of selectable items. For example, an array of radio buttons or checkboxes. Supports up
   * to 100 items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1SelectionItem> items;

  /**
   * The text that appears above the selection input field in the user interface. Specify text that
   * helps the user enter the information your app needs. For example, if users are selecting the
   * urgency of a work ticket from a drop-down menu, the label might be "Urgency" or "Select
   * urgency".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * For multiselect menus, the maximum number of items that a user can select. Minimum value is 1
   * item. If unspecified, defaults to 3 items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer multiSelectMaxSelectedItems;

  /**
   * For multiselect menus, the number of text characters that a user inputs before the app queries
   * autocomplete and displays suggested items in the menu. If unspecified, defaults to 0 characters
   * for static data sources and 3 characters for external data sources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer multiSelectMinQueryLength;

  /**
   * The name that identifies the selection input in a form input event. For details about working
   * with form inputs, see [Receive form data](https://developers.google.com/workspace/chat/read-
   * form-data).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * If specified, the form is submitted when the selection changes. If not specified, you must
   * specify a separate button that submits the form. For details about working with form inputs,
   * see [Receive form data](https://developers.google.com/workspace/chat/read-form-data).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Action onChangeAction;

  /**
   * A data source from Google Workspace.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1PlatformDataSource platformDataSource;

  /**
   * The type of items that are displayed to users in a `SelectionInput` widget. Selection types
   * support different types of interactions. For example, users can select one or more checkboxes,
   * but they can only select one value from a dropdown menu.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * An external data source, such as a relational data base.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Action getExternalDataSource() {
    return externalDataSource;
  }

  /**
   * An external data source, such as a relational data base.
   * @param externalDataSource externalDataSource or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setExternalDataSource(GoogleAppsCardV1Action externalDataSource) {
    this.externalDataSource = externalDataSource;
    return this;
  }

  /**
   * An array of selectable items. For example, an array of radio buttons or checkboxes. Supports up
   * to 100 items.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1SelectionItem> getItems() {
    return items;
  }

  /**
   * An array of selectable items. For example, an array of radio buttons or checkboxes. Supports up
   * to 100 items.
   * @param items items or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setItems(java.util.List<GoogleAppsCardV1SelectionItem> items) {
    this.items = items;
    return this;
  }

  /**
   * The text that appears above the selection input field in the user interface. Specify text that
   * helps the user enter the information your app needs. For example, if users are selecting the
   * urgency of a work ticket from a drop-down menu, the label might be "Urgency" or "Select
   * urgency".
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The text that appears above the selection input field in the user interface. Specify text that
   * helps the user enter the information your app needs. For example, if users are selecting the
   * urgency of a work ticket from a drop-down menu, the label might be "Urgency" or "Select
   * urgency".
   * @param label label or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * For multiselect menus, the maximum number of items that a user can select. Minimum value is 1
   * item. If unspecified, defaults to 3 items.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMultiSelectMaxSelectedItems() {
    return multiSelectMaxSelectedItems;
  }

  /**
   * For multiselect menus, the maximum number of items that a user can select. Minimum value is 1
   * item. If unspecified, defaults to 3 items.
   * @param multiSelectMaxSelectedItems multiSelectMaxSelectedItems or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setMultiSelectMaxSelectedItems(java.lang.Integer multiSelectMaxSelectedItems) {
    this.multiSelectMaxSelectedItems = multiSelectMaxSelectedItems;
    return this;
  }

  /**
   * For multiselect menus, the number of text characters that a user inputs before the app queries
   * autocomplete and displays suggested items in the menu. If unspecified, defaults to 0 characters
   * for static data sources and 3 characters for external data sources.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMultiSelectMinQueryLength() {
    return multiSelectMinQueryLength;
  }

  /**
   * For multiselect menus, the number of text characters that a user inputs before the app queries
   * autocomplete and displays suggested items in the menu. If unspecified, defaults to 0 characters
   * for static data sources and 3 characters for external data sources.
   * @param multiSelectMinQueryLength multiSelectMinQueryLength or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setMultiSelectMinQueryLength(java.lang.Integer multiSelectMinQueryLength) {
    this.multiSelectMinQueryLength = multiSelectMinQueryLength;
    return this;
  }

  /**
   * The name that identifies the selection input in a form input event. For details about working
   * with form inputs, see [Receive form data](https://developers.google.com/workspace/chat/read-
   * form-data).
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name that identifies the selection input in a form input event. For details about working
   * with form inputs, see [Receive form data](https://developers.google.com/workspace/chat/read-
   * form-data).
   * @param name name or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * If specified, the form is submitted when the selection changes. If not specified, you must
   * specify a separate button that submits the form. For details about working with form inputs,
   * see [Receive form data](https://developers.google.com/workspace/chat/read-form-data).
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Action getOnChangeAction() {
    return onChangeAction;
  }

  /**
   * If specified, the form is submitted when the selection changes. If not specified, you must
   * specify a separate button that submits the form. For details about working with form inputs,
   * see [Receive form data](https://developers.google.com/workspace/chat/read-form-data).
   * @param onChangeAction onChangeAction or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setOnChangeAction(GoogleAppsCardV1Action onChangeAction) {
    this.onChangeAction = onChangeAction;
    return this;
  }

  /**
   * A data source from Google Workspace.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1PlatformDataSource getPlatformDataSource() {
    return platformDataSource;
  }

  /**
   * A data source from Google Workspace.
   * @param platformDataSource platformDataSource or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setPlatformDataSource(GoogleAppsCardV1PlatformDataSource platformDataSource) {
    this.platformDataSource = platformDataSource;
    return this;
  }

  /**
   * The type of items that are displayed to users in a `SelectionInput` widget. Selection types
   * support different types of interactions. For example, users can select one or more checkboxes,
   * but they can only select one value from a dropdown menu.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of items that are displayed to users in a `SelectionInput` widget. Selection types
   * support different types of interactions. For example, users can select one or more checkboxes,
   * but they can only select one value from a dropdown menu.
   * @param type type or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public GoogleAppsCardV1SelectionInput set(String fieldName, Object value) {
    return (GoogleAppsCardV1SelectionInput) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1SelectionInput clone() {
    return (GoogleAppsCardV1SelectionInput) super.clone();
  }

}
