/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A paragraph of text that supports formatting. For an example in Google Chat apps, see [Add a
 * paragraph of formatted text](https://developers.google.com/workspace/chat/add-text-image-card-
 * dialog#add_a_paragraph_of_formatted_text). For more information about formatting text, see
 * [Formatting text in Google Chat apps](https://developers.google.com/workspace/chat/format-
 * messages#card-formatting) and [Formatting text in Google Workspace Add-
 * ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting). [Google
 * Workspace Add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1TextParagraph extends com.google.api.client.json.GenericJson {

  /**
   * The text that's shown in the widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * The text that's shown in the widget.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The text that's shown in the widget.
   * @param text text or {@code null} for none
   */
  public GoogleAppsCardV1TextParagraph setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public GoogleAppsCardV1TextParagraph set(String fieldName, Object value) {
    return (GoogleAppsCardV1TextParagraph) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1TextParagraph clone() {
    return (GoogleAppsCardV1TextParagraph) super.clone();
  }

}
