/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Types of data that users can [input on cards or dialogs](https://developers.google.com/chat/ui
 * /read-form-data). The input type depends on the type of values that the widget accepts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Inputs extends com.google.api.client.json.GenericJson {

  /**
   * Date input values from a [`DateTimePicker`](https://developers.google.com/chat/api/reference/re
   * st/v1/cards#DateTimePicker) widget that only accepts date values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateInput dateInput;

  /**
   * Date and time input values from a [`DateTimePicker`](https://developers.google.com/chat/api/ref
   * erence/rest/v1/cards#DateTimePicker) widget that accepts both a date and time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTimeInput dateTimeInput;

  /**
   * A list of strings that represent the values that the user inputs in a widget. If the widget
   * only accepts one value, such as a
   * [`TextInput`](https://developers.google.com/chat/api/reference/rest/v1/cards#TextInput) widget,
   * the list contains one string object. If the widget accepts multiple values, such as a [`Selecti
   * onInput`](https://developers.google.com/chat/api/reference/rest/v1/cards#selectioninput) widget
   * of checkboxes, the list contains a string object for each value that the user inputs or
   * selects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StringInputs stringInputs;

  /**
   * Time input values from a [`DateTimePicker`](https://developers.google.com/chat/api/reference/re
   * st/v1/cards#DateTimePicker) widget that only accepts time values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeInput timeInput;

  /**
   * Date input values from a [`DateTimePicker`](https://developers.google.com/chat/api/reference/re
   * st/v1/cards#DateTimePicker) widget that only accepts date values.
   * @return value or {@code null} for none
   */
  public DateInput getDateInput() {
    return dateInput;
  }

  /**
   * Date input values from a [`DateTimePicker`](https://developers.google.com/chat/api/reference/re
   * st/v1/cards#DateTimePicker) widget that only accepts date values.
   * @param dateInput dateInput or {@code null} for none
   */
  public Inputs setDateInput(DateInput dateInput) {
    this.dateInput = dateInput;
    return this;
  }

  /**
   * Date and time input values from a [`DateTimePicker`](https://developers.google.com/chat/api/ref
   * erence/rest/v1/cards#DateTimePicker) widget that accepts both a date and time.
   * @return value or {@code null} for none
   */
  public DateTimeInput getDateTimeInput() {
    return dateTimeInput;
  }

  /**
   * Date and time input values from a [`DateTimePicker`](https://developers.google.com/chat/api/ref
   * erence/rest/v1/cards#DateTimePicker) widget that accepts both a date and time.
   * @param dateTimeInput dateTimeInput or {@code null} for none
   */
  public Inputs setDateTimeInput(DateTimeInput dateTimeInput) {
    this.dateTimeInput = dateTimeInput;
    return this;
  }

  /**
   * A list of strings that represent the values that the user inputs in a widget. If the widget
   * only accepts one value, such as a
   * [`TextInput`](https://developers.google.com/chat/api/reference/rest/v1/cards#TextInput) widget,
   * the list contains one string object. If the widget accepts multiple values, such as a [`Selecti
   * onInput`](https://developers.google.com/chat/api/reference/rest/v1/cards#selectioninput) widget
   * of checkboxes, the list contains a string object for each value that the user inputs or
   * selects.
   * @return value or {@code null} for none
   */
  public StringInputs getStringInputs() {
    return stringInputs;
  }

  /**
   * A list of strings that represent the values that the user inputs in a widget. If the widget
   * only accepts one value, such as a
   * [`TextInput`](https://developers.google.com/chat/api/reference/rest/v1/cards#TextInput) widget,
   * the list contains one string object. If the widget accepts multiple values, such as a [`Selecti
   * onInput`](https://developers.google.com/chat/api/reference/rest/v1/cards#selectioninput) widget
   * of checkboxes, the list contains a string object for each value that the user inputs or
   * selects.
   * @param stringInputs stringInputs or {@code null} for none
   */
  public Inputs setStringInputs(StringInputs stringInputs) {
    this.stringInputs = stringInputs;
    return this;
  }

  /**
   * Time input values from a [`DateTimePicker`](https://developers.google.com/chat/api/reference/re
   * st/v1/cards#DateTimePicker) widget that only accepts time values.
   * @return value or {@code null} for none
   */
  public TimeInput getTimeInput() {
    return timeInput;
  }

  /**
   * Time input values from a [`DateTimePicker`](https://developers.google.com/chat/api/reference/re
   * st/v1/cards#DateTimePicker) widget that only accepts time values.
   * @param timeInput timeInput or {@code null} for none
   */
  public Inputs setTimeInput(TimeInput timeInput) {
    this.timeInput = timeInput;
    return this;
  }

  @Override
  public Inputs set(String fieldName, Object value) {
    return (Inputs) super.set(fieldName, value);
  }

  @Override
  public Inputs clone() {
    return (Inputs) super.clone();
  }

}
