/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Data for Google Drive links.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DriveLinkData extends com.google.api.client.json.GenericJson {

  /**
   * A [DriveDataRef](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.mess
   * ages.attachments#drivedataref) which references a Google Drive file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DriveDataRef driveDataRef;

  /**
   * The mime type of the linked Google Drive resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * A [DriveDataRef](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.mess
   * ages.attachments#drivedataref) which references a Google Drive file.
   * @return value or {@code null} for none
   */
  public DriveDataRef getDriveDataRef() {
    return driveDataRef;
  }

  /**
   * A [DriveDataRef](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.mess
   * ages.attachments#drivedataref) which references a Google Drive file.
   * @param driveDataRef driveDataRef or {@code null} for none
   */
  public DriveLinkData setDriveDataRef(DriveDataRef driveDataRef) {
    this.driveDataRef = driveDataRef;
    return this;
  }

  /**
   * The mime type of the linked Google Drive resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * The mime type of the linked Google Drive resource.
   * @param mimeType mimeType or {@code null} for none
   */
  public DriveLinkData setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  @Override
  public DriveLinkData set(String fieldName, Object value) {
    return (DriveLinkData) super.set(fieldName, value);
  }

  @Override
  public DriveLinkData clone() {
    return (DriveLinkData) super.clone();
  }

}
