/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * For a `SelectionInput` widget that uses a multiselect menu, a data source from Google Workspace.
 * Used to populate items in a multiselect menu. [Google Chat
 * apps](https://developers.google.com/workspace/chat):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1PlatformDataSource extends com.google.api.client.json.GenericJson {

  /**
   * A data source shared by all Google Workspace applications, such as users in a Google Workspace
   * organization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commonDataSource;

  /**
   * A data source that's unique to a Google Workspace host application, such spaces in Google Chat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HostAppDataSourceMarkup hostAppDataSource;

  /**
   * A data source shared by all Google Workspace applications, such as users in a Google Workspace
   * organization.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommonDataSource() {
    return commonDataSource;
  }

  /**
   * A data source shared by all Google Workspace applications, such as users in a Google Workspace
   * organization.
   * @param commonDataSource commonDataSource or {@code null} for none
   */
  public GoogleAppsCardV1PlatformDataSource setCommonDataSource(java.lang.String commonDataSource) {
    this.commonDataSource = commonDataSource;
    return this;
  }

  /**
   * A data source that's unique to a Google Workspace host application, such spaces in Google Chat.
   * @return value or {@code null} for none
   */
  public HostAppDataSourceMarkup getHostAppDataSource() {
    return hostAppDataSource;
  }

  /**
   * A data source that's unique to a Google Workspace host application, such spaces in Google Chat.
   * @param hostAppDataSource hostAppDataSource or {@code null} for none
   */
  public GoogleAppsCardV1PlatformDataSource setHostAppDataSource(HostAppDataSourceMarkup hostAppDataSource) {
    this.hostAppDataSource = hostAppDataSource;
    return this;
  }

  @Override
  public GoogleAppsCardV1PlatformDataSource set(String fieldName, Object value) {
    return (GoogleAppsCardV1PlatformDataSource) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1PlatformDataSource clone() {
    return (GoogleAppsCardV1PlatformDataSource) super.clone();
  }

}
