/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Suggested values that users can enter. These values appear when users click inside the text input
 * field. As users type, the suggested values dynamically filter to match what the users have typed.
 * For example, a text input field for programming language might suggest Java, JavaScript, Python,
 * and C++. When users start typing `Jav`, the list of suggestions filters to show `Java` and
 * `JavaScript`. Suggested values help guide users to enter values that your app can make sense of.
 * When referring to JavaScript, some users might enter `javascript` and others `java script`.
 * Suggesting `JavaScript` can standardize how users interact with your app. When specified,
 * `TextInput.type` is always `SINGLE_LINE`, even if it's set to `MULTIPLE_LINE`. [Google Workspace
 * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Suggestions extends com.google.api.client.json.GenericJson {

  /**
   * A list of suggestions used for autocomplete recommendations in text input fields.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1SuggestionItem> items;

  static {
    // hack to force ProGuard to consider GoogleAppsCardV1SuggestionItem used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsCardV1SuggestionItem.class);
  }

  /**
   * A list of suggestions used for autocomplete recommendations in text input fields.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1SuggestionItem> getItems() {
    return items;
  }

  /**
   * A list of suggestions used for autocomplete recommendations in text input fields.
   * @param items items or {@code null} for none
   */
  public GoogleAppsCardV1Suggestions setItems(java.util.List<GoogleAppsCardV1SuggestionItem> items) {
    this.items = items;
    return this;
  }

  @Override
  public GoogleAppsCardV1Suggestions set(String fieldName, Object value) {
    return (GoogleAppsCardV1Suggestions) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Suggestions clone() {
    return (GoogleAppsCardV1Suggestions) super.clone();
  }

}
