/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Event payload for multiple updated messages. Event type:
 * `google.workspace.chat.message.v1.batchUpdated`
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MessageBatchUpdatedEventData extends com.google.api.client.json.GenericJson {

  /**
   * A list of updated messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MessageUpdatedEventData> messages;

  /**
   * A list of updated messages.
   * @return value or {@code null} for none
   */
  public java.util.List<MessageUpdatedEventData> getMessages() {
    return messages;
  }

  /**
   * A list of updated messages.
   * @param messages messages or {@code null} for none
   */
  public MessageBatchUpdatedEventData setMessages(java.util.List<MessageUpdatedEventData> messages) {
    this.messages = messages;
    return this;
  }

  @Override
  public MessageBatchUpdatedEventData set(String fieldName, Object value) {
    return (MessageBatchUpdatedEventData) super.set(fieldName, value);
  }

  @Override
  public MessageBatchUpdatedEventData clone() {
    return (MessageBatchUpdatedEventData) super.clone();
  }

}
