/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A thread in a Google Chat space. For example usage, see [Start or reply to a message
 * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread). If
 * you specify a thread when creating a message, you can set the [`messageReplyOption`](https://deve
 * lopers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#messagereplyoption)
 * field to determine what happens if no matching thread is found.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Thread extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Resource name of the thread. Example: `spaces/{space}/threads/{thread}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. Input for creating or updating a thread. Otherwise, output only. ID for the thread.
   * Supports up to 4000 characters. This ID is unique to the Chat app that sets it. For example, if
   * multiple Chat apps create a message using the same thread key, the messages are posted in
   * different threads. To reply in a thread created by a person or another Chat app, specify the
   * thread `name` field instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String threadKey;

  /**
   * Output only. Resource name of the thread. Example: `spaces/{space}/threads/{thread}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of the thread. Example: `spaces/{space}/threads/{thread}`
   * @param name name or {@code null} for none
   */
  public Thread setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. Input for creating or updating a thread. Otherwise, output only. ID for the thread.
   * Supports up to 4000 characters. This ID is unique to the Chat app that sets it. For example, if
   * multiple Chat apps create a message using the same thread key, the messages are posted in
   * different threads. To reply in a thread created by a person or another Chat app, specify the
   * thread `name` field instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getThreadKey() {
    return threadKey;
  }

  /**
   * Optional. Input for creating or updating a thread. Otherwise, output only. ID for the thread.
   * Supports up to 4000 characters. This ID is unique to the Chat app that sets it. For example, if
   * multiple Chat apps create a message using the same thread key, the messages are posted in
   * different threads. To reply in a thread created by a person or another Chat app, specify the
   * thread `name` field instead.
   * @param threadKey threadKey or {@code null} for none
   */
  public Thread setThreadKey(java.lang.String threadKey) {
    this.threadKey = threadKey;
    return this;
  }

  @Override
  public Thread set(String fieldName, Object value) {
    return (Thread) super.set(fieldName, value);
  }

  @Override
  public Thread clone() {
    return (Thread) super.clone();
  }

}
